/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.KeywordManager;
import com.dgtlrepublic.anitomyj.Options;
import com.dgtlrepublic.anitomyj.Parser;
import com.dgtlrepublic.anitomyj.StringHelper;
import com.dgtlrepublic.anitomyj.Token;
import com.dgtlrepublic.anitomyj.Tokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class AnitomyJ {
    private AnitomyJ() {
    }

    public static List<Element> parse(String filename) {
        AtomicReference<String> extension;
        Options options = new Options();
        ArrayList<Element> elements = new ArrayList<Element>(32);
        ArrayList<Token> tokens = new ArrayList<Token>();
        AtomicReference<String> fname = new AtomicReference<String>(filename);
        if (options.parseFileExtension && AnitomyJ.removeExtensionFromFilename(fname, extension = new AtomicReference<String>())) {
            elements.add(new Element(Element.ElementCategory.kElementFileExtension, extension.get()));
        }
        if (fname.get() == null || fname.get().length() == 0) {
            return elements;
        }
        elements.add(new Element(Element.ElementCategory.kElementFileName, fname.get()));
        boolean isTokenized = new Tokenizer(fname.get(), elements, options, tokens).tokenize();
        if (!isTokenized) {
            return elements;
        }
        new Parser(elements, options, tokens).parse();
        return elements;
    }

    private static boolean removeExtensionFromFilename(AtomicReference<String> filename, AtomicReference<String> extension) {
        int position;
        if (StringUtils.isEmpty((CharSequence)filename.get()) || (position = filename.get().lastIndexOf(46)) == -1) {
            return false;
        }
        extension.set(filename.get().substring(position + 1));
        if (extension.get().length() > 4) {
            return false;
        }
        if (!StringHelper.isAlphanumericString(extension.get())) {
            return false;
        }
        String keyword = KeywordManager.normalzie(extension.get());
        if (!KeywordManager.getInstance().contains(Element.ElementCategory.kElementFileExtension, keyword)) {
            return false;
        }
        filename.set(filename.get().substring(0, position));
        return true;
    }

    static {
        KeywordManager.getInstance();
    }
}

