/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.TokenRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class KeywordManager {
    private final Map<String, Keyword> keys = new HashMap<String, Keyword>();
    private final Map<String, Keyword> file_extensions = new HashMap<String, Keyword>();
    private final List<Pair<Element.ElementCategory, List<String>>> peekEntries;
    private static final KeywordManager instance = new KeywordManager();

    private KeywordManager() {
        KeywordOptions optionsDefault = new KeywordOptions();
        KeywordOptions optionsInvalid = new KeywordOptions(true, true, false);
        KeywordOptions optionsUnidentifiable = new KeywordOptions(false, true, true);
        KeywordOptions optionsUnidentifiableInvalid = new KeywordOptions(false, true, false);
        KeywordOptions optionsUnidentifiableUnsearchable = new KeywordOptions(false, false, true);
        this.add(Element.ElementCategory.kElementAnimeSeasonPrefix, optionsUnidentifiable, Arrays.asList("SAISON", "SEASON"));
        this.add(Element.ElementCategory.kElementAnimeType, optionsUnidentifiable, Arrays.asList("GEKIJOUBAN", "MOVIE", "OAD", "OAV", "ONA", "OVA", "SPECIAL", "SPECIALS", "TV"));
        this.add(Element.ElementCategory.kElementAnimeType, optionsUnidentifiableUnsearchable, Arrays.asList("SP"));
        this.add(Element.ElementCategory.kElementAnimeType, optionsUnidentifiableInvalid, Arrays.asList("ED", "ENDING", "NCED", "NCOP", "OP", "OPENING", "PREVIEW", "PV"));
        this.add(Element.ElementCategory.kElementAudioTerm, optionsDefault, Arrays.asList("2.0CH", "2CH", "5.1", "5.1CH", "DTS", "DTS-ES", "DTS5.1", "TRUEHD5.1", "AAC", "AACX2", "AACX3", "AACX4", "AC3", "FLAC", "FLACX2", "FLACX3", "FLACX4", "LOSSLESS", "MP3", "OGG", "VORBIS", "DUALAUDIO", "DUAL AUDIO"));
        this.add(Element.ElementCategory.kElementDeviceCompatibility, optionsDefault, Arrays.asList("IPAD3", "IPHONE5", "IPOD", "PS3", "XBOX", "XBOX360"));
        this.add(Element.ElementCategory.kElementDeviceCompatibility, optionsUnidentifiable, Arrays.asList("ANDROID"));
        this.add(Element.ElementCategory.kElementEpisodePrefix, optionsDefault, Arrays.asList("EP", "EP.", "EPS", "EPS.", "EPISODE", "EPISODE.", "EPISODES", "CAPITULO", "EPISODIO", "FOLGE"));
        this.add(Element.ElementCategory.kElementEpisodePrefix, optionsInvalid, Arrays.asList("E", "\\x7B2C"));
        this.add(Element.ElementCategory.kElementFileExtension, optionsDefault, Arrays.asList("3GP", "AVI", "DIVX", "FLV", "M2TS", "MKV", "MOV", "MP4", "MPG", "OGM", "RM", "RMVB", "WEBM", "WMV"));
        this.add(Element.ElementCategory.kElementFileExtension, optionsInvalid, Arrays.asList("AAC", "AIFF", "FLAC", "M4A", "MP3", "MKA", "OGG", "WAV", "WMA", "7Z", "RAR", "ZIP", "ASS", "SRT"));
        this.add(Element.ElementCategory.kElementLanguage, optionsDefault, Arrays.asList("ENG", "ENGLISH", "ESPANO", "JAP", "PT-BR", "SPANISH", "VOSTFR"));
        this.add(Element.ElementCategory.kElementLanguage, optionsUnidentifiable, Arrays.asList("ESP", "ITA"));
        this.add(Element.ElementCategory.kElementOther, optionsDefault, Arrays.asList("REMASTER", "REMASTERED", "UNCENSORED", "UNCUT", "TS", "VFR", "WIDESCREEN", "WS"));
        this.add(Element.ElementCategory.kElementReleaseGroup, optionsDefault, Arrays.asList("THORA"));
        this.add(Element.ElementCategory.kElementReleaseInformation, optionsDefault, Arrays.asList("BATCH", "COMPLETE", "PATCH", "REMUX"));
        this.add(Element.ElementCategory.kElementReleaseInformation, optionsUnidentifiable, Arrays.asList("END", "FINAL"));
        this.add(Element.ElementCategory.kElementReleaseVersion, optionsDefault, Arrays.asList("V0", "V1", "V2", "V3", "V4"));
        this.add(Element.ElementCategory.kElementSource, optionsDefault, Arrays.asList("BD", "BDRIP", "BLURAY", "BLU-RAY", "DVD", "DVD5", "DVD9", "DVD-R2J", "DVDRIP", "DVD-RIP", "R2DVD", "R2J", "R2JDVD", "R2JDVDRIP", "HDTV", "HDTVRIP", "TVRIP", "TV-RIP", "WEBCAST", "WEBRIP"));
        this.add(Element.ElementCategory.kElementSubtitles, optionsDefault, Arrays.asList("ASS", "BIG5", "DUB", "DUBBED", "HARDSUB", "RAW", "SOFTSUB", "SOFTSUBS", "SUB", "SUBBED", "SUBTITLED"));
        this.add(Element.ElementCategory.kElementVideoTerm, optionsDefault, Arrays.asList("23.976FPS", "24FPS", "29.97FPS", "30FPS", "60FPS", "120FPS", "8BIT", "8-BIT", "10BIT", "10BITS", "10-BIT", "10-BITS", "HI10P", "H264", "H265", "H.264", "H.265", "X264", "X265", "X.264", "AVC", "HEVC", "DIVX", "DIVX5", "DIVX6", "XVID", "AVI", "RMVB", "WMV", "WMV3", "WMV9", "HQ", "LQ", "HD", "SD"));
        this.add(Element.ElementCategory.kElementVolumePrefix, optionsDefault, Arrays.asList("VOL", "VOL.", "VOLUME"));
        this.peekEntries = new ArrayList<Pair<Element.ElementCategory, List<String>>>(){
            {
                this.add(Pair.of((Object)((Object)Element.ElementCategory.kElementAudioTerm), Arrays.asList("Dual Audio")));
                this.add(Pair.of((Object)((Object)Element.ElementCategory.kElementVideoTerm), Arrays.asList("H264", "H.264", "h264", "h.264")));
                this.add(Pair.of((Object)((Object)Element.ElementCategory.kElementVideoResolution), Arrays.asList("480p", "720p", "1080p")));
                this.add(Pair.of((Object)((Object)Element.ElementCategory.kElementSource), Arrays.asList("Blu-Ray")));
            }
        };
    }

    public static KeywordManager getInstance() {
        return instance;
    }

    public static String normalzie(String word) {
        if (StringUtils.isEmpty((CharSequence)word)) {
            return word;
        }
        return word.toUpperCase(Locale.ENGLISH);
    }

    public boolean contains(Element.ElementCategory category, String keyword) {
        Map<String, Keyword> keys = this.getKeywordContainer(category);
        Keyword foundEntry = keys.get(keyword);
        return foundEntry != null && foundEntry.getCategory() == category;
    }

    public boolean findAndSet(String keyword, AtomicReference<Element.ElementCategory> category, AtomicReference<KeywordOptions> options) {
        Map<String, Keyword> keys = this.getKeywordContainer(category.get());
        Keyword foundEntry = keys.get(keyword);
        if (foundEntry != null) {
            if (category.get() == Element.ElementCategory.kElementUnknown) {
                category.set(foundEntry.getCategory());
            } else if (foundEntry.getCategory() != category.get()) {
                return false;
            }
            options.set(foundEntry.getOptions());
            return true;
        }
        return false;
    }

    public void peekAndAdd(String filename, TokenRange range, List<Element> elements, List<TokenRange> preidentifiedTokens) {
        int endR = range.getOffset() + range.getSize();
        String search = filename.substring(range.getOffset(), endR > filename.length() ? filename.length() : endR);
        this.peekEntries.forEach(entry -> ((List)entry.getRight()).forEach(keyword -> {
            int foundIdx = search.indexOf((String)keyword);
            if (foundIdx != -1) {
                elements.add(new Element((Element.ElementCategory)((Object)((Object)((Object)entry.getKey()))), (String)keyword));
                preidentifiedTokens.add(new TokenRange(foundIdx += range.getOffset(), keyword.length()));
            }
        }));
    }

    private Map<String, Keyword> getKeywordContainer(Element.ElementCategory category) {
        return category == Element.ElementCategory.kElementFileExtension ? this.file_extensions : this.keys;
    }

    private void add(Element.ElementCategory category, KeywordOptions options, List<String> keywords) {
        Map<String, Keyword> keys = this.getKeywordContainer(category);
        keywords.stream().filter(StringUtils::isNotEmpty).filter(s -> !keys.containsKey(s)).forEach(keyword -> keys.put((String)keyword, new Keyword(category, options)));
    }

    public static class Keyword {
        private final Element.ElementCategory category;
        private final KeywordOptions options;

        public Keyword(Element.ElementCategory category, KeywordOptions options) {
            this.category = category;
            this.options = options;
        }

        public Element.ElementCategory getCategory() {
            return this.category;
        }

        public KeywordOptions getOptions() {
            return this.options;
        }
    }

    public static class KeywordOptions {
        private final boolean identifiable;
        private final boolean searchable;
        private final boolean valid;

        public KeywordOptions() {
            this(true, true, true);
        }

        public KeywordOptions(boolean identifiable, boolean searchable, boolean valid) {
            this.identifiable = identifiable;
            this.searchable = searchable;
            this.valid = valid;
        }

        public boolean isIdentifiable() {
            return this.identifiable;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

