/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.KeywordManager;
import com.dgtlrepublic.anitomyj.Options;
import com.dgtlrepublic.anitomyj.ParserHelper;
import com.dgtlrepublic.anitomyj.ParserNumber;
import com.dgtlrepublic.anitomyj.StringHelper;
import com.dgtlrepublic.anitomyj.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    private boolean isEpisodeKeywordsFound = false;
    private final ParserHelper parserHelper;
    private final ParserNumber parserNumber;
    private final List<Element> elements;
    private final List<Token> tokens;
    private final Options options;

    public Parser(List<Element> elements, Options options, List<Token> tokens) {
        this.elements = Objects.requireNonNull(elements);
        this.options = Objects.requireNonNull(options);
        this.tokens = Objects.requireNonNull(tokens);
        this.parserHelper = new ParserHelper(this);
        this.parserNumber = new ParserNumber(this);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public ParserHelper getParserHelper() {
        return this.parserHelper;
    }

    public ParserNumber getParserNumber() {
        return this.parserNumber;
    }

    public boolean isEpisodeKeywordsFound() {
        return this.isEpisodeKeywordsFound;
    }

    public boolean parse() {
        this.searchForKeywords();
        this.searchForIsolatedNumbers();
        if (this.options.parseEpisodeNumber) {
            this.SearchForEpisodeNumber();
        }
        this.searchForAnimeTitle();
        if (this.options.parseReleaseGroup && this.empty(Element.ElementCategory.kElementReleaseGroup)) {
            this.searchForReleaseGroup();
        }
        if (this.options.parseEpisodeTitle && !this.empty(Element.ElementCategory.kElementEpisodeNumber)) {
            this.searchForEpisodeTitle();
        }
        this.validateElements();
        return this.empty(Element.ElementCategory.kElementAnimeTitle);
    }

    private void searchForKeywords() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.getCategory() != Token.TokenCategory.kUnknown) continue;
            String word = token.getContent();
            if ((word = StringHelper.trimAny(word, " -")).isEmpty() || word.length() != 8 && StringHelper.isNumericString(word)) continue;
            String keyword = KeywordManager.normalzie(word);
            AtomicReference<Element.ElementCategory> category = new AtomicReference<Element.ElementCategory>(Element.ElementCategory.kElementUnknown);
            AtomicReference<KeywordManager.KeywordOptions> options = new AtomicReference<KeywordManager.KeywordOptions>(new KeywordManager.KeywordOptions());
            if (KeywordManager.getInstance().findAndSet(keyword, category, options)) {
                if (!this.options.parseReleaseGroup && category.get() == Element.ElementCategory.kElementReleaseGroup || !ParserHelper.isElementCategorySearchable(category.get()) || !options.get().isSearchable() || ParserHelper.isElementCategorySingular(category.get()) && !this.empty(category.get())) continue;
                if (category.get() == Element.ElementCategory.kElementAnimeSeasonPrefix) {
                    this.parserHelper.checkAndSetAnimeSeasonKeyword(token, i);
                    continue;
                }
                if (category.get() == Element.ElementCategory.kElementEpisodePrefix) {
                    if (options.get().isValid()) {
                        this.parserHelper.checkExtentKeyword(Element.ElementCategory.kElementEpisodeNumber, i, token);
                        continue;
                    }
                } else if (category.get() == Element.ElementCategory.kElementReleaseVersion) {
                    word = StringUtils.substring((String)word, (int)1);
                } else if (category.get() == Element.ElementCategory.kElementVolumePrefix) {
                    this.parserHelper.checkExtentKeyword(Element.ElementCategory.kElementVolumeNumber, i, token);
                    continue;
                }
            } else if (this.empty(Element.ElementCategory.kElementFileChecksum) && ParserHelper.isCrc32(word)) {
                category.set(Element.ElementCategory.kElementFileChecksum);
            } else if (this.empty(Element.ElementCategory.kElementVideoResolution) && ParserHelper.isResolution(word)) {
                category.set(Element.ElementCategory.kElementVideoResolution);
            }
            if (category.get() == Element.ElementCategory.kElementUnknown) continue;
            this.elements.add(new Element(category.get(), word));
            if (options.get() == null || !options.get().isIdentifiable()) continue;
            token.setCategory(Token.TokenCategory.kIdentifier);
        }
    }

    private void SearchForEpisodeNumber() {
        ArrayList<Token.Result> tokens = new ArrayList<Token.Result>();
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.getCategory() != Token.TokenCategory.kUnknown || ParserHelper.indexOfFirstDigit(token.getContent()) == -1) continue;
            tokens.add(new Token.Result(token, i));
        }
        if (tokens.isEmpty()) {
            return;
        }
        boolean bl = this.isEpisodeKeywordsFound = !this.empty(Element.ElementCategory.kElementEpisodeNumber);
        if (this.parserNumber.searchForEpisodePatterns(tokens)) {
            return;
        }
        if (!this.empty(Element.ElementCategory.kElementEpisodeNumber)) {
            return;
        }
        tokens.removeIf(r -> !StringHelper.isNumericString(r.token.getContent()));
        if (this.parserNumber.searchForEquivalentNumbers(tokens)) {
            return;
        }
        if (this.parserNumber.searchForSeparatedNumbers(tokens)) {
            return;
        }
        if (this.parserNumber.searchForIsolatedNumbers(tokens)) {
            return;
        }
        this.parserNumber.searchForLastNumber(tokens);
    }

    private void searchForAnimeTitle() {
        int end;
        boolean enclosedTitle = false;
        Token.Result tokenBegin = Token.findToken(this.tokens, Token.TokenFlag.kFlagNotEnclosed, Token.TokenFlag.kFlagUnknown);
        if (tokenBegin.token == null) {
            tokenBegin = new Token.Result(null, 0);
            enclosedTitle = true;
            boolean skippedPreviousGroup = false;
            do {
                tokenBegin = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagUnknown);
                if (tokenBegin.token == null || StringHelper.isMostlyLatinString(tokenBegin.token.getContent()) && skippedPreviousGroup) break;
                tokenBegin = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagBracket);
                tokenBegin = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagUnknown);
                skippedPreviousGroup = true;
            } while (tokenBegin.token != null);
        }
        if (tokenBegin.token == null) {
            return;
        }
        Token.Result tokenEnd = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagIdentifier, enclosedTitle ? Token.TokenFlag.kFlagBracket : Token.TokenFlag.kFlagNone);
        if (!enclosedTitle) {
            end = tokenEnd.pos != null ? tokenEnd.pos.intValue() : this.tokens.size();
            Token.Result lastBracket = tokenEnd;
            boolean bracketOpen = false;
            for (int i = tokenBegin.pos.intValue(); i < end; ++i) {
                Token token = this.tokens.get(i);
                if (token.getCategory() != Token.TokenCategory.kBracket) continue;
                lastBracket = new Token.Result(token, i);
                bracketOpen = !bracketOpen;
            }
            if (bracketOpen) {
                tokenEnd = lastBracket;
            }
        }
        if (!enclosedTitle) {
            end = tokenEnd.pos != null ? tokenEnd.pos.intValue() : this.tokens.size();
            Token.Result token = Token.findPrevToken(this.tokens, end, Token.TokenFlag.kFlagNotDelimiter);
            while (ParserHelper.isTokenCategory(token.token, Token.TokenCategory.kBracket) && token.token.getContent().charAt(0) != ')') {
                token = Token.findPrevToken(this.tokens, token, Token.TokenFlag.kFlagBracket);
                if (token.pos == null) continue;
                tokenEnd = token;
                token = Token.findPrevToken(this.tokens, tokenEnd, Token.TokenFlag.kFlagNotDelimiter);
            }
        }
        end = this.tokens.size();
        if (tokenEnd.token != null) {
            end = Math.min(tokenEnd.pos, end);
        }
        this.parserHelper.buildElement(Element.ElementCategory.kElementAnimeTitle, false, this.tokens.subList(tokenBegin.pos, end));
    }

    private void searchForReleaseGroup() {
        Token.Result tokenBegin;
        Token.Result tokenEnd = tokenBegin = new Token.Result(null, 0);
        while (tokenBegin.pos != null && tokenBegin.pos < this.tokens.size()) {
            tokenBegin = Token.findToken(this.tokens, tokenEnd, Token.TokenFlag.kFlagEnclosed, Token.TokenFlag.kFlagUnknown);
            if (tokenBegin.token == null) {
                return;
            }
            tokenEnd = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagBracket, Token.TokenFlag.kFlagIdentifier);
            if (tokenEnd.token == null || tokenEnd.token.getCategory() != Token.TokenCategory.kBracket) continue;
            Token.Result prevToken = Token.findPrevToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagNotDelimiter);
            if (prevToken.token != null && prevToken.token.getCategory() != Token.TokenCategory.kBracket) continue;
            int end = this.tokens.size();
            end = Math.min(tokenEnd.pos, end);
            this.parserHelper.buildElement(Element.ElementCategory.kElementReleaseGroup, true, this.tokens.subList(tokenBegin.pos, end));
            return;
        }
    }

    private void searchForEpisodeTitle() {
        Token.Result tokenBegin = Token.findToken(this.tokens, Token.TokenFlag.kFlagNotEnclosed, Token.TokenFlag.kFlagUnknown);
        if (tokenBegin.token == null) {
            return;
        }
        Token.Result tokenEnd = Token.findToken(this.tokens, tokenBegin, Token.TokenFlag.kFlagBracket, Token.TokenFlag.kFlagIdentifier);
        int end = this.tokens.size();
        if (tokenEnd.pos != null) {
            end = Math.min(tokenEnd.pos, end);
        }
        this.parserHelper.buildElement(Element.ElementCategory.kElementEpisodeTitle, false, this.tokens.subList(tokenBegin.pos, end));
    }

    private void searchForIsolatedNumbers() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.getCategory() != Token.TokenCategory.kUnknown || !StringHelper.isNumericString(token.getContent()) || !this.parserHelper.isTokenIsolated(i)) continue;
            int number = StringHelper.stringToInt(token.getContent());
            if (number >= 1900 && number <= 2050 && this.empty(Element.ElementCategory.kElementAnimeYear)) {
                this.elements.add(new Element(Element.ElementCategory.kElementAnimeYear, token.getContent()));
                token.setCategory(Token.TokenCategory.kIdentifier);
                continue;
            }
            if (number != 480 && number != 720 && number != 1080 || !this.empty(Element.ElementCategory.kElementVideoResolution)) continue;
            this.elements.add(new Element(Element.ElementCategory.kElementVideoResolution, token.getContent()));
            token.setCategory(Token.TokenCategory.kIdentifier);
        }
    }

    private void validateElements() {
        if (!this.empty(Element.ElementCategory.kElementAnimeType) && !this.empty(Element.ElementCategory.kElementEpisodeTitle)) {
            String episodeTitle = this.get(Element.ElementCategory.kElementEpisodeTitle);
            int i = 0;
            while (i < this.elements.size()) {
                Element el = this.elements.get(i);
                if (el.getCategory() == Element.ElementCategory.kElementAnimeType && StringUtils.contains((CharSequence)episodeTitle, (CharSequence)el.getValue())) {
                    if (episodeTitle.length() == el.getValue().length()) {
                        this.elements.removeIf(element -> element.getCategory() == Element.ElementCategory.kElementEpisodeTitle);
                    } else {
                        String keyword = KeywordManager.normalzie(el.getValue());
                        if (KeywordManager.getInstance().contains(Element.ElementCategory.kElementAnimeType, keyword)) {
                            i = this.erase(el);
                            continue;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean empty(Element.ElementCategory category) {
        return !this.elements.stream().anyMatch(element -> element.getCategory() == category);
    }

    private String get(Element.ElementCategory category) {
        Element foundElement = this.elements.stream().filter(element -> element.getCategory() == category).findAny().orElse(null);
        if (foundElement == null) {
            Element e = new Element(category, "");
            this.elements.add(e);
            foundElement = e;
        }
        return foundElement.getValue();
    }

    private int erase(Element element) {
        int removedIdx = -1;
        ListIterator<Element> itr = this.elements.listIterator();
        while (itr.hasNext()) {
            int idx = itr.nextIndex();
            Element curE = itr.next();
            if (element.getCategory() != curE.getCategory()) continue;
            removedIdx = idx;
            itr.remove();
            break;
        }
        return removedIdx;
    }
}

