/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.Parser;
import com.dgtlrepublic.anitomyj.StringHelper;
import com.dgtlrepublic.anitomyj.Token;
import com.dgtlrepublic.anitomyj.TriConsumer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParserHelper {
    public static final String kDashes = "-\u2010\u2011\u2012\u2013\u2014\u2015";
    public static final String kDashesWithSpace = " -\u2010\u2011\u2012\u2013\u2014\u2015";
    public static final Map<String, String> ordinals = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("1st", "1");
            this.put("First", "1");
            this.put("2nd", "2");
            this.put("Second", "2");
            this.put("3rd", "3");
            this.put("Third", "3");
            this.put("4th", "4");
            this.put("Fourth", "4");
            this.put("5th", "5");
            this.put("Fifth", "5");
            this.put("6th", "6");
            this.put("Sixth", "6");
            this.put("7th", "7");
            this.put("Seventh", "7");
            this.put("8th", "8");
            this.put("Eighth", "8");
            this.put("9th", "9");
            this.put("Ninth", "9");
        }
    });
    private final Parser parser;

    public ParserHelper(Parser parser) {
        this.parser = parser;
    }

    public static boolean isTokenCategory(Token.Result result, Token.TokenCategory category) {
        return result != null && result.token != null && result.token.getCategory() == category;
    }

    public static boolean isTokenCategory(Token token, Token.TokenCategory category) {
        return token != null && token.getCategory() == category;
    }

    public static boolean isCrc32(String string) {
        return string != null && string.length() == 8 && StringHelper.isHexadecimalString(string);
    }

    public static boolean isDashCharacter(char c) {
        return StringUtils.containsAny((CharSequence)String.valueOf(c), (CharSequence)kDashes);
    }

    public static String getNumberFromOrdinal(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String foundString = ordinals.get(string);
        return foundString != null ? foundString : "";
    }

    public static int indexOfFirstDigit(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return -1;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isResolution(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        int minWidthSize = 3;
        int minHeightSize = 3;
        if (string.length() >= minWidthSize + 1 + minHeightSize) {
            int pos = StringUtils.indexOfAny((CharSequence)string, (String)"xX\u00d7");
            if (pos != -1 && pos >= minWidthSize && pos <= string.length() - (minHeightSize + 1)) {
                for (int i = 0; i < string.length(); ++i) {
                    if (i == pos || Character.isDigit(string.charAt(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (string.length() >= minHeightSize + 1 && Character.toLowerCase(string.charAt(string.length() - 1)) == 'p') {
            for (int i = 0; i < string.length() - 1; ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isElementCategorySearchable(Element.ElementCategory category) {
        switch (category) {
            case kElementAnimeSeasonPrefix: 
            case kElementAnimeType: 
            case kElementAudioTerm: 
            case kElementDeviceCompatibility: 
            case kElementEpisodePrefix: 
            case kElementFileChecksum: 
            case kElementLanguage: 
            case kElementOther: 
            case kElementReleaseGroup: 
            case kElementReleaseInformation: 
            case kElementReleaseVersion: 
            case kElementSource: 
            case kElementSubtitles: 
            case kElementVideoResolution: 
            case kElementVideoTerm: 
            case kElementVolumePrefix: {
                return true;
            }
        }
        return false;
    }

    public static boolean isElementCategorySingular(Element.ElementCategory category) {
        switch (category) {
            case kElementAnimeType: 
            case kElementAudioTerm: 
            case kElementDeviceCompatibility: 
            case kElementLanguage: 
            case kElementOther: 
            case kElementReleaseInformation: 
            case kElementSource: 
            case kElementVideoTerm: 
            case kElementAnimeSeason: 
            case kElementEpisodeNumber: {
                return false;
            }
        }
        return true;
    }

    public boolean isTokenIsolated(int pos) {
        Token.Result prevToken = Token.findPrevToken(this.parser.getTokens(), pos, Token.TokenFlag.kFlagNotDelimiter);
        if (!ParserHelper.isTokenCategory(prevToken, Token.TokenCategory.kBracket)) {
            return false;
        }
        Token.Result nextToken = Token.findNextToken(this.parser.getTokens(), pos, Token.TokenFlag.kFlagNotDelimiter);
        return ParserHelper.isTokenCategory(nextToken, Token.TokenCategory.kBracket);
    }

    public boolean checkAndSetAnimeSeasonKeyword(Token token, int currentTokenPos) {
        String number;
        TriConsumer<Token, Token, String> setAnimeSeason = (first, second, content) -> {
            this.parser.getElements().add(new Element(Element.ElementCategory.kElementAnimeSeason, (String)content));
            first.setCategory(Token.TokenCategory.kIdentifier);
            second.setCategory(Token.TokenCategory.kIdentifier);
        };
        Token.Result previousToken = Token.findPrevToken(this.parser.getTokens(), currentTokenPos, Token.TokenFlag.kFlagNotDelimiter);
        if (previousToken.token != null && !(number = ParserHelper.getNumberFromOrdinal(previousToken.token.getContent())).isEmpty()) {
            setAnimeSeason.accept(previousToken.token, token, number);
            return true;
        }
        Token.Result nextToken = Token.findNextToken(this.parser.getTokens(), currentTokenPos, Token.TokenFlag.kFlagNotDelimiter);
        if (nextToken.token != null && StringHelper.isNumericString(nextToken.token.getContent())) {
            setAnimeSeason.accept(token, nextToken.token, nextToken.token.getContent());
            return true;
        }
        return false;
    }

    public boolean checkExtentKeyword(Element.ElementCategory category, int currentTokenPos, Token token) {
        Token.Result nToken = Token.findNextToken(this.parser.getTokens(), currentTokenPos, Token.TokenFlag.kFlagNotDelimiter);
        if (ParserHelper.isTokenCategory(nToken.token, Token.TokenCategory.kUnknown) && ParserHelper.indexOfFirstDigit(nToken.token.getContent()) == 0) {
            switch (category) {
                case kElementEpisodeNumber: {
                    if (this.parser.getParserNumber().matchEpisodePatterns(nToken.token.getContent(), nToken.token)) break;
                    this.parser.getParserNumber().setEpisodeNumber(nToken.token.getContent(), nToken.token, false);
                    break;
                }
                case kElementVolumeNumber: {
                    if (this.parser.getParserNumber().matchVolumePatterns(nToken.token.getContent(), nToken.token)) break;
                    this.parser.getParserNumber().setVolumeNumber(nToken.token.getContent(), nToken.token, false);
                    break;
                }
                default: {
                    return false;
                }
            }
            token.setCategory(Token.TokenCategory.kIdentifier);
            return true;
        }
        return false;
    }

    public void buildElement(Element.ElementCategory category, boolean keepDelimiters, List<Token> tokens) {
        StringBuilder element = new StringBuilder();
        ListIterator<Token> iter = tokens.listIterator();
        while (iter.hasNext()) {
            Token token = iter.next();
            block0 : switch (token.getCategory()) {
                case kUnknown: {
                    element.append(token.getContent());
                    token.setCategory(Token.TokenCategory.kIdentifier);
                    break;
                }
                case kBracket: {
                    element.append(token.getContent());
                    break;
                }
                case kDelimiter: {
                    String delimiter = "";
                    if (StringUtils.isNotEmpty((CharSequence)token.getContent())) {
                        delimiter = StringUtils.substring((String)token.getContent(), (int)0, (int)1);
                    }
                    if (keepDelimiters) {
                        element.append(delimiter);
                        break;
                    }
                    if (!iter.hasPrevious() || !iter.hasNext()) break;
                    switch (delimiter) {
                        case ",": 
                        case "&": {
                            element.append(delimiter);
                            break block0;
                        }
                    }
                    element.append(' ');
                    break;
                }
            }
        }
        if (!keepDelimiters) {
            element = new StringBuilder(StringHelper.trimAny(element.toString(), kDashesWithSpace));
        }
        if (!element.toString().isEmpty()) {
            this.parser.getElements().add(new Element(category, element.toString()));
        }
    }
}

