/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.KeywordManager;
import com.dgtlrepublic.anitomyj.Parser;
import com.dgtlrepublic.anitomyj.ParserHelper;
import com.dgtlrepublic.anitomyj.StringHelper;
import com.dgtlrepublic.anitomyj.Token;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class ParserNumber {
    public static final int kAnimeYearMin = 1900;
    public static final int kAnimeYearMax = 2050;
    public static final int kEpisodeNumberMax = 1899;
    public static final int kVolumeNumberMax = 20;
    private final Parser parser;

    public ParserNumber(Parser parser) {
        this.parser = parser;
    }

    public boolean isValidVolumeNumber(String number) {
        return StringHelper.stringToInt(number) <= 20;
    }

    public boolean isValidEpisodeNumber(String number) {
        try {
            return NumberFormat.getInstance().parse(number).doubleValue() <= 1899.0;
        }
        catch (NullPointerException | NumberFormatException | ParseException e) {
            return false;
        }
    }

    public boolean setAlternativeEpisodeNumber(String number, Token token) {
        this.parser.getElements().add(new Element(Element.ElementCategory.kElementEpisodeNumberAlt, number));
        token.setCategory(Token.TokenCategory.kIdentifier);
        return true;
    }

    public boolean setVolumeNumber(String number, Token token, boolean validate) {
        if (validate && !this.isValidVolumeNumber(number)) {
            return false;
        }
        this.parser.getElements().add(new Element(Element.ElementCategory.kElementVolumeNumber, number));
        token.setCategory(Token.TokenCategory.kIdentifier);
        return true;
    }

    public boolean setEpisodeNumber(String number, Token token, boolean validate) {
        if (validate && !this.isValidEpisodeNumber(number)) {
            return false;
        }
        token.setCategory(Token.TokenCategory.kIdentifier);
        Element.ElementCategory category = Element.ElementCategory.kElementEpisodeNumber;
        if (this.parser.isEpisodeKeywordsFound()) {
            for (Element element : this.parser.getElements()) {
                if (element.getCategory() != Element.ElementCategory.kElementEpisodeNumber) continue;
                int comparison = StringHelper.stringToInt(number) - StringHelper.stringToInt(element.getValue());
                if (comparison > 0) {
                    category = Element.ElementCategory.kElementEpisodeNumberAlt;
                    break;
                }
                if (comparison < 0) {
                    element.setCategory(Element.ElementCategory.kElementEpisodeNumberAlt);
                    break;
                }
                return false;
            }
        }
        this.parser.getElements().add(new Element(category, number));
        return true;
    }

    public boolean numberComesAfterPrefix(Element.ElementCategory category, Token token) {
        int number_begin = ParserHelper.indexOfFirstDigit(token.getContent());
        String prefix = StringUtils.substring((String)token.getContent(), (int)0, (int)number_begin).toUpperCase(Locale.ENGLISH);
        if (KeywordManager.getInstance().contains(category, prefix)) {
            String number = StringUtils.substring((String)token.getContent(), (int)number_begin, (int)token.getContent().length());
            switch (category) {
                case kElementEpisodePrefix: {
                    if (!this.matchEpisodePatterns(number, token)) {
                        this.setEpisodeNumber(number, token, false);
                    }
                    return true;
                }
                case kElementVolumePrefix: {
                    if (!this.matchVolumePatterns(number, token)) {
                        this.setVolumeNumber(number, token, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean numberComesBeforeTotalNumber(Token token, int currentTokenIdx) {
        Token.Result nextToken = Token.findNextToken(this.parser.getTokens(), currentTokenIdx, Token.TokenFlag.kFlagNotDelimiter);
        if (nextToken.token != null && StringUtils.equalsIgnoreCase((CharSequence)nextToken.token.getContent(), (CharSequence)"of")) {
            Token.Result otherToken = Token.findNextToken(this.parser.getTokens(), nextToken, Token.TokenFlag.kFlagNotDelimiter);
            if (otherToken.token != null && StringHelper.isNumericString(otherToken.token.getContent())) {
                this.setEpisodeNumber(token.getContent(), token, false);
                nextToken.token.setCategory(Token.TokenCategory.kIdentifier);
                otherToken.token.setCategory(Token.TokenCategory.kIdentifier);
                return true;
            }
        }
        return false;
    }

    public boolean matchEpisodePatterns(String word, Token token) {
        if (StringHelper.isNumericString(word)) {
            return false;
        }
        word = StringHelper.trimAny(word, " -");
        boolean numericFront = Character.isDigit(word.charAt(0));
        boolean numericBack = Character.isDigit(word.charAt(word.length() - 1));
        if (numericFront && numericBack && this.matchSingleEpisodePattern(word, token)) {
            return true;
        }
        if (numericFront && numericBack && this.matchMultiEpisodePattern(word, token)) {
            return true;
        }
        if (numericBack && this.matchSeasonAndEpisodePattern(word, token)) {
            return true;
        }
        if (!numericFront && this.matchTypeAndEpisodePattern(word, token)) {
            return true;
        }
        if (numericFront && numericBack && this.matchFractionalEpisodePattern(word, token)) {
            return true;
        }
        if (numericFront && !numericBack && this.matchPartialEpisodePattern(word, token)) {
            return true;
        }
        if (numericBack && this.matchNumberSignPattern(word, token)) {
            return true;
        }
        return numericFront && this.matchJapaneseCounterPattern(word, token);
    }

    public boolean matchSingleEpisodePattern(String word, Token token) {
        String regexPattern = "(\\d{1,3})[vV](\\d)";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(word);
        if (matcher.matches()) {
            this.setEpisodeNumber(matcher.group(1), token, false);
            this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(2)));
            return true;
        }
        return false;
    }

    public boolean matchMultiEpisodePattern(String word, Token token) {
        String regexPattern = "(\\d{1,3})(?:[vV](\\d))?[-~&+](\\d{1,3})(?:[vV](\\d))?";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(word);
        if (matcher.matches()) {
            String lowerBound = matcher.group(1);
            String upperBound = matcher.group(3);
            if (StringHelper.stringToInt(lowerBound) < StringHelper.stringToInt(upperBound) && this.setEpisodeNumber(lowerBound, token, true)) {
                this.setEpisodeNumber(upperBound, token, true);
                if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                    this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(2)));
                }
                if (StringUtils.isNotEmpty((CharSequence)matcher.group(4))) {
                    this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(4)));
                }
                return true;
            }
        }
        return false;
    }

    public boolean matchSeasonAndEpisodePattern(String word, Token token) {
        String regexPattern = "S?(\\d{1,2})(?:-S?(\\d{1,2}))?(?:x|[ ._-x]?E)(\\d{1,3})(?:-E?(\\d{1,3}))?";
        Pattern pattern = Pattern.compile(regexPattern, 2);
        Matcher matcher = pattern.matcher(word);
        if (matcher.matches()) {
            this.parser.getElements().add(new Element(Element.ElementCategory.kElementAnimeSeason, matcher.group(1)));
            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                this.parser.getElements().add(new Element(Element.ElementCategory.kElementAnimeSeason, matcher.group(2)));
            }
            this.setEpisodeNumber(matcher.group(3), token, false);
            if (StringUtils.isNotEmpty((CharSequence)matcher.group(4))) {
                this.setEpisodeNumber(matcher.group(4), token, false);
            }
            return true;
        }
        return false;
    }

    public boolean matchTypeAndEpisodePattern(String word, Token token) {
        int numberBegin = ParserHelper.indexOfFirstDigit(word);
        String prefix = StringUtils.substring((String)word, (int)0, (int)numberBegin);
        AtomicReference<Element.ElementCategory> category = new AtomicReference<Element.ElementCategory>(Element.ElementCategory.kElementAnimeType);
        AtomicReference<KeywordManager.KeywordOptions> options = new AtomicReference<KeywordManager.KeywordOptions>();
        if (KeywordManager.getInstance().findAndSet(KeywordManager.normalzie(prefix), category, options)) {
            this.parser.getElements().add(new Element(Element.ElementCategory.kElementAnimeType, prefix));
            String number = StringUtils.substring((String)word, (int)numberBegin);
            if (this.matchEpisodePatterns(number, token) || this.setEpisodeNumber(number, token, true)) {
                int foundIdx = this.parser.getTokens().indexOf(token);
                if (foundIdx != -1) {
                    token.setContent(number);
                    this.parser.getTokens().add(foundIdx, new Token(options.get().isIdentifiable() ? Token.TokenCategory.kIdentifier : Token.TokenCategory.kUnknown, prefix, token.isEnclosed()));
                }
                return true;
            }
        }
        return false;
    }

    public boolean matchFractionalEpisodePattern(String word, Token token) {
        String regexPattern;
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isEmpty((CharSequence)word)) {
            word = "";
        }
        return (matcher = (pattern = Pattern.compile(regexPattern = "\\d+\\.5", 2)).matcher(word)).matches() && this.setEpisodeNumber(word, token, true);
    }

    public boolean matchPartialEpisodePattern(String word, Token token) {
        if (StringUtils.isEmpty((CharSequence)word)) {
            return false;
        }
        int foundIdx = IntStream.rangeClosed(0, word.length()).filter(value -> !Character.isDigit(word.charAt(value))).findFirst().orElse(word.length());
        int suffixLength = word.length() - foundIdx;
        Function<Integer, Boolean> isValidSuffix = c -> c >= 65 && c <= 67 || c >= 97 && c <= 99;
        return suffixLength == 1 && isValidSuffix.apply(Integer.valueOf(word.charAt(foundIdx))) != false && this.setEpisodeNumber(word, token, true);
    }

    public boolean matchNumberSignPattern(String word, Token token) {
        String regexPattern;
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isEmpty((CharSequence)word) || word.charAt(0) != '#') {
            word = "";
        }
        if ((matcher = (pattern = Pattern.compile(regexPattern = "#(\\d{1,3})(?:[-~&+](\\d{1,3}))?(?:[vV](\\d))?")).matcher(word)).matches() && this.setEpisodeNumber(matcher.group(1), token, true)) {
            if (StringUtils.isNotEmpty((CharSequence)matcher.group(2))) {
                this.setEpisodeNumber(matcher.group(2), token, false);
            }
            if (StringUtils.isNotEmpty((CharSequence)matcher.group(3))) {
                this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(3)));
            }
            return true;
        }
        return false;
    }

    public boolean matchJapaneseCounterPattern(String word, Token token) {
        if (StringUtils.isEmpty((CharSequence)word) || word.charAt(word.length() - 1) != '\u8a71') {
            return false;
        }
        String regexPattern = "(\\d{1,3})\u8a71";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(word);
        if (matcher.matches()) {
            this.setEpisodeNumber(matcher.group(1), token, false);
            return true;
        }
        return false;
    }

    public boolean matchVolumePatterns(String word, Token token) {
        if (StringHelper.isNumericString(word)) {
            return false;
        }
        word = StringHelper.trimAny(word, " -");
        boolean numericFront = Character.isDigit(word.charAt(0));
        boolean numericBack = Character.isDigit(word.charAt(word.length() - 1));
        if (numericFront && numericBack && this.matchSingleVolumePattern(word, token)) {
            return true;
        }
        return numericFront && numericBack && this.matchMultiVolumePattern(word, token);
    }

    public boolean matchSingleVolumePattern(String word, Token token) {
        String regexPattern;
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isEmpty((CharSequence)word)) {
            word = "";
        }
        if ((matcher = (pattern = Pattern.compile(regexPattern = "(\\d{1,2})[vV](\\d)")).matcher(word)).matches()) {
            this.setVolumeNumber(matcher.group(1), token, false);
            this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(2)));
            return true;
        }
        return false;
    }

    public boolean matchMultiVolumePattern(String word, Token token) {
        String regexPattern;
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isEmpty((CharSequence)word)) {
            word = "";
        }
        if ((matcher = (pattern = Pattern.compile(regexPattern = "(\\d{1,2})[-~&+](\\d{1,2})(?:[vV](\\d))?")).matcher(word)).matches()) {
            String lowerBound = matcher.group(1);
            String upperBound = matcher.group(2);
            if (StringHelper.stringToInt(lowerBound) < StringHelper.stringToInt(upperBound) && this.setVolumeNumber(lowerBound, token, true)) {
                this.setVolumeNumber(upperBound, token, false);
                if (StringUtils.isNotEmpty((CharSequence)matcher.group(3))) {
                    this.parser.getElements().add(new Element(Element.ElementCategory.kElementReleaseVersion, matcher.group(3)));
                }
                return true;
            }
        }
        return false;
    }

    public boolean searchForIsolatedNumbers(List<Token.Result> tokens) {
        for (Token.Result it : tokens) {
            if (!it.token.isEnclosed() || !this.parser.getParserHelper().isTokenIsolated(it.pos) || !this.setEpisodeNumber(it.token.getContent(), it.token, true)) continue;
            return true;
        }
        return false;
    }

    public boolean searchForSeparatedNumbers(List<Token.Result> tokens) {
        for (Token.Result it : tokens) {
            Token.Result previousToken = Token.findPrevToken(this.parser.getTokens(), it, Token.TokenFlag.kFlagNotDelimiter);
            if (!ParserHelper.isTokenCategory(previousToken.token, Token.TokenCategory.kUnknown) || !ParserHelper.isDashCharacter(previousToken.token.getContent().charAt(0)) || !this.setEpisodeNumber(it.token.getContent(), it.token, true)) continue;
            previousToken.token.setCategory(Token.TokenCategory.kIdentifier);
            return true;
        }
        return false;
    }

    public boolean searchForEpisodePatterns(List<Token.Result> tokens) {
        for (Token.Result it : tokens) {
            boolean numericFront;
            boolean bl = numericFront = it.token.getContent().length() > 0 && Character.isDigit(it.token.getContent().charAt(0));
            if (!numericFront) {
                if (this.numberComesAfterPrefix(Element.ElementCategory.kElementEpisodePrefix, it.token)) {
                    return true;
                }
                if (this.numberComesAfterPrefix(Element.ElementCategory.kElementVolumePrefix, it.token)) {
                    continue;
                }
            } else if (this.numberComesBeforeTotalNumber(it.token, it.pos)) {
                return true;
            }
            if (!this.matchEpisodePatterns(it.token.getContent(), it.token)) continue;
            return true;
        }
        return false;
    }

    public boolean searchForEquivalentNumbers(List<Token.Result> tokens) {
        for (Token.Result it : tokens) {
            Token.Result nextToken;
            if (this.parser.getParserHelper().isTokenIsolated(it.pos) || !this.isValidEpisodeNumber(it.token.getContent()) || !ParserHelper.isTokenCategory(nextToken = Token.findNextToken(this.parser.getTokens(), it.pos, Token.TokenFlag.kFlagNotDelimiter), Token.TokenCategory.kBracket) || !ParserHelper.isTokenCategory(nextToken = Token.findNextToken(this.parser.getTokens(), nextToken, Token.TokenFlag.kFlagEnclosed, Token.TokenFlag.kFlagNotDelimiter), Token.TokenCategory.kUnknown) || !this.parser.getParserHelper().isTokenIsolated(nextToken.pos) || !StringHelper.isNumericString(nextToken.token.getContent()) || !this.isValidEpisodeNumber(nextToken.token.getContent())) continue;
            List<Token> list = Arrays.asList(it.token, nextToken.token);
            list.sort((o1, o2) -> Integer.compare(StringHelper.stringToInt(o1.getContent()), StringHelper.stringToInt(o2.getContent())));
            this.setEpisodeNumber(list.get(0).getContent(), list.get(0), false);
            this.setAlternativeEpisodeNumber(list.get(1).getContent(), list.get(1));
            return true;
        }
        return false;
    }

    public boolean searchForLastNumber(List<Token.Result> tokens) {
        for (int i = tokens.size() - 1; i >= 0; --i) {
            Token.Result previousToken;
            Token.Result it = tokens.get(i);
            if (it.pos == 0 || it.token.isEnclosed() || this.parser.getTokens().subList(0, it.pos).stream().allMatch(r -> r.isEnclosed() || r.getCategory() == Token.TokenCategory.kDelimiter) || ParserHelper.isTokenCategory(previousToken = Token.findPrevToken(this.parser.getTokens(), it, Token.TokenFlag.kFlagNotDelimiter), Token.TokenCategory.kUnknown) && (StringUtils.equalsIgnoreCase((CharSequence)previousToken.token.getContent(), (CharSequence)"Movie") || StringUtils.equalsIgnoreCase((CharSequence)previousToken.token.getContent(), (CharSequence)"Part")) || !this.setEpisodeNumber(it.token.getContent(), it.token, true)) continue;
            return true;
        }
        return false;
    }
}

