/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class StringHelper {
    public static boolean isAlphanumericChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isHexadecimalChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isLatinChar(char c) {
        return c <= '\u024f';
    }

    public static boolean isAlphanumericString(String string) {
        return StringUtils.isAlphanumeric((CharSequence)string);
    }

    public static boolean isHexadecimalString(String string) {
        return StringUtils.isNotEmpty((CharSequence)string) && string.chars().allMatch(value -> StringHelper.isHexadecimalChar((char)value));
    }

    public static boolean isMostlyLatinString(String string) {
        double length = StringUtils.isNotEmpty((CharSequence)string) ? 1.0 : (double)string.length();
        return (double)IntStream.range(0, StringUtils.isEmpty((CharSequence)string) ? 0 : string.length()).filter(value -> StringHelper.isLatinChar(string.charAt(value))).count() / length >= 0.5;
    }

    public static boolean isNumericString(String string) {
        return StringUtils.isNumeric((CharSequence)string);
    }

    public static int stringToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0;
        }
    }

    public static String trimAny(String string, String trimChars) {
        int posBegin = StringHelper.findFirstNotOfAny(string, trimChars);
        int posEnd = StringHelper.findLastNotOfAny(string, trimChars);
        if (posBegin == -1 || posEnd == -1) {
            return "";
        }
        return string.substring(posBegin, posEnd + 1);
    }

    public static int findFirstNotOfAny(String string, String trimChars) {
        if (StringUtils.isEmpty((CharSequence)string) || StringUtils.isEmpty((CharSequence)trimChars)) {
            return -1;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (StringUtils.containsAny((CharSequence)String.valueOf(string.charAt(i)), (CharSequence)trimChars)) continue;
            return i;
        }
        return -1;
    }

    public static int findLastNotOfAny(String string, String trimChars) {
        if (StringUtils.isEmpty((CharSequence)string) || StringUtils.isEmpty((CharSequence)trimChars)) {
            return -1;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (StringUtils.containsAny((CharSequence)String.valueOf(string.charAt(i)), (CharSequence)trimChars)) continue;
            return i;
        }
        return -1;
    }
}

