/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.TriConsumer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;

class Token {
    private static final EnumSet<TokenFlag> kFlagMaskCategories = EnumSet.of(TokenFlag.kFlagBracket, new TokenFlag[]{TokenFlag.kFlagNotBracket, TokenFlag.kFlagDelimiter, TokenFlag.kFlagNotDelimiter, TokenFlag.kFlagIdentifier, TokenFlag.kFlagNotIdentifier, TokenFlag.kFlagUnknown, TokenFlag.kFlagNotUnknown, TokenFlag.kFlagValid, TokenFlag.kFlagNotValid});
    private static final EnumSet<TokenFlag> kFlagMaskEnclosed = EnumSet.of(TokenFlag.kFlagEnclosed, TokenFlag.kFlagNotEnclosed);
    private TokenCategory category;
    private String content;
    private final boolean enclosed;

    public Token(TokenCategory category, String content, boolean enclosed) {
        this.category = category;
        this.content = content;
        this.enclosed = enclosed;
    }

    public TokenCategory getCategory() {
        return this.category;
    }

    public void setCategory(TokenCategory category) {
        this.category = category;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public static boolean checkTokenFlags(Token token, EnumSet<TokenFlag> flags) {
        Function<TokenFlag, Boolean> checkFlag = flags::contains;
        if (CollectionUtils.containsAny(flags, kFlagMaskEnclosed)) {
            boolean success;
            boolean bl = success = checkFlag.apply(TokenFlag.kFlagEnclosed) == token.enclosed;
            if (!success) {
                return false;
            }
        }
        if (CollectionUtils.containsAny(flags, kFlagMaskCategories)) {
            AtomicBoolean success = new AtomicBoolean(false);
            TriConsumer<TokenFlag, TokenFlag, TokenCategory> checkCategory = (fe, fn, c) -> {
                if (!success.get()) {
                    boolean result = ((Boolean)checkFlag.apply((TokenFlag)((Object)fe))).booleanValue() ? token.category == c : (Boolean)checkFlag.apply((TokenFlag)((Object)fn)) != false && token.category != c;
                    success.set(result);
                }
            };
            checkCategory.accept(TokenFlag.kFlagBracket, TokenFlag.kFlagNotBracket, TokenCategory.kBracket);
            checkCategory.accept(TokenFlag.kFlagDelimiter, TokenFlag.kFlagNotDelimiter, TokenCategory.kDelimiter);
            checkCategory.accept(TokenFlag.kFlagIdentifier, TokenFlag.kFlagNotIdentifier, TokenCategory.kIdentifier);
            checkCategory.accept(TokenFlag.kFlagUnknown, TokenFlag.kFlagNotUnknown, TokenCategory.kUnknown);
            checkCategory.accept(TokenFlag.kFlagNotValid, TokenFlag.kFlagValid, TokenCategory.kInvalid);
            if (!success.get()) {
                return false;
            }
        }
        return true;
    }

    public static Result findToken(List<Token> tokens, Result begin, TokenFlag ... flags) {
        if (begin == null || begin.pos == null) {
            return Result.getEmptyResult();
        }
        return Token.findTokenBase(tokens, begin.pos, i -> i < tokens.size(), i -> i + 1, flags);
    }

    public static Result findToken(List<Token> tokens, TokenFlag ... flags) {
        return Token.findTokenBase(tokens, 0, i -> i < tokens.size(), i -> i + 1, flags);
    }

    public static Result findNextToken(List<Token> tokens, int position, TokenFlag ... flags) {
        return Token.findTokenBase(tokens, ++position, i -> i < tokens.size(), i -> i + 1, flags);
    }

    public static Result findNextToken(List<Token> tokens, Result position, TokenFlag ... flags) {
        return Token.findTokenBase(tokens, position.pos + 1, i -> i < tokens.size(), i -> i + 1, flags);
    }

    public static Result findPrevToken(List<Token> tokens, int position, TokenFlag ... flags) {
        return Token.findTokenBase(tokens, --position, i -> i >= 0, i -> i - 1, flags);
    }

    public static Result findPrevToken(List<Token> tokens, Result position, TokenFlag ... flags) {
        return Token.findTokenBase(tokens, position.pos - 1, i -> i >= 0, i -> i - 1, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        return this.enclosed == token.enclosed && this.category == token.category && Objects.equals(this.content, token.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.content, this.enclosed});
    }

    public String toString() {
        return "Token{category=" + (Object)((Object)this.category) + ", content='" + this.content + '\'' + ", enclosed=" + this.enclosed + '}';
    }

    private static Result findTokenBase(List<Token> tokens, int startIdx, Function<Integer, Boolean> shouldContinue, Function<Integer, Integer> next, TokenFlag ... flags) {
        EnumSet<TokenFlag> find = EnumSet.noneOf(TokenFlag.class);
        find.addAll(Arrays.asList(flags));
        int i = startIdx;
        while (shouldContinue.apply(i).booleanValue()) {
            Token token = tokens.get(i);
            if (Token.checkTokenFlags(token, find)) {
                return new Result(token, i);
            }
            i = next.apply(i);
        }
        return new Result(null, null);
    }

    public static class Result {
        public Token token;
        public Integer pos;

        public Result(Token token, Integer searchIndex) {
            this.token = token;
            this.pos = searchIndex;
        }

        public static Result getEmptyResult() {
            return new Result(null, null);
        }

        public String toString() {
            return "Result{token=" + this.token + ", pos=" + this.pos + '}';
        }
    }

    static enum TokenFlag {
        kFlagNone,
        kFlagBracket,
        kFlagNotBracket,
        kFlagDelimiter,
        kFlagNotDelimiter,
        kFlagIdentifier,
        kFlagNotIdentifier,
        kFlagUnknown,
        kFlagNotUnknown,
        kFlagValid,
        kFlagNotValid,
        kFlagEnclosed,
        kFlagNotEnclosed;

    }

    static enum TokenCategory {
        kUnknown,
        kBracket,
        kDelimiter,
        kIdentifier,
        kInvalid;

    }
}

