/*
 * Decompiled with CFR 0.152.
 */
package com.dgtlrepublic.anitomyj;

import com.dgtlrepublic.anitomyj.Element;
import com.dgtlrepublic.anitomyj.KeywordManager;
import com.dgtlrepublic.anitomyj.Options;
import com.dgtlrepublic.anitomyj.StringHelper;
import com.dgtlrepublic.anitomyj.Token;
import com.dgtlrepublic.anitomyj.TokenRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Tokenizer {
    private final String filename;
    private final List<Element> elements;
    private final Options options;
    private final List<Token> tokens;
    private static final List<Pair<String, String>> brackets = new ArrayList<Pair<String, String>>();

    public Tokenizer(String filename, List<Element> elements, Options options, List<Token> tokens) {
        this.filename = Objects.requireNonNull(filename);
        this.elements = Objects.requireNonNull(elements);
        this.options = Objects.requireNonNull(options);
        this.tokens = Objects.requireNonNull(tokens);
    }

    public boolean tokenize() {
        this.tokenizeByBrackets();
        return !this.tokens.isEmpty();
    }

    private void addToken(Token.TokenCategory category, boolean enclosed, TokenRange range) {
        this.tokens.add(new Token(category, StringUtils.substring((String)this.filename, (int)range.getOffset(), (int)(range.getOffset() + range.getSize())), enclosed));
    }

    private String getDelimiters(TokenRange range) {
        StringBuilder delimiters = new StringBuilder();
        Function<Integer, Boolean> isDelimiter = c -> {
            if (!StringHelper.isAlphanumericChar((char)c.intValue()) && StringUtils.containsAny((CharSequence)String.valueOf((char)c.intValue()), (CharSequence)this.options.allowedDelimiters) && !StringUtils.containsAny((CharSequence)delimiters.toString(), (CharSequence)String.valueOf((char)c.intValue()))) {
                return true;
            }
            return false;
        };
        IntStream.range(range.getOffset(), Math.min(this.filename.length(), range.getOffset() + range.getSize())).filter(value -> (Boolean)isDelimiter.apply(Integer.valueOf(this.filename.charAt(value)))).forEach(value -> delimiters.append(this.filename.charAt(value)));
        return delimiters.toString();
    }

    private void tokenizeByBrackets() {
        AtomicReference matchingBracket = new AtomicReference();
        BiFunction<Integer, Integer, Integer> findFirstBracket = (start, end) -> {
            for (int i = start.intValue(); i < end; ++i) {
                for (Pair<String, String> bracket : brackets) {
                    if (!String.valueOf(this.filename.charAt(i)).equals(bracket.getLeft())) continue;
                    matchingBracket.set(bracket.getRight());
                    return i;
                }
            }
            return -1;
        };
        boolean isBracketOpen = false;
        int i = 0;
        while (i < this.filename.length()) {
            int foundIdx = !isBracketOpen ? findFirstBracket.apply(i, this.filename.length()).intValue() : this.filename.indexOf((String)matchingBracket.get(), i);
            TokenRange range = new TokenRange(i, foundIdx == -1 ? this.filename.length() : foundIdx - i);
            if (range.getSize() > 0) {
                this.tokenizeByPreidentified(isBracketOpen, range);
            }
            if (foundIdx == -1) break;
            this.addToken(Token.TokenCategory.kBracket, true, new TokenRange(range.getOffset() + range.getSize(), 1));
            isBracketOpen = !isBracketOpen;
            i = foundIdx + 1;
        }
    }

    private void tokenizeByPreidentified(boolean enclosed, TokenRange range) {
        ArrayList<TokenRange> preidentifiedTokens = new ArrayList<TokenRange>();
        KeywordManager.getInstance().peekAndAdd(this.filename, range, this.elements, preidentifiedTokens);
        int offset = range.getOffset();
        TokenRange subrange = new TokenRange(range.getOffset(), 0);
        while (offset < range.getOffset() + range.getSize()) {
            for (TokenRange preidentifiedToken : preidentifiedTokens) {
                if (offset != preidentifiedToken.getOffset()) continue;
                if (subrange.getSize() > 0) {
                    this.tokenizeByDelimiters(enclosed, subrange);
                }
                this.addToken(Token.TokenCategory.kIdentifier, enclosed, preidentifiedToken);
                subrange.setOffset(preidentifiedToken.getOffset() + preidentifiedToken.getSize());
                offset = subrange.getOffset() - 1;
                break;
            }
            subrange.setSize(++offset - subrange.getOffset());
        }
        if (subrange.getSize() > 0) {
            this.tokenizeByDelimiters(enclosed, subrange);
        }
    }

    private void tokenizeByDelimiters(boolean enclosed, TokenRange range) {
        String delimiters = this.getDelimiters(range);
        if (delimiters.isEmpty()) {
            this.addToken(Token.TokenCategory.kUnknown, enclosed, range);
            return;
        }
        int i = range.getOffset();
        int end = range.getOffset() + range.getSize();
        while (i < end) {
            Integer found = IntStream.range(i, Math.min(end, this.filename.length())).filter(c -> StringUtils.containsAny((CharSequence)String.valueOf(this.filename.charAt(c)), (CharSequence)delimiters)).findFirst().orElse(end);
            TokenRange subrange = new TokenRange(i, found - i);
            if (subrange.getSize() > 0) {
                this.addToken(Token.TokenCategory.kUnknown, enclosed, subrange);
            }
            if (found == end) break;
            this.addToken(Token.TokenCategory.kDelimiter, enclosed, new TokenRange(subrange.getOffset() + subrange.getSize(), 1));
            i = found + 1;
        }
        this.validateDelimiterTokens();
    }

    private void validateDelimiterTokens() {
        Function<Token.Result, Boolean> isDelimiterToken = r -> r != null && r.token != null && r.token.getCategory() == Token.TokenCategory.kDelimiter;
        Function<Token.Result, Boolean> isUnknownToken = r -> r != null && r.token != null && r.token.getCategory() == Token.TokenCategory.kUnknown;
        Function<Token.Result, Boolean> isSingleCharacterToken = r -> (Boolean)isUnknownToken.apply((Token.Result)r) != false && r.token.getContent().length() == 1 && !r.token.getContent().equals("-");
        BiConsumer<Token, Token.Result> appendTokenTo = (src, dest) -> {
            dest.token.setContent(dest.token.getContent() + src.getContent());
            src.setCategory(Token.TokenCategory.kInvalid);
        };
        for (int i = 0; i < this.tokens.size(); ++i) {
            char nextDelimiter;
            Token token2 = this.tokens.get(i);
            if (token2.getCategory() != Token.TokenCategory.kDelimiter) continue;
            char delimiter = token2.getContent().charAt(0);
            Token.Result prevToken = Token.findPrevToken(this.tokens, i, Token.TokenFlag.kFlagValid);
            Token.Result nextToken = Token.findNextToken(this.tokens, i, Token.TokenFlag.kFlagValid);
            if (delimiter != ' ' && delimiter != '_') {
                if (isSingleCharacterToken.apply(prevToken).booleanValue()) {
                    appendTokenTo.accept(token2, prevToken);
                    while (isUnknownToken.apply(nextToken).booleanValue()) {
                        appendTokenTo.accept(nextToken.token, prevToken);
                        nextToken = Token.findNextToken(this.tokens, i, Token.TokenFlag.kFlagValid);
                        if (!isDelimiterToken.apply(nextToken).booleanValue() || nextToken.token.getContent().charAt(0) != delimiter) continue;
                        appendTokenTo.accept(nextToken.token, prevToken);
                        nextToken = Token.findNextToken(this.tokens, nextToken, Token.TokenFlag.kFlagValid);
                    }
                    continue;
                }
                if (isSingleCharacterToken.apply(nextToken).booleanValue()) {
                    appendTokenTo.accept(token2, prevToken);
                    appendTokenTo.accept(nextToken.token, prevToken);
                    continue;
                }
            }
            if (!isUnknownToken.apply(prevToken).booleanValue() || !isDelimiterToken.apply(nextToken).booleanValue() || delimiter == (nextDelimiter = nextToken.token.getContent().charAt(0)) || delimiter == ',' || nextDelimiter != ' ' && nextDelimiter != '_') continue;
            appendTokenTo.accept(token2, prevToken);
        }
        this.tokens.removeIf(token -> token.getCategory() == Token.TokenCategory.kInvalid);
    }

    static {
        brackets.add((Pair<String, String>)Pair.of((Object)"(", (Object)")"));
        brackets.add((Pair<String, String>)Pair.of((Object)"[", (Object)"]"));
        brackets.add((Pair<String, String>)Pair.of((Object)"{", (Object)"}"));
        brackets.add((Pair<String, String>)Pair.of((Object)"\u300c", (Object)"\u300d"));
        brackets.add((Pair<String, String>)Pair.of((Object)"\u300e", (Object)"\u300e"));
        brackets.add((Pair<String, String>)Pair.of((Object)"\u3010", (Object)"\u3011"));
        brackets.add((Pair<String, String>)Pair.of((Object)"\uff08", (Object)"\uff09"));
    }
}

