/*
 * Decompiled with CFR 0.152.
 */
package eu.drus.maven.plugins;

import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="resolve", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class JavaHomeResolverMojo
extends AbstractMojo {
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=false, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=false, required=true)
    private MavenProject project;
    @Component
    private BuildContext buildContext;

    private DefaultJavaToolChain getToolchain() {
        Toolchain tc;
        DefaultJavaToolChain javaToolchain = null;
        if (this.toolchainManager != null && (tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)).getClass().equals(DefaultJavaToolChain.class)) {
            javaToolchain = (DefaultJavaToolChain)tc;
        }
        return javaToolchain;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String javaHome = null;
        DefaultJavaToolChain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in javahome-resolver-maven-plugin: " + tc));
            javaHome = tc.getJavaHome();
        } else {
            javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                this.getLog().error((CharSequence)"No toolchain configured. No JAVA_HOME configured");
                return;
            }
            this.getLog().error((CharSequence)("No toolchain in javahome-resolver-maven-plugin. Using default JDK[" + javaHome + "]"));
        }
        Properties properties = this.project.getProperties();
        properties.setProperty("javaHome", javaHome);
        this.getLog().info((CharSequence)("javaHome: " + javaHome));
    }
}

