/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.spi.MessageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultTransaction
extends AbstractMessage
implements Transaction {
    private long m_durationInMicro = -1L;
    private List<Message> m_children;
    private MessageManager m_manager;
    private boolean m_standalone;
    private long m_durationStart;

    public DefaultTransaction(String type, String name) {
        super(type, name);
        this.m_durationStart = System.nanoTime();
    }

    public DefaultTransaction(String type, String name, MessageManager manager) {
        super(type, name);
        this.m_manager = manager;
        this.m_standalone = true;
        this.m_durationStart = System.nanoTime();
    }

    @Override
    public DefaultTransaction addChild(Message message) {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Message>();
        }
        if (message != null) {
            this.m_children.add(message);
        } else {
            Cat.logError(new Exception("null child message"));
        }
        return this;
    }

    @Override
    public void complete() {
        try {
            if (this.isCompleted()) {
                DefaultEvent event = new DefaultEvent("cat", "BadInstrument");
                event.setStatus("TransactionAlreadyCompleted");
                event.complete();
                this.addChild(event);
            } else {
                if (this.m_durationInMicro == -1L) {
                    this.m_durationInMicro = (System.nanoTime() - this.m_durationStart) / 1000L;
                }
                this.setCompleted(true);
                if (this.m_manager != null) {
                    this.m_manager.end(this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<Message> getChildren() {
        if (this.m_children == null) {
            return Collections.emptyList();
        }
        return this.m_children;
    }

    @Override
    public long getDurationInMicros() {
        int len;
        if (this.m_durationInMicro >= 0L) {
            return this.m_durationInMicro;
        }
        long duration = 0L;
        int n = len = this.m_children == null ? 0 : this.m_children.size();
        if (len > 0) {
            Message lastChild = this.m_children.get(len - 1);
            if (lastChild instanceof Transaction) {
                DefaultTransaction trx = (DefaultTransaction)lastChild;
                duration = (trx.getTimestamp() - this.getTimestamp()) * 1000L;
            } else {
                duration = (lastChild.getTimestamp() - this.getTimestamp()) * 1000L;
            }
        }
        return duration;
    }

    public void setDurationInMicros(long duration) {
        this.m_durationInMicro = duration;
    }

    @Override
    public long getDurationInMillis() {
        return this.getDurationInMicros() / 1000L;
    }

    @Override
    public void setDurationInMillis(long duration) {
        this.m_durationInMicro = duration * 1000L;
    }

    protected MessageManager getManager() {
        return this.m_manager;
    }

    @Override
    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    @Override
    public boolean isStandalone() {
        return this.m_standalone;
    }

    public void setStandalone(boolean standalone) {
        this.m_standalone = standalone;
    }

    public void setDurationStart(long durationStart) {
        this.m_durationStart = durationStart;
    }

    @Override
    public void setStatus(Throwable e) {
        this.m_status = e.getClass().getName();
        this.m_manager.getThreadLocalMessageTree().setDiscard(false);
    }
}

