/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.util.CleanupHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Named;

@Named
public class MessageIdFactory {
    public static final long HOUR = 3600000L;
    private volatile long m_timestamp = this.getTimestamp();
    private volatile AtomicInteger m_index = new AtomicInteger(0);
    private String m_domain = "UNKNOWN";
    private String m_ipAddress;
    private int m_processID = 0;
    private MappedByteBuffer m_byteBuffer;
    private RandomAccessFile m_markFile;
    private Map<String, AtomicInteger> m_map = new ConcurrentHashMap<String, AtomicInteger>(100);
    private int m_retry;
    private String m_idPrefix;
    private String m_idPrefixOfMultiMode;
    private transient FileChannel m_markChannel;
    private volatile boolean shutdownHookOn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.saveMark();
            if (this.m_byteBuffer != null) {
                MappedByteBuffer mappedByteBuffer = this.m_byteBuffer;
                synchronized (mappedByteBuffer) {
                    CleanupHelper.cleanup(this.m_byteBuffer);
                    this.m_byteBuffer = null;
                }
            }
            if (this.m_markChannel != null) {
                this.m_markChannel.close();
                this.m_markChannel = null;
            }
            if (this.m_markFile != null) {
                this.m_markFile.close();
                this.m_markFile = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File createMarkFile(String domain) {
        File mark = new File(Cat.getCatHome(), "cat-" + domain + ".mark");
        if (!mark.exists()) {
            boolean success = true;
            try {
                success = mark.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
            if (!success) {
                mark = this.createTempFile(domain);
            }
        } else if (!mark.canWrite()) {
            mark = this.createTempFile(domain);
        }
        return mark;
    }

    private File createTempFile(String domain) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File mark = new File(tmpDir, "cat-" + domain + ".mark");
        return mark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextId() {
        long timestamp = this.getTimestamp();
        if (timestamp != this.m_timestamp) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (timestamp != this.m_timestamp) {
                    this.resetCounter(timestamp);
                }
            }
        }
        int index = this.m_index.getAndIncrement();
        StringBuilder sb = new StringBuilder(64);
        if (Cat.isMultiInstanceEnable()) {
            sb.append(this.m_idPrefixOfMultiMode).append(index);
        } else {
            sb.append(this.m_idPrefix).append(index);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextId(String domain) {
        AtomicInteger value;
        if (domain.equals(this.m_domain)) {
            return this.getNextId();
        }
        long timestamp = this.getTimestamp();
        if (timestamp != this.m_timestamp) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (timestamp != this.m_timestamp) {
                    this.resetCounter(timestamp);
                }
            }
        }
        if ((value = this.m_map.get(domain)) == null) {
            Map<String, AtomicInteger> map = this.m_map;
            synchronized (map) {
                value = this.m_map.get(domain);
                if (value == null) {
                    value = new AtomicInteger(0);
                    this.m_map.put(domain, value);
                }
            }
        }
        int index = value.getAndIncrement();
        StringBuilder sb = new StringBuilder(this.m_domain.length() + 32);
        if (Cat.isMultiInstanceEnable()) {
            sb.append(domain).append('-').append(this.m_ipAddress).append(".").append(this.m_processID).append('-').append(timestamp).append('-').append(index);
        } else {
            sb.append(domain).append('-').append(this.m_ipAddress).append('-').append(timestamp).append('-').append(index);
        }
        return sb.toString();
    }

    private int getProcessID() {
        int retInt = -1;
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            retInt = Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
        }
        catch (Exception e) {
            Cat.logError(e);
        }
        if (retInt <= 0) {
            Random rd = new Random();
            retInt = rd.nextInt(18) + 1;
        }
        return retInt;
    }

    protected long getTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp / 3600000L;
    }

    String genIpHex() {
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        List items = Splitters.by((String)".").noEmptyItem().split(ip);
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)Integer.parseInt((String)items.get(i));
        }
        StringBuilder sb = new StringBuilder(bytes.length / 2);
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b >> 4 & 0xF));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String domain) throws IOException {
        block15: {
            this.m_domain = domain;
            this.m_ipAddress = this.genIpHex();
            this.m_processID = this.getProcessID();
            if (this.m_markFile != null) {
                MessageIdFactory messageIdFactory = this;
                synchronized (messageIdFactory) {
                    this.close();
                }
            }
            File mark = this.createMarkFile(domain);
            this.m_markFile = new RandomAccessFile(mark, "rw");
            this.m_markChannel = this.m_markFile.getChannel();
            this.m_byteBuffer = this.m_markChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
            this.m_idPrefix = this.initIdPrefix(this.getTimestamp(), false);
            this.m_idPrefixOfMultiMode = this.initIdPrefix(this.getTimestamp(), true);
            if (this.m_byteBuffer.limit() > 0) {
                try {
                    long lastTimestamp = this.m_byteBuffer.getLong();
                    int index = this.m_byteBuffer.getInt();
                    if (lastTimestamp == this.m_timestamp) {
                        this.m_index = new AtomicInteger(index + 1000);
                        int mapLength = this.m_byteBuffer.getInt();
                        for (int i = 0; i < mapLength; ++i) {
                            int domainLength = this.m_byteBuffer.getInt();
                            byte[] domainArray = new byte[domainLength];
                            this.m_byteBuffer.get(domainArray);
                            int value = this.m_byteBuffer.getInt();
                            this.m_map.put(new String(domainArray), new AtomicInteger(value + 1000));
                        }
                    } else {
                        this.m_index = new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.m_retry;
                    if (this.m_retry != 1) break block15;
                    mark.delete();
                    this.initialize(domain);
                }
            }
        }
        this.saveMark();
        if (!this.shutdownHookOn) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (!this.shutdownHookOn) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            MessageIdFactory.this.close();
                        }
                    });
                }
            }
            this.shutdownHookOn = true;
        }
    }

    private String initIdPrefix(long timestamp, boolean multiMode) {
        StringBuilder sb = new StringBuilder(this.m_domain.length() + 32);
        if (multiMode) {
            sb.append(this.m_domain).append('-').append(this.m_ipAddress).append(".").append(this.m_processID).append('-').append(timestamp).append('-');
        } else {
            sb.append(this.m_domain).append('-').append(this.m_ipAddress).append('-').append(timestamp).append('-');
        }
        return sb.toString();
    }

    private void resetCounter(long timestamp) {
        this.m_index.set(0);
        for (Map.Entry<String, AtomicInteger> entry : this.m_map.entrySet()) {
            entry.getValue().set(0);
        }
        this.m_idPrefix = this.initIdPrefix(timestamp, false);
        this.m_idPrefixOfMultiMode = this.initIdPrefix(timestamp, true);
        this.m_timestamp = timestamp;
    }

    public int getIndex() {
        return this.m_index.get();
    }

    public synchronized void saveMark() {
        if (this.m_byteBuffer == null) {
            return;
        }
        try {
            this.m_byteBuffer.rewind();
            this.m_byteBuffer.putLong(this.m_timestamp);
            this.m_byteBuffer.putInt(this.m_index.get());
            this.m_byteBuffer.putInt(this.m_map.size());
            for (Map.Entry<String, AtomicInteger> entry : this.m_map.entrySet()) {
                byte[] bytes = entry.getKey().toString().getBytes();
                this.m_byteBuffer.putInt(bytes.length);
                this.m_byteBuffer.put(bytes);
                this.m_byteBuffer.putInt(entry.getValue().get());
            }
            this.m_byteBuffer.force();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }
}

