/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat;

import com.dianping.cat.CatPropertyProvider;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.TaggedTransaction;
import com.dianping.cat.message.Trace;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.NullMessage;
import com.dianping.cat.message.internal.NullMessageManager;
import com.dianping.cat.message.internal.NullMessageProducer;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.unidal.initialization.DefaultModuleContext;
import org.unidal.initialization.Module;
import org.unidal.initialization.ModuleContext;
import org.unidal.initialization.ModuleInitializer;
import org.unidal.lookup.ContainerLoader;

public class Cat {
    private static Cat s_instance = new Cat();
    private static AtomicBoolean s_initialized = new AtomicBoolean();
    private static AtomicBoolean s_multiInstanceEnabled = new AtomicBoolean();
    private static int m_errorCount;
    private MessageProducer m_producer;
    private MessageManager m_manager;
    private PlexusContainer m_container;

    private Cat() {
    }

    private static void checkAndInitialize() {
        try {
            if (!s_initialized.get()) {
                Cat.initialize(new ClientConfig());
            }
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static String createMessageId() {
        try {
            return Cat.getProducer().createMessageId();
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
        }
    }

    public static void destroy() {
        try {
            Cat.s_instance.m_container.dispose();
            s_instance = new Cat();
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void enableMultiInstances() {
        s_multiInstanceEnabled.set(true);
    }

    private static void errorHandler(Exception e) {
        if (m_errorCount++ % 100 == 0 || m_errorCount <= 3) {
            e.printStackTrace();
        }
    }

    public static String getCatHome() {
        String catHome = CatPropertyProvider.INST.getProperty("CAT_HOME", "/data/appdatas/cat/");
        if (!catHome.endsWith("/")) {
            catHome = catHome + "/";
        }
        return catHome;
    }

    public static String getCurrentMessageId() {
        try {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            if (tree != null) {
                String messageId = tree.getMessageId();
                if (messageId == null) {
                    messageId = Cat.createMessageId();
                    tree.setMessageId(messageId);
                }
                return messageId;
            }
            return null;
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageProducer.NULL_MESSAGE_PRODUCER.createMessageId();
        }
    }

    public static Cat getInstance() {
        return s_instance;
    }

    public static MessageManager getManager() {
        try {
            Cat.checkAndInitialize();
            MessageManager manager = Cat.s_instance.m_manager;
            if (manager != null) {
                return manager;
            }
            return NullMessageManager.NULL_MESSAGE_MANAGER;
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageManager.NULL_MESSAGE_MANAGER;
        }
    }

    public static MessageProducer getProducer() {
        try {
            Cat.checkAndInitialize();
            MessageProducer producer = Cat.s_instance.m_producer;
            if (producer != null) {
                return producer;
            }
            return NullMessageProducer.NULL_MESSAGE_PRODUCER;
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessageProducer.NULL_MESSAGE_PRODUCER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ClientConfig config) {
        block7: {
            try {
                if (s_initialized.get()) break block7;
                Cat cat = s_instance;
                synchronized (cat) {
                    if (!s_initialized.get()) {
                        PlexusContainer container = ContainerLoader.getDefaultContainer();
                        ClientConfigManager manager = (ClientConfigManager)container.lookup(ClientConfigManager.class);
                        manager.initialize(config);
                        DefaultModuleContext ctx = new DefaultModuleContext(container);
                        Module module = (Module)ctx.lookup(Module.class, "cat-client");
                        if (!module.isInitialized()) {
                            ModuleInitializer initializer = (ModuleInitializer)ctx.lookup(ModuleInitializer.class);
                            initializer.execute((ModuleContext)ctx, new Module[]{module});
                        }
                        Cat.log("INFO", "Cat is lazy initialized!");
                        s_initialized.set(true);
                    }
                }
            }
            catch (Exception e) {
                Cat.errorHandler(e);
            }
        }
    }

    public static void initialize(File configFile) {
        try {
            ClientConfig config = DefaultSaxParser.parse(new FileInputStream(configFile));
            Cat.initialize(config);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void initialize(PlexusContainer container, File configFile) {
        DefaultModuleContext ctx = new DefaultModuleContext(container);
        Module module = (Module)ctx.lookup(Module.class, "cat-client");
        if (!module.isInitialized()) {
            ModuleInitializer initializer = (ModuleInitializer)ctx.lookup(ModuleInitializer.class);
            initializer.execute((ModuleContext)ctx, new Module[]{module});
        }
    }

    public static void initialize(String ... servers) {
        Cat.initializeByDomain(null, servers);
    }

    public static void initializeByDomain(String domain, int tcpPort, int httpPort, String ... servers) {
        try {
            ClientConfig config = new ClientConfigBuilder().build(domain, tcpPort, httpPort, servers);
            Cat.initialize(config);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void initializeByDomain(String domain, String ... servers) {
        Cat.initializeByDomain(domain, 2280, 80, servers);
    }

    public static boolean isInitialized() {
        return s_initialized.get();
    }

    public static boolean isMultiInstanceEnabled() {
        return s_multiInstanceEnabled.get();
    }

    static void log(String severity, String message) {
        MessageFormat format = new MessageFormat("[{0,date,MM-dd HH:mm:ss.sss}] [{1}] [{2}] {3}");
        System.out.println(format.format(new Object[]{new Date(), severity, "cat", message}));
    }

    public static void logError(String message, Throwable cause) {
        try {
            Cat.getProducer().logError(message, cause);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logError(Throwable cause) {
        try {
            Cat.getProducer().logError(cause);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logEvent(String type, String name) {
        try {
            Cat.getProducer().logEvent(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logEvent(String type, String name, String status, String nameValuePairs) {
        try {
            Cat.getProducer().logEvent(type, name, status, nameValuePairs);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logHeartbeat(String type, String name, String status, String nameValuePairs) {
        try {
            Cat.getProducer().logHeartbeat(type, name, status, nameValuePairs);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    @Deprecated
    public static void logMetric(String name, Object ... keyValues) {
    }

    public static void logMetricForCount(String name) {
        Cat.logMetricInternal(name, "C", "1");
    }

    public static void logMetricForCount(String name, int quantity) {
        Cat.logMetricInternal(name, "C", String.valueOf(quantity));
    }

    public static void logMetricForDuration(String name, long durationInMillis) {
        Cat.logMetricInternal(name, "T", String.valueOf(durationInMillis));
    }

    public static void logMetricForSum(String name, double value) {
        Cat.logMetricInternal(name, "S", String.format("%.2f", value));
    }

    public static void logMetricForSum(String name, double sum, int quantity) {
        Cat.logMetricInternal(name, "S,C", String.format("%s,%.2f", quantity, sum));
    }

    private static void logMetricInternal(String name, String status, String keyValuePairs) {
        try {
            Cat.getProducer().logMetric(name, status, keyValuePairs);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logRemoteCallClient(Context ctx) {
        Cat.logRemoteCallClient(ctx, "default");
    }

    public static void logRemoteCallClient(Context ctx, String domain) {
        try {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }
            String childId = Cat.getProducer().createRpcServerId(domain);
            Cat.logEvent("RemoteCall", "", "0", childId);
            String root = tree.getRootMessageId();
            if (root == null) {
                root = messageId;
            }
            ctx.addProperty("_catRootMessageId", root);
            ctx.addProperty("_catParentMessageId", messageId);
            ctx.addProperty("_catChildMessageId", childId);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logRemoteCallServer(Context ctx) {
        try {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String childId = ctx.getProperty("_catChildMessageId");
            String rootId = ctx.getProperty("_catRootMessageId");
            String parentId = ctx.getProperty("_catParentMessageId");
            if (parentId != null) {
                tree.setParentMessageId(parentId);
            }
            if (rootId != null) {
                tree.setRootMessageId(rootId);
            }
            if (childId != null) {
                tree.setMessageId(childId);
            }
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logTrace(String type, String name) {
        try {
            Cat.getProducer().logTrace(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    public static void logTrace(String type, String name, String status, String nameValuePairs) {
        try {
            Cat.getProducer().logTrace(type, name, status, nameValuePairs);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    @Deprecated
    public static <T> T lookup(Class<T> role) throws ComponentLookupException {
        return Cat.lookup(role, null);
    }

    @Deprecated
    public static <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return (T)Cat.s_instance.m_container.lookup(role, hint);
    }

    public static Event newEvent(String type, String name) {
        try {
            return Cat.getProducer().newEvent(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.EVENT;
        }
    }

    public static ForkedTransaction newForkedTransaction(String type, String name) {
        try {
            return Cat.getProducer().newForkedTransaction(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.TRANSACTION;
        }
    }

    public static Heartbeat newHeartbeat(String type, String name) {
        try {
            return Cat.getProducer().newHeartbeat(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.HEARTBEAT;
        }
    }

    public static TaggedTransaction newTaggedTransaction(String type, String name, String tag) {
        try {
            return Cat.getProducer().newTaggedTransaction(type, name, tag);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.TRANSACTION;
        }
    }

    @Deprecated
    public static Trace newTrace(String type, String name) {
        try {
            return Cat.getProducer().newTrace(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.TRACE;
        }
    }

    public static Transaction newTransaction(String type, String name) {
        try {
            return Cat.getProducer().newTransaction(type, name);
        }
        catch (Exception e) {
            Cat.errorHandler(e);
            return NullMessage.TRANSACTION;
        }
    }

    public static void reset() {
    }

    public static void setup(String sessionToken) {
        try {
            Cat.getManager().setup();
        }
        catch (Exception e) {
            Cat.errorHandler(e);
        }
    }

    void setContainer(PlexusContainer container) {
        try {
            this.m_container = container;
            this.m_manager = (MessageManager)container.lookup(MessageManager.class);
            this.m_producer = (MessageProducer)container.lookup(MessageProducer.class);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Unable to get instance of MessageManager, please make sure the environment was setup correctly!", e);
        }
    }

    public static interface Context {
        public static final String ROOT = "_catRootMessageId";
        public static final String PARENT = "_catParentMessageId";
        public static final String CHILD = "_catChildMessageId";

        public void addProperty(String var1, String var2);

        public String getProperty(String var1);
    }

    private static class ClientConfigBuilder {
        private ClientConfigBuilder() {
        }

        public ClientConfig build(String domain, int tcpPort, int httpPort, String ... servers) throws IOException {
            ClientConfig config = new ClientConfig().setMode("client").setDumpLocked(false);
            if (domain != null) {
                config.addDomain(new Domain(domain).setEnabled(true));
            }
            for (String server : servers) {
                config.addServer(new Server(server).setPort(tcpPort).setHttpPort(httpPort));
            }
            return config;
        }
    }
}

