/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analyzer;

import com.dianping.cat.Cat;
import com.dianping.cat.analyzer.DurationComputer;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.ProblemLongType;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionAggregator {
    private static TransactionAggregator s_instance = new TransactionAggregator();
    private volatile ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> m_transactions = new ConcurrentHashMap();

    public static TransactionAggregator getInstance() {
        return s_instance;
    }

    private TransactionData createTransactionData(String type, String name) {
        return new TransactionData(type, name);
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> getAndResetTransactions() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> cloned = this.m_transactions;
        this.m_transactions = new ConcurrentHashMap();
        for (Map.Entry<String, ConcurrentHashMap<String, TransactionData>> entry : cloned.entrySet()) {
            String type = entry.getKey();
            this.m_transactions.putIfAbsent(type, new ConcurrentHashMap());
        }
        return cloned;
    }

    public String getDomain(MessageTree tree) {
        return Cat.getManager().getDomain();
    }

    public void logBatchTransaction(String type, String name, int count, int error, long sum) {
        this.makeSureTransactionExist(type, name).add(count, error, sum);
    }

    public void logTransaction(Transaction t) {
        this.makeSureTransactionExist(t.getType(), t.getName()).add(t);
    }

    private TransactionData makeSureTransactionExist(String type, String name) {
        TransactionData data;
        ConcurrentHashMap<String, TransactionData> oldValue;
        ConcurrentHashMap<String, TransactionData> item = this.m_transactions.get(type);
        if (null == item && (oldValue = this.m_transactions.putIfAbsent(type, item = new ConcurrentHashMap())) != null) {
            item = oldValue;
        }
        if (null == (data = item.get(name))) {
            data = this.createTransactionData(type, name);
            TransactionData oldValue2 = item.putIfAbsent(name, data);
            if (oldValue2 == null) {
                return data;
            }
            return oldValue2;
        }
        return data;
    }

    public void sendTransactionData() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> transactions = this.getAndResetTransactions();
        boolean hasData = false;
        block0: for (Map map : transactions.values()) {
            for (TransactionData transactionData : map.values()) {
                if (transactionData.getCount().get() <= 0) continue;
                hasData = true;
                continue block0;
            }
        }
        if (hasData) {
            Transaction t = Cat.newTransaction("System", this.getClass().getSimpleName());
            MessageTree messageTree = Cat.getManager().getThreadLocalMessageTree();
            messageTree.setDomain(this.getDomain(messageTree));
            messageTree.setDiscardPrivate(false);
            for (Map map : transactions.values()) {
                for (TransactionData data : map.values()) {
                    if (data.getCount().get() <= 0) continue;
                    Transaction tmp = Cat.newTransaction(data.getType(), data.getName());
                    StringBuilder sb = new StringBuilder(32);
                    sb.append('@').append(data.getCount().get()).append(";");
                    sb.append(data.getFail().get()).append(";");
                    sb.append(data.getSum().get()).append(";");
                    sb.append(data.getDurationString()).append(";").append(data.getLongDurationString());
                    tmp.addData(sb.toString());
                    tmp.setSuccessStatus();
                    tmp.complete();
                }
            }
            t.setSuccessStatus();
            t.complete();
        }
    }

    private int checkAndGetLongThreshold(String type, int duration) {
        ClientConfigManager config = Cat.getManager().getConfigManager();
        ProblemLongType longType = ProblemLongType.findByMessageType(type);
        if (longType != null) {
            switch (longType) {
                case LONG_CACHE: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_CACHE.getName(), duration);
                }
                case LONG_CALL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_CALL.getName(), duration);
                }
                case LONG_SERVICE: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_SERVICE.getName(), duration);
                }
                case LONG_SQL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_SQL.getName(), duration);
                }
                case LONG_URL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_URL.getName(), duration);
                }
                case LONG_MQ: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_MQ.getName(), duration);
                }
            }
        }
        return -1;
    }

    public class TransactionData {
        private String m_type;
        private String m_name;
        private AtomicInteger m_count = new AtomicInteger();
        private AtomicInteger m_fail = new AtomicInteger();
        private AtomicLong m_sum = new AtomicLong();
        private ConcurrentHashMap<Integer, AtomicInteger> m_durations = new ConcurrentHashMap();
        private ConcurrentHashMap<Integer, AtomicInteger> m_longDurations = new ConcurrentHashMap();

        public TransactionData(String type, String name) {
            this.m_type = type;
            this.m_name = name;
        }

        public TransactionData add(int count, int error, long sum) {
            this.m_count.addAndGet(count);
            this.m_sum.addAndGet(sum);
            this.m_fail.addAndGet(error);
            if (count == 1) {
                int duration = DurationComputer.computeDuration((int)sum);
                AtomicInteger durationCount = this.m_durations.get(duration);
                if (durationCount == null) {
                    this.m_durations.put(duration, new AtomicInteger(1));
                } else {
                    durationCount.incrementAndGet();
                }
            }
            return this;
        }

        public TransactionData add(Transaction t) {
            int duration;
            AtomicInteger count;
            this.m_count.incrementAndGet();
            this.m_sum.getAndAdd(t.getDurationInMillis());
            if (!t.isSuccess()) {
                this.m_fail.incrementAndGet();
            }
            if ((count = this.m_durations.get(duration = DurationComputer.computeDuration((int)t.getDurationInMillis()))) == null) {
                count = new AtomicInteger(0);
                AtomicInteger oldCount = this.m_durations.putIfAbsent(duration, count);
                if (oldCount != null) {
                    count = oldCount;
                }
            }
            count.incrementAndGet();
            int longDuration = TransactionAggregator.this.checkAndGetLongThreshold(t.getType(), duration);
            if (longDuration > 0) {
                AtomicInteger longCount = this.m_longDurations.get(longDuration);
                if (longCount == null) {
                    longCount = new AtomicInteger(0);
                    AtomicInteger oldLongCount = this.m_longDurations.putIfAbsent(longDuration, longCount);
                    if (oldLongCount != null) {
                        longCount = oldLongCount;
                    }
                }
                longCount.incrementAndGet();
            }
            return this;
        }

        public AtomicInteger getCount() {
            return this.m_count;
        }

        public Map<Integer, AtomicInteger> getDurations() {
            return this.m_durations;
        }

        public String getDurationString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<Integer, AtomicInteger> entry : this.m_durations.entrySet()) {
                Integer key = entry.getKey();
                AtomicInteger value = entry.getValue();
                if (first) {
                    sb.append(key).append(',').append(value);
                    first = false;
                    continue;
                }
                sb.append('|').append(key).append(',').append(value);
            }
            return sb.toString();
        }

        public Map<Integer, AtomicInteger> getLongDurations() {
            return this.m_longDurations;
        }

        public String getLongDurationString() {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<Integer, AtomicInteger> entry : this.m_longDurations.entrySet()) {
                Integer key = entry.getKey();
                AtomicInteger value = entry.getValue();
                if (first) {
                    sb.append(key).append(',').append(value);
                    first = false;
                    continue;
                }
                sb.append('|').append(key).append(',').append(value);
            }
            return sb.toString();
        }

        public AtomicInteger getFail() {
            return this.m_fail;
        }

        public String getName() {
            return this.m_name;
        }

        public AtomicLong getSum() {
            return this.m_sum;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

