/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.AtomicTreeParser;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.KVConfig;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.ProblemLongType;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.configuration.client.transform.BaseVisitor;
import com.dianping.cat.configuration.client.transform.DefaultSaxParser;
import com.dianping.cat.message.spi.MessageTree;
import com.site.helper.JsonBuilder;
import com.site.helper.Splitters;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.helper.Files;
import org.unidal.helper.Urls;
import org.unidal.lookup.annotation.Named;

@Named(type=ClientConfigManager.class)
public class DefaultClientConfigManager
implements LogEnabled,
ClientConfigManager {
    private static final String PROPERTIES_FILE = "/META-INF/app.properties";
    private ClientConfig m_config = new ClientConfig();
    private AtomicBoolean m_initialized = new AtomicBoolean();
    private volatile double m_sampleRate = 1.0;
    private volatile boolean m_block = false;
    private String m_routers;
    private JsonBuilder m_jsonBuilder = new JsonBuilder();
    private AtomicTreeParser m_atomicTreeParser = new AtomicTreeParser();
    private Map<String, List<Integer>> m_longConfigs = new LinkedHashMap<String, List<Integer>>();
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private ClientConfig getConfig() {
        if (!this.m_initialized.get()) {
            this.m_config.accept(new ClientXmlLoader());
            this.m_config.accept(new AppPropertyLoader());
            this.m_config.accept(new ConfigValidator());
            this.m_initialized.set(true);
        }
        return this.m_config;
    }

    @Override
    public Domain getDomain() {
        ClientConfig config = this.getConfig();
        Iterator<Domain> iterator = config.getDomains().values().iterator();
        if (iterator.hasNext()) {
            Domain domain = iterator.next();
            return domain;
        }
        return new Domain("Known").setEnabled(true);
    }

    @Override
    public int getLongThresholdByDuration(String key, int duration) {
        List<Integer> values = this.m_longConfigs.get(key);
        if (values != null) {
            for (int i = values.size() - 1; i >= 0; --i) {
                int userThreshold = values.get(i);
                if (duration < userThreshold) continue;
                return userThreshold;
            }
        }
        return -1;
    }

    @Override
    public String getRouters() {
        if (this.m_routers == null) {
            this.refreshConfig();
        }
        return this.m_routers;
    }

    @Override
    public double getSampleRatio() {
        return this.m_sampleRate;
    }

    private String getServerConfigUrl() {
        List<Server> servers = this.getConfig().getServers();
        int size = servers.size();
        int index = (int)((double)size * Math.random());
        if (index >= 0 && index < size) {
            Server server = servers.get(index);
            String ip = server.getIp().trim();
            int port = server.getHttpPort();
            String localIp = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
            String domain = this.getDomain().getId();
            return String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=json", ip, port, domain, localIp);
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        return this.getConfig().getServers();
    }

    @Override
    public int getTaggedTransactionCacheSize() {
        return 1024;
    }

    @Override
    public void initialize(ClientConfig source) {
        source.accept(new ConfigExtractor(this.m_config));
    }

    @Override
    public boolean isAtomicMessage(MessageTree tree) {
        return this.m_atomicTreeParser.isAtomicMessage(tree);
    }

    @Override
    public boolean isBlock() {
        return this.m_block;
    }

    @Override
    public boolean isCatEnabled() {
        return this.getConfig().isEnabled();
    }

    @Override
    public boolean isDumpLocked() {
        return this.getConfig().isDumpLocked();
    }

    @Override
    public void refreshConfig() {
        String url = this.getServerConfigUrl();
        try {
            InputStream inputstream = Urls.forIO().readTimeout(2000).connectTimeout(1000).openStream(url);
            String content = Files.forIO().readFrom(inputstream, "utf-8");
            KVConfig routerConfig = (KVConfig)this.m_jsonBuilder.parse(content.trim(), KVConfig.class);
            this.m_routers = routerConfig.getValue("routers");
            this.m_block = Boolean.valueOf(routerConfig.getValue("block").trim());
            this.m_sampleRate = Double.valueOf(routerConfig.getValue("sample").trim());
            if (this.m_sampleRate <= 0.0) {
                this.m_sampleRate = 0.0;
            }
            String startTypes = routerConfig.getValue("startTransactionTypes");
            String matchTypes = routerConfig.getValue("matchTransactionTypes");
            this.m_atomicTreeParser.init(startTypes, matchTypes);
            for (ProblemLongType longType : ProblemLongType.values()) {
                String name = longType.getName();
                String propertyName = name + "s";
                String values = routerConfig.getValue(propertyName);
                if (values == null) continue;
                List<String> valueStrs = Splitters.by(',').trim().split(values);
                LinkedList<Integer> thresholds = new LinkedList<Integer>();
                for (String valueStr : valueStrs) {
                    try {
                        thresholds.add(Integer.parseInt(valueStr));
                    }
                    catch (Exception exception) {}
                }
                if (thresholds.isEmpty()) continue;
                this.m_longConfigs.put(name, thresholds);
            }
        }
        catch (Exception e) {
            this.m_logger.warn("error when connect cat server config url " + url);
        }
    }

    private static class ConfigValidator
    extends BaseVisitor {
        private ConfigValidator() {
        }

        @Override
        public void visitConfig(ClientConfig config) {
            if (config.getDomains().isEmpty()) {
                config.setEnabled(false);
            }
            if (config.getServers().isEmpty()) {
                config.setEnabled(false);
            }
        }
    }

    private static class ConfigExtractor
    extends BaseVisitor {
        private ClientConfig m_config;

        public ConfigExtractor(ClientConfig config) {
            this.m_config = config;
        }

        @Override
        public void visitDomain(Domain domain) {
            Domain d = this.m_config.findDomain(domain.getId());
            if (d == null) {
                d = new Domain().setId(domain.getId());
                this.m_config.addDomain(d);
            }
            d.mergeAttributes(domain);
        }

        @Override
        public void visitServer(Server server) {
            Server s = this.m_config.findServer(server.getIp());
            if (s == null) {
                s = new Server().setIp(server.getIp());
                this.m_config.addServer(s);
            }
            s.mergeAttributes(server);
        }
    }

    private class ClientXmlLoader
    extends BaseVisitor {
        private ClientXmlLoader() {
        }

        @Override
        public void visitConfig(ClientConfig config) {
            File configFile;
            if ((config.getDomains().isEmpty() || config.getServers().isEmpty()) && (configFile = new File(Cat.getCatHome(), "client.xml")).exists()) {
                try {
                    ClientConfig c = DefaultSaxParser.parse(new FileInputStream(configFile));
                    DefaultClientConfigManager.this.m_config = config;
                    super.visitConfig(c);
                }
                catch (Exception e) {
                    DefaultClientConfigManager.this.m_logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public void visitDomain(Domain domain) {
            Domain d = DefaultClientConfigManager.this.m_config.findDomain(domain.getId());
            if (d == null) {
                d = new Domain().setId(domain.getId());
                DefaultClientConfigManager.this.m_config.addDomain(d);
            }
            d.mergeAttributes(domain);
        }

        @Override
        public void visitServer(Server server) {
            Server s = DefaultClientConfigManager.this.m_config.findServer(server.getIp());
            if (s == null) {
                s = new Server().setIp(server.getIp());
                DefaultClientConfigManager.this.m_config.addServer(s);
            }
            s.mergeAttributes(server);
        }
    }

    private class AppPropertyLoader
    extends BaseVisitor {
        private AppPropertyLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getAppNameFromProperties() {
            String appName = "Unknown";
            InputStream in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(DefaultClientConfigManager.PROPERTIES_FILE);
                if (in == null) {
                    in = Cat.class.getResourceAsStream(DefaultClientConfigManager.PROPERTIES_FILE);
                }
                if (in != null) {
                    Properties prop = new Properties();
                    prop.load(in);
                    appName = prop.getProperty("app.name");
                    if (appName == null) {
                        DefaultClientConfigManager.this.m_logger.info(String.format("No property(app.name) defined in resource(%s)!", DefaultClientConfigManager.PROPERTIES_FILE));
                    }
                } else {
                    DefaultClientConfigManager.this.m_logger.info(String.format("No resource(%s) found!", DefaultClientConfigManager.PROPERTIES_FILE));
                }
            }
            catch (Exception e) {
                DefaultClientConfigManager.this.m_logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return appName;
        }

        @Override
        public void visitConfig(ClientConfig config) {
            if (config.getDomains().isEmpty()) {
                String name = this.getAppNameFromProperties();
                Domain d = new Domain(name).setEnabled(true);
                config.addDomain(d);
            }
        }
    }
}

