/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.property.entity.Property;
import com.dianping.cat.configuration.property.entity.PropertyConfig;
import com.dianping.cat.util.json.JsonObject;
import java.text.ParseException;
import java.util.Iterator;

public class ClientMessage {
    public static final int PROTOCOL_ID = 1667331171;
    public static final int VERSION_0 = 0;
    private final int m_protocolId;
    private final int m_version;
    private final byte[] m_data;

    public ClientMessage(int protocolId, int version, byte[] data) {
        this.m_protocolId = protocolId;
        this.m_version = version;
        this.m_data = data;
    }

    public ClientMessage(int protocolId, int version, String data) {
        this.m_protocolId = protocolId;
        this.m_version = version;
        this.m_data = data.getBytes();
    }

    public static void main(String[] args) {
        byte[] bytes = "catc".getBytes();
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            ret <<= 8;
            ret |= bytes[i] & 0xFF;
        }
        System.out.println(ret);
    }

    public byte[] getData() {
        return this.m_data;
    }

    public int getProtocolId() {
        return this.m_protocolId;
    }

    public int getVersion() {
        return this.m_version;
    }

    public PropertyConfig toPropertyConfig() {
        JsonObject object;
        try {
            object = new JsonObject(new String(this.m_data));
        }
        catch (ParseException e) {
            Cat.logError(e);
            return null;
        }
        JsonObject kvs = object.getJSONObject("kvs");
        if (kvs == null) {
            return null;
        }
        PropertyConfig config = new PropertyConfig();
        Iterator<String> it = kvs.keys();
        while (it.hasNext()) {
            String key = it.next();
            String val = kvs.getString(key);
            if (val == null) continue;
            config.addProperty(new Property().setId(key).setValue(val));
        }
        return config;
    }
}

