/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.spi.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Metric;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.io.BufReleaseHelper;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.codec.PlainTextMessageCodec;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class DefaultMessageTree
implements MessageTree {
    private ByteBuf m_buf;
    private String m_domain;
    private String m_hostName;
    private String m_ipAddress;
    private Message m_message;
    private String m_messageId;
    private String m_parentMessageId;
    private String m_rootMessageId;
    private String m_sessionToken;
    private String m_threadGroupName;
    private String m_threadId;
    private String m_threadName;
    private MessageId m_formatMessageId;
    private boolean m_discard = true;
    private boolean m_processLoss = false;
    private boolean m_hitSample = false;
    private List<Event> events = new ArrayList<Event>();
    private List<Transaction> transactions = new ArrayList<Transaction>();
    private List<Heartbeat> heartbeats = new ArrayList<Heartbeat>();
    private List<Metric> metrics = new ArrayList<Metric>();

    @Override
    public boolean canDiscard() {
        return this.m_discard;
    }

    @Override
    public MessageTree copy() {
        DefaultMessageTree tree = new DefaultMessageTree();
        tree.setDomain(this.m_domain);
        tree.setHostName(this.m_hostName);
        tree.setIpAddress(this.m_ipAddress);
        tree.setMessageId(this.m_messageId);
        tree.setParentMessageId(this.m_parentMessageId);
        tree.setRootMessageId(this.m_rootMessageId);
        tree.setSessionToken(this.m_sessionToken);
        tree.setThreadGroupName(this.m_threadGroupName);
        tree.setThreadId(this.m_threadId);
        tree.setThreadName(this.m_threadName);
        tree.setMessage(this.m_message);
        tree.setDiscardPrivate(this.m_discard);
        tree.setHitSample(this.m_hitSample);
        return tree;
    }

    @Override
    public List<Event> findOrCreateEvents() {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        return this.events;
    }

    @Override
    public List<Heartbeat> findOrCreateHeartbeats() {
        if (this.heartbeats == null) {
            this.heartbeats = new ArrayList<Heartbeat>();
        }
        return this.heartbeats;
    }

    @Override
    public List<Metric> findOrCreateMetrics() {
        if (this.metrics == null) {
            this.metrics = new ArrayList<Metric>();
        }
        return this.metrics;
    }

    @Override
    public List<Transaction> findOrCreateTransactions() {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        return this.transactions;
    }

    public MessageTree copyForTest() {
        ByteBuf buf = null;
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = codec.encode(this);
            return codec.decode(buf);
        }
        catch (Exception ex) {
            Cat.logError(ex);
            return null;
        }
    }

    public void clearMessageList() {
        if (this.transactions != null) {
            this.transactions.clear();
        }
        if (this.events != null) {
            this.events.clear();
        }
        if (this.heartbeats != null) {
            this.heartbeats.clear();
        }
        if (this.metrics != null) {
            this.metrics.clear();
        }
    }

    @Override
    public ByteBuf getBuffer() {
        return this.m_buf;
    }

    public void setBuffer(ByteBuf buf) {
        this.m_buf = buf;
    }

    @Override
    public String getDomain() {
        return this.m_domain;
    }

    @Override
    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public MessageId getFormatMessageId() {
        if (this.m_formatMessageId == null) {
            this.m_formatMessageId = MessageId.parse(this.m_messageId);
        }
        return this.m_formatMessageId;
    }

    @Override
    public void setFormatMessageId(MessageId formatMessageId) {
        this.m_formatMessageId = formatMessageId;
    }

    @Override
    public List<Heartbeat> getHeartbeats() {
        return this.heartbeats;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @Override
    public String getSessionToken() {
        return this.m_sessionToken;
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.m_sessionToken = sessionToken;
    }

    @Override
    public Message getMessage() {
        return this.m_message;
    }

    @Override
    public void setMessage(Message message) {
        this.m_message = message;
    }

    @Override
    public String getMessageId() {
        return this.m_messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        if (messageId != null && messageId.length() > 0) {
            this.m_messageId = messageId;
        }
    }

    @Override
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    public String getParentMessageId() {
        return this.m_parentMessageId;
    }

    @Override
    public void setParentMessageId(String parentMessageId) {
        if (parentMessageId != null && parentMessageId.length() > 0) {
            this.m_parentMessageId = parentMessageId;
        }
    }

    @Override
    public String getRootMessageId() {
        return this.m_rootMessageId;
    }

    @Override
    public void setRootMessageId(String rootMessageId) {
        if (rootMessageId != null && rootMessageId.length() > 0) {
            this.m_rootMessageId = rootMessageId;
        }
    }

    @Override
    public String getThreadGroupName() {
        return this.m_threadGroupName;
    }

    @Override
    public void setThreadGroupName(String threadGroupName) {
        this.m_threadGroupName = threadGroupName;
    }

    @Override
    public String getThreadId() {
        return this.m_threadId;
    }

    @Override
    public void setThreadId(String threadId) {
        this.m_threadId = threadId;
    }

    @Override
    public String getThreadName() {
        return this.m_threadName;
    }

    @Override
    public void setThreadName(String threadName) {
        this.m_threadName = threadName;
    }

    @Override
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isProcessLoss() {
        return this.m_processLoss;
    }

    @Override
    public void setProcessLoss(boolean loss) {
        this.m_processLoss = loss;
    }

    @Override
    public void setDiscard(boolean discard) {
        this.m_discard = discard;
    }

    @Override
    public boolean isHitSample() {
        return this.m_hitSample;
    }

    @Override
    public void setHitSample(boolean hitSample) {
        this.m_hitSample = hitSample;
    }

    @Override
    public void setDiscardPrivate(boolean discard) {
        this.m_discard = discard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        ByteBuf buf = null;
        String result = "";
        try {
            PlainTextMessageCodec codec = new PlainTextMessageCodec();
            buf = codec.encode(this);
            buf.readInt();
            result = buf.toString(Charset.forName("utf-8"));
            if (buf == null) return result;
        }
        catch (Exception ex) {
            try {
                Cat.logError(ex);
                if (buf == null) return result;
            }
            catch (Throwable throwable) {
                if (buf == null) throw throwable;
                BufReleaseHelper.release(buf);
                throw throwable;
            }
            BufReleaseHelper.release(buf);
            return result;
        }
        BufReleaseHelper.release(buf);
        return result;
    }
}

