/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.servlet;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultMessageManager;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.spi.MessageTree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unidal.helper.Joiners;

public class CatFilter
implements Filter {
    private static Map<MessageFormat, String> s_patterns = new LinkedHashMap<MessageFormat, String>();
    private List<Handler> m_handlers = new ArrayList<Handler>();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Context ctx = new Context((HttpServletRequest)request, (HttpServletResponse)response, chain, this.m_handlers);
        ctx.handle();
    }

    protected String getOriginalUrl(ServletRequest request) {
        return ((HttpServletRequest)request).getRequestURI();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String pattern = filterConfig.getInitParameter("pattern");
        if (pattern != null) {
            try {
                String[] patterns;
                for (String temp : patterns = pattern.split(";")) {
                    String[] temps = temp.split(":");
                    s_patterns.put(new MessageFormat(temps[0].trim()), temps[1].trim());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_handlers.add(CatHandler.ENVIRONMENT);
        this.m_handlers.add(CatHandler.ID_SETUP);
        this.m_handlers.add(CatHandler.LOG_SPAN);
        this.m_handlers.add(CatHandler.LOG_CLIENT_PAYLOAD);
    }

    protected static class Context {
        private FilterChain m_chain;
        private List<Handler> m_handlers;
        private int m_index;
        private int m_mode;
        private String m_rootId;
        private String m_parentId;
        private String m_id;
        private HttpServletRequest m_request;
        private HttpServletResponse m_response;
        private boolean m_top;
        private String m_type;

        public Context(HttpServletRequest request, HttpServletResponse response, FilterChain chain, List<Handler> handlers) {
            this.m_request = request;
            this.m_response = response;
            this.m_chain = chain;
            this.m_handlers = handlers;
        }

        public String getId() {
            return this.m_id;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public int getMode() {
            return this.m_mode;
        }

        public void setMode(int mode) {
            this.m_mode = mode;
        }

        public String getParentId() {
            return this.m_parentId;
        }

        public void setParentId(String parentId) {
            this.m_parentId = parentId;
        }

        public HttpServletRequest getRequest() {
            return this.m_request;
        }

        public HttpServletResponse getResponse() {
            return this.m_response;
        }

        public String getRootId() {
            return this.m_rootId;
        }

        public void setRootId(String rootId) {
            this.m_rootId = rootId;
        }

        public String getType() {
            return this.m_type;
        }

        public void setType(String type) {
            this.m_type = type;
        }

        public void handle() throws IOException, ServletException {
            if (this.m_index < this.m_handlers.size()) {
                Handler handler = this.m_handlers.get(this.m_index++);
                handler.handle(this);
            } else {
                this.m_chain.doFilter((ServletRequest)this.m_request, (ServletResponse)this.m_response);
            }
        }

        public boolean isTop() {
            return this.m_top;
        }

        public void setTop(boolean top) {
            this.m_top = top;
        }
    }

    protected static interface Handler {
        public void handle(Context var1) throws IOException, ServletException;
    }

    private static enum CatHandler implements Handler
    {
        ENVIRONMENT{

            protected int detectMode(HttpServletRequest req) {
                String source = req.getHeader("X-CAT-SOURCE");
                String id = req.getHeader("X-CAT-ID");
                if ("container".equals(source)) {
                    return 2;
                }
                if (id != null && id.length() > 0) {
                    return 1;
                }
                return 0;
            }

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                HttpServletRequest req = ctx.getRequest();
                boolean top = !Cat.getManager().hasContext();
                ctx.setTop(top);
                if (top) {
                    ctx.setMode(this.detectMode(req));
                    ctx.setType("URL");
                    this.setTraceMode(req);
                } else {
                    ctx.setType("URL.Forward");
                }
                ctx.handle();
            }

            protected void setTraceMode(HttpServletRequest req) {
                String traceMode = "X-CAT-TRACE-MODE";
                String headMode = req.getHeader(traceMode);
                if ("true".equals(headMode)) {
                    Cat.getManager().setTraceMode(true);
                }
            }
        }
        ,
        ID_SETUP{
            private String m_servers;

            private String getCatServer() {
                if (this.m_servers == null) {
                    DefaultMessageManager manager = (DefaultMessageManager)Cat.getManager();
                    List<Server> servers = manager.getConfigManager().getServers();
                    this.m_servers = Joiners.by((char)',').join(servers, (Joiners.IBuilder)new Joiners.IBuilder<Server>(){

                        public String asString(Server server) {
                            String ip = server.getIp();
                            Integer httpPort = server.getHttpPort();
                            if ("127.0.0.1".equals(ip)) {
                                ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
                            }
                            return ip + ":" + httpPort;
                        }
                    });
                }
                return this.m_servers;
            }

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                boolean isTraceMode = Cat.getManager().isTraceMode();
                HttpServletRequest req = ctx.getRequest();
                HttpServletResponse res = ctx.getResponse();
                MessageProducer producer = Cat.getProducer();
                int mode = ctx.getMode();
                switch (mode) {
                    case 0: {
                        ctx.setId(producer.createMessageId());
                        break;
                    }
                    case 1: {
                        ctx.setRootId(req.getHeader("X-CAT-ROOT-ID"));
                        ctx.setParentId(req.getHeader("X-CAT-PARENT-ID"));
                        ctx.setId(req.getHeader("X-CAT-ID"));
                        break;
                    }
                    case 2: {
                        ctx.setRootId(producer.createMessageId());
                        ctx.setParentId(ctx.getRootId());
                        ctx.setId(producer.createMessageId());
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Internal Error: unsupported mode(%s)!", mode));
                    }
                }
                if (isTraceMode) {
                    MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                    tree.setMessageId(ctx.getId());
                    tree.setParentMessageId(ctx.getParentId());
                    tree.setRootMessageId(ctx.getRootId());
                    res.setHeader("X-CAT-SERVER", this.getCatServer());
                    switch (mode) {
                        case 0: {
                            res.setHeader("X-CAT-ROOT-ID", ctx.getId());
                            break;
                        }
                        case 1: {
                            res.setHeader("X-CAT-ROOT-ID", ctx.getRootId());
                            res.setHeader("X-CAT-PARENT-ID", ctx.getParentId());
                            res.setHeader("X-CAT-ID", ctx.getId());
                            break;
                        }
                        case 2: {
                            res.setHeader("X-CAT-ROOT-ID", ctx.getRootId());
                            res.setHeader("X-CAT-PARENT-ID", ctx.getParentId());
                            res.setHeader("X-CAT-ID", ctx.getId());
                        }
                    }
                }
                ctx.handle();
            }
        }
        ,
        LOG_CLIENT_PAYLOAD{

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                HttpServletRequest req = ctx.getRequest();
                String type = ctx.getType();
                if (ctx.isTop()) {
                    this.logRequestClientInfo(req, type);
                    this.logRequestPayload(req, type);
                } else {
                    this.logRequestPayload(req, type);
                }
                ctx.handle();
            }

            protected void logRequestClientInfo(HttpServletRequest req, String type) {
                StringBuilder sb = new StringBuilder(1024);
                String ip = "";
                String ipForwarded = req.getHeader("x-forwarded-for");
                ip = ipForwarded == null ? req.getRemoteAddr() : ipForwarded;
                sb.append("IPS=").append(ip);
                sb.append("&VirtualIP=").append(req.getRemoteAddr());
                sb.append("&Server=").append(req.getServerName());
                sb.append("&Referer=").append(req.getHeader("referer"));
                sb.append("&Agent=").append(req.getHeader("user-agent"));
                Cat.logEvent(type, type + ".Server", "0", sb.toString());
            }

            protected void logRequestPayload(HttpServletRequest req, String type) {
                StringBuilder sb = new StringBuilder(256);
                sb.append(req.getScheme().toUpperCase()).append('/');
                sb.append(req.getMethod()).append(' ').append(req.getRequestURI());
                String qs = req.getQueryString();
                if (qs != null) {
                    sb.append('?').append(qs);
                }
                Cat.logEvent(type, type + ".Method", "0", sb.toString());
            }
        }
        ,
        LOG_SPAN{

            private void customizeStatus(Transaction t, HttpServletRequest req) {
                Object catStatus = req.getAttribute("cat-state");
                if (catStatus != null) {
                    t.setStatus(catStatus.toString());
                } else {
                    t.setStatus("0");
                }
            }

            private void customizeUri(Transaction t, HttpServletRequest req) {
                if (t instanceof DefaultTransaction) {
                    Object catPageUri;
                    Object catPageType = req.getAttribute("cat-page-type");
                    if (catPageType instanceof String) {
                        ((DefaultTransaction)t).setType(catPageType.toString());
                    }
                    if ((catPageUri = req.getAttribute("cat-page-uri")) instanceof String) {
                        ((DefaultTransaction)t).setName(catPageUri.toString());
                    }
                }
            }

            private String getRequestURI(HttpServletRequest req) {
                String requestURI = req.getRequestURI();
                if (s_patterns.size() == 0) {
                    return requestURI;
                }
                for (Map.Entry entry : s_patterns.entrySet()) {
                    MessageFormat format = (MessageFormat)entry.getKey();
                    try {
                        format.parse(requestURI);
                        return (String)entry.getValue();
                    }
                    catch (Exception exception) {
                    }
                }
                return requestURI;
            }

            @Override
            public void handle(Context ctx) throws IOException, ServletException {
                HttpServletRequest req = ctx.getRequest();
                Transaction t = Cat.newTransaction(ctx.getType(), this.getRequestURI(req));
                try {
                    ctx.handle();
                    this.customizeStatus(t, req);
                }
                catch (ServletException e) {
                    t.setStatus(e);
                    Cat.logError(e);
                    throw e;
                }
                catch (IOException e) {
                    t.setStatus(e);
                    Cat.logError(e);
                    throw e;
                }
                catch (Throwable e) {
                    t.setStatus(e);
                    Cat.logError(e);
                    throw new RuntimeException(e);
                }
                finally {
                    this.customizeUri(t, req);
                    t.complete();
                }
            }
        };

    }
}

