/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.servlet;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Metric;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.unidal.lookup.util.StringUtils;

public class CdnFilter
implements Filter {
    private static final String DI_LIAN = "DiLian";
    private static final String WANG_SU = "WangSu";
    private static final String TENG_XUN = "TengXun";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String vip = this.queryVip(httpServletRequest);
            String sourceIp = this.querySourceIp(httpServletRequest);
            if (StringUtils.isNotEmpty((String)sourceIp) && StringUtils.isNotEmpty((String)vip)) {
                Metric metric = Cat.getProducer().newMetric("cdn", vip + ":" + sourceIp);
                metric.setStatus("C");
                metric.addData(String.valueOf(1));
            }
        }
        catch (Exception e) {
            Cat.logError(e);
        }
        chain.doFilter(request, response);
    }

    private String filterXForwardedForIP(String ip) {
        if (ip == null || ip.trim().length() == 0) {
            return null;
        }
        String[] subIps = ip.split(",");
        int length = subIps.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            String subIp = subIps[i];
            if (subIp == null || subIp.trim().length() == 0 || (subIp = subIp.trim()).startsWith("192.168.") || subIp.startsWith("10.") || "127.0.0.1".equals(subIp)) continue;
            if (subIp.startsWith("172.")) {
                String[] iptabs = subIp.split("\\.");
                int tab2 = Integer.parseInt(iptabs[1]);
                if (tab2 >= 16 && tab2 <= 31) continue;
                index = i;
                break;
            }
            index = i;
            break;
        }
        if (index > -1 && index + 1 <= length) {
            return subIps[index + 1];
        }
        return null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private String querySourceIp(HttpServletRequest request) {
        return this.filterXForwardedForIP(request.getHeader("x-forwarded-for"));
    }

    private String queryVip(HttpServletRequest request) {
        String serverName = request.getServerName();
        if (serverName != null) {
            if (serverName.contains("s1.dpfile.com")) {
                return DI_LIAN;
            }
            if (serverName.contains("i1.dpfile.com") || serverName.contains("i3.dpfile.com") || serverName.contains("t2.dpfile.com")) {
                return DI_LIAN;
            }
            if (serverName.contains("s2.dpfile.com")) {
                return WANG_SU;
            }
            if (serverName.contains("i2.dpfile.com") || serverName.contains("t1.dpfile.com") || serverName.contains("t3.dpfile.com")) {
                return WANG_SU;
            }
            if (serverName.contains("s3.dpfile.com")) {
                return TENG_XUN;
            }
        }
        return null;
    }
}

