/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

public final class CleanupHelper {
    private static Method method4getCleaner;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static boolean initCleanupMethod;
    private static Method method4clean;

    private CleanupHelper() {
    }

    protected static Method initMethod(MappedByteBuffer mbyteBuffer) {
        try {
            Method method4getCleaner = mbyteBuffer.getClass().getDeclaredMethod("cleaner", EMPTY_CLASS_ARRAY);
            if (!method4getCleaner.isAccessible()) {
                method4getCleaner.setAccessible(true);
            }
            Method method = method4getCleaner;
            return method;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            Method method = null;
            return method;
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            Method method = null;
            return method;
        }
        finally {
            initCleanupMethod = true;
        }
    }

    public static void cleanup(MappedByteBuffer m_byteBuffer) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object v;
        if (method4getCleaner == null && !initCleanupMethod) {
            method4getCleaner = CleanupHelper.initMethod(m_byteBuffer);
        }
        if (method4getCleaner != null && (v = method4getCleaner.invoke((Object)m_byteBuffer, EMPTY_OBJECT_ARRAY)) != null) {
            if (method4clean == null && !(method4clean = v.getClass().getDeclaredMethod("clean", EMPTY_CLASS_ARRAY)).isAccessible()) {
                method4clean.setAccessible(true);
            }
            method4clean.invoke(v, EMPTY_OBJECT_ARRAY);
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

