/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.AbstractEntity;
import com.diboot.core.entity.Dictionary;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.mapper.DictionaryMapper;
import com.diboot.core.service.DictionaryService;
import com.diboot.core.service.DictionaryServiceExtProvider;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.IGetter;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.DictionaryVO;
import com.diboot.core.vo.LabelValue;
import com.diboot.core.vo.Status;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service(value="dictionaryService")
public class DictionaryServiceExtImpl
extends BaseServiceImpl<DictionaryMapper, Dictionary>
implements DictionaryService,
DictionaryServiceExtProvider {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceExtImpl.class);

    public List<LabelValue> getLabelValueList(String type) {
        Wrapper queryDictionary = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{Dictionary::getItemName, Dictionary::getItemValue, Dictionary::getExtension}).eq(Dictionary::getType, (Object)type)).isNotNull(Dictionary::getParentId)).ne(Dictionary::getParentId, (Object)"0")).orderByAsc(Arrays.asList(Dictionary::getSortId, AbstractEntity::getId));
        return this.getEntityList(queryDictionary).stream().map(e -> new LabelValue(e.getItemName(), (Object)e.getItemValue()).setExt((Object)e.getExtension())).collect(Collectors.toList());
    }

    public Map<String, LabelValue> getLabel2ItemMap(String type) {
        Wrapper queryDictionary = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{Dictionary::getItemName, Dictionary::getItemValue, Dictionary::getExtension}).eq(Dictionary::getType, (Object)type)).isNotNull(Dictionary::getParentId)).ne(Dictionary::getParentId, (Object)"0");
        return this.getEntityList(queryDictionary).stream().collect(Collectors.toMap(dict -> dict.getItemName(), dict -> new LabelValue(dict.getItemName(), (Object)dict.getItemValue()).setExt((Object)dict.getExtension())));
    }

    public Map<String, LabelValue> getValue2ItemMap(String type) {
        Wrapper queryDictionary = (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{Dictionary::getItemName, Dictionary::getItemValue, Dictionary::getExtension}).eq(Dictionary::getType, (Object)type)).isNotNull(Dictionary::getParentId)).ne(Dictionary::getParentId, (Object)"0");
        return this.getEntityList(queryDictionary).stream().collect(Collectors.toMap(dict -> dict.getItemValue(), dict -> new LabelValue(dict.getItemName(), (Object)dict.getItemValue()).setExt((Object)dict.getExtension())));
    }

    public boolean existsDictType(String dictType) {
        return this.exists(Dictionary::getType, dictType);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean createDictAndChildren(DictionaryVO dictVO) {
        DictionaryVO dictionary = dictVO;
        if (dictionary.getIsEditable() == null) {
            dictionary.setIsEditable(Boolean.valueOf(true));
        }
        if (dictionary.getIsDeletable() == null) {
            dictionary.setIsDeletable(Boolean.valueOf(true));
        }
        if (!super.createEntity((Object)dictionary)) {
            log.warn("\u65b0\u5efa\u6570\u636e\u5b57\u5178\u5b9a\u4e49\u5931\u8d25\uff0ctype=" + dictVO.getType());
            return false;
        }
        List children = dictVO.getChildren();
        this.buildSortId(children);
        if (V.notEmpty((Collection)children)) {
            HashSet<String> itemValues = new HashSet<String>();
            for (Dictionary dict : children) {
                if (itemValues.contains(dict.getItemValue())) {
                    throw new BusinessException(Status.FAIL_OPERATION, "\u5b57\u5178\u9009\u9879: {} \u91cd\u590d", new Object[]{dict.getItemValue()});
                }
                itemValues.add(dict.getItemValue());
                dict.setParentId((String)((Object)dictionary.getId())).setType(dictionary.getType()).setIsDeletable(dictionary.getIsDeletable()).setIsEditable(dictionary.getIsEditable());
            }
            boolean success = super.createEntities((Collection)children);
            if (!success) {
                String errorMsg = "\u65b0\u5efa\u6570\u636e\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0ctype=" + dictVO.getType();
                log.warn(errorMsg);
                throw new BusinessException(Status.FAIL_OPERATION, errorMsg, new Object[0]);
            }
        }
        return true;
    }

    public List<Dictionary> getDictDefinitionList() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().isNull(Dictionary::getParentId)).or()).eq(Dictionary::getParentId, (Object)"0")).orderByDesc(AbstractEntity::getId);
        return this.getEntityList((Wrapper)queryWrapper);
    }

    public List<DictionaryVO> getDictDefinitionVOList() {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().isNull(Dictionary::getParentId)).or()).eq(Dictionary::getParentId, (Object)"0")).orderByDesc(AbstractEntity::getId);
        return this.getViewObjectList((Wrapper)queryWrapper, null, DictionaryVO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateDictAndChildren(DictionaryVO dictVO) {
        Dictionary oldDictionary = (Dictionary)super.getEntity(dictVO.getId());
        DictionaryVO dictionary = dictVO;
        dictionary.setIsDeletable(oldDictionary.getIsDeletable()).setIsEditable(oldDictionary.getIsEditable());
        if (!super.updateEntity((Object)dictionary)) {
            log.warn("\u66f4\u65b0\u6570\u636e\u5b57\u5178\u5b9a\u4e49\u5931\u8d25\uff0ctype=" + dictVO.getType());
            return false;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(Dictionary::getParentId, (Object)dictVO.getId());
        List oldDictList = super.getEntityList((Wrapper)queryWrapper);
        List newDictList = dictVO.getChildren();
        HashSet<Serializable> dictItemIds = new HashSet<Serializable>();
        this.buildSortId(newDictList);
        if (V.notEmpty((Collection)newDictList)) {
            for (Dictionary dict : newDictList) {
                dict.setType(dictVO.getType()).setParentId((String)((Object)dictVO.getId())).setIsDeletable(dictionary.getIsDeletable()).setIsEditable(dictionary.getIsEditable());
                if (V.notEmpty((String)((String)((Object)dict.getId())))) {
                    dictItemIds.add(dict.getId());
                    if (super.updateEntity((Object)dict)) continue;
                    log.warn("\u66f4\u65b0\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0citemName=" + dict.getItemName());
                    throw new BusinessException(Status.FAIL_EXCEPTION, "\u66f4\u65b0\u5b57\u5178\u5b50\u9879\u5f02\u5e38", new Object[0]);
                }
                if (super.createEntity((Object)dict)) continue;
                log.warn("\u65b0\u5efa\u5b57\u5178\u5b50\u9879\u5931\u8d25\uff0citemName=" + dict.getItemName());
                throw new BusinessException(Status.FAIL_EXCEPTION, "\u65b0\u5efa\u5b57\u5178\u5b50\u9879\u5f02\u5e38", new Object[0]);
            }
        }
        if (V.notEmpty((Collection)oldDictList)) {
            for (Dictionary dict : oldDictList) {
                if (dictItemIds.contains(dict.getId()) || super.deleteEntity(dict.getId())) continue;
                log.warn("\u5220\u9664\u5b50\u6570\u636e\u5b57\u5178\u5931\u8d25\uff0citemName=" + dict.getItemName());
                throw new BusinessException(Status.FAIL_EXCEPTION, "\u5220\u9664\u5b57\u5178\u5b50\u9879\u5f02\u5e38", new Object[0]);
            }
        }
        return true;
    }

    public boolean deleteDictAndChildren(Serializable id) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(AbstractEntity::getId, (Object)id)).or()).eq(Dictionary::getParentId, (Object)id);
        return this.deleteEntities((Wrapper)queryWrapper);
    }

    public void bindItemLabel(List voList, String setFieldName, String getFieldName, String type) {
        if (V.isEmpty((Collection)voList)) {
            return;
        }
        List<LabelValue> entityList = this.getLabelValueList(type);
        Map map = BeanUtils.convertToStringKeyObjectMap(entityList, (IGetter[])new IGetter[]{LabelValue::getValue});
        Class fieldType = BeanUtils.getFieldActualType(voList.get(0).getClass(), (String)setFieldName);
        boolean isLabelValueClass = LabelValue.class.equals((Object)fieldType);
        for (Object item : voList) {
            ArrayList<Object> labelList;
            Object value = BeanUtils.getProperty(item, (String)getFieldName);
            if (V.isEmpty((Object)value)) continue;
            if (value instanceof String) {
                LabelValue matchedItem = (LabelValue)map.get((String)value);
                if (matchedItem != null) {
                    if (isLabelValueClass) {
                        BeanUtils.setProperty(item, (String)setFieldName, (Object)matchedItem);
                        continue;
                    }
                    BeanUtils.setProperty(item, (String)setFieldName, (Object)matchedItem.getLabel());
                    continue;
                }
                if (((String)value).contains(",")) {
                    ArrayList<Object> labelList2 = new ArrayList<Object>();
                    String[] stringArray = ((String)value).split(",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String key = stringArray[i];
                        LabelValue labelValue = (LabelValue)map.get(key);
                        if (labelValue == null) continue;
                        if (isLabelValueClass) {
                            labelList2.add(labelValue);
                            continue;
                        }
                        labelList2.add(labelValue.getLabel());
                    }
                    if (!V.notEmpty(labelList2)) continue;
                    if (isLabelValueClass) {
                        BeanUtils.setProperty(item, (String)setFieldName, labelList2);
                        continue;
                    }
                    BeanUtils.setProperty(item, (String)setFieldName, (Object)S.join(labelList2));
                    continue;
                }
                log.warn("\u672a\u5339\u914d\u5230\u5b57\u5178\u9009\u9879: {}\uff0c\u5b58\u50a8\u503c: {}", (Object)type, value);
                continue;
            }
            if (value instanceof Collection) {
                labelList = new ArrayList<Object>();
                for (Object key : (Collection)value) {
                    LabelValue labelValue = (LabelValue)map.get((String)key);
                    if (labelValue == null) continue;
                    if (isLabelValueClass) {
                        labelList.add(labelValue);
                        continue;
                    }
                    labelList.add(labelValue.getLabel());
                }
                BeanUtils.setProperty(item, (String)setFieldName, labelList);
                continue;
            }
            if (value.getClass().isArray()) {
                labelList = new ArrayList();
                for (Object key : (Object[])value) {
                    LabelValue labelValue = (LabelValue)map.get((String)key);
                    if (labelValue == null) continue;
                    if (isLabelValueClass) {
                        labelList.add(labelValue);
                        continue;
                    }
                    labelList.add(labelValue.getLabel());
                }
                BeanUtils.setProperty(item, (String)setFieldName, labelList);
                continue;
            }
            log.warn("\u4e0d\u652f\u6301\u7684\u5c5e\u6027\u7c7b\u578b: {}\uff0c\u5b58\u50a8\u503c: {}", (Object)value.getClass().getSimpleName(), value);
        }
    }

    private void buildSortId(List<Dictionary> dictList) {
        if (V.isEmpty(dictList)) {
            return;
        }
        for (int i = 0; i < dictList.size(); ++i) {
            Dictionary dict = dictList.get(i);
            dict.setSortId(Integer.valueOf(i));
        }
    }
}

