/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.entity.I18nConfig;
import com.diboot.core.mapper.I18nConfigMapper;
import com.diboot.core.service.I18nConfigService;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.I18nConfigVO;
import com.diboot.core.vo.Pagination;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Deprecated
@Service
@ConditionalOnProperty(prefix="diboot.core", name={"i18n"}, havingValue="true")
public class I18nConfigServiceImpl
extends BaseServiceImpl<I18nConfigMapper, I18nConfig>
implements I18nConfigService {
    private static final Logger log = LoggerFactory.getLogger(I18nConfigServiceImpl.class);

    public Collection<List<I18nConfigVO>> getI18nList(I18nConfig entity, Pagination pagination) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery().select(new SFunction[]{I18nConfig::getCode});
        queryWrapper.eq(V.notEmpty((String)entity.getType()), I18nConfig::getType, (Object)entity.getType());
        queryWrapper.like(V.notEmpty((String)entity.getCode()), I18nConfig::getCode, (Object)entity.getCode());
        queryWrapper.like(V.notEmpty((String)entity.getContent()), I18nConfig::getContent, (Object)entity.getContent());
        queryWrapper.groupBy(I18nConfig::getCode);
        List codes = this.getEntityList((Wrapper)queryWrapper, pagination).stream().map(I18nConfig::getCode).collect(Collectors.toList());
        if (V.isEmpty(codes)) {
            return Collections.emptyList();
        }
        QueryWrapper query = Wrappers.query();
        for (OrderItem order : pagination.toPage(this.entityClass).orders()) {
            query.orderBy(true, order.isAsc(), (Object)order.getColumn());
        }
        List entityList = this.getViewObjectList((Wrapper)query.lambda().in(I18nConfig::getCode, codes), null, I18nConfigVO.class);
        return entityList.stream().collect(Collectors.groupingBy(I18nConfig::getCode, LinkedHashMap::new, Collectors.toList())).values();
    }

    public void bindI18nContent(List<?> voList, String getI18nCodeField, String setI18nContentField) {
        if (V.isEmpty(voList)) {
            return;
        }
        HashSet<String> codes = new HashSet<String>();
        for (Object item : voList) {
            Object i18nCode = BeanUtils.getProperty(item, (String)getI18nCodeField);
            if (!V.notEmpty((Object)i18nCode)) continue;
            codes.add(S.valueOf((Object)i18nCode));
        }
        if (V.isEmpty(codes)) {
            return;
        }
        Locale locale = LocaleContextHolder.getLocale();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.select(new SFunction[]{I18nConfig::getLanguage, I18nConfig::getCode, I18nConfig::getContent});
        queryWrapper.in(I18nConfig::getCode, codes);
        queryWrapper.in(I18nConfig::getLanguage, new Object[]{locale.toString(), locale.getLanguage(), Locale.getDefault().toString()});
        Map<String, List<I18nConfig>> map = this.getEntityList((Wrapper)queryWrapper).stream().collect(Collectors.groupingBy(I18nConfig::getLanguage));
        List<I18nConfig> list = map.get(locale.toString());
        if (list == null && (list = map.get(locale.toString())) == null && (list = map.get(Locale.getDefault().toString())) == null) {
            return;
        }
        Map<String, String> i18nMap = list.stream().collect(Collectors.toMap(I18nConfig::getCode, I18nConfig::getContent));
        for (Object item : voList) {
            String content;
            Object i18nCode = BeanUtils.getProperty(item, (String)getI18nCodeField);
            if (!V.notEmpty((Object)i18nCode) || !V.notEmpty((String)(content = i18nMap.get(S.valueOf((Object)i18nCode))))) continue;
            BeanUtils.setProperty(item, (String)setI18nContentField, (Object)content);
        }
    }
}

