/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.core.starter;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.diboot.core.converter.Date2LocalDateConverter;
import com.diboot.core.converter.Date2LocalDateTimeConverter;
import com.diboot.core.converter.LocalDate2DateConverter;
import com.diboot.core.converter.LocalDateTime2DateConverter;
import com.diboot.core.converter.LocalDateTime2StringConverter;
import com.diboot.core.converter.SqlDate2LocalDateConverter;
import com.diboot.core.converter.SqlDate2LocalDateTimeConverter;
import com.diboot.core.converter.String2BooleanConverter;
import com.diboot.core.converter.String2DateConverter;
import com.diboot.core.converter.String2ListConverter;
import com.diboot.core.converter.String2LocalDateConverter;
import com.diboot.core.converter.String2LocalDateTimeConverter;
import com.diboot.core.converter.String2MapConverter;
import com.diboot.core.converter.Timestamp2LocalDateTimeConverter;
import com.diboot.core.data.protect.DataEncryptHandler;
import com.diboot.core.data.protect.DataMaskHandler;
import com.diboot.core.data.protect.DefaultDataEncryptHandler;
import com.diboot.core.data.protect.DefaultDataMaskHandler;
import com.diboot.core.deserializer.LocalDateTimeDeserializer;
import com.diboot.core.starter.CoreProperties;
import com.diboot.core.starter.GlobalProperties;
import com.diboot.core.util.D;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.LocalDateTypeHandler;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableAsync
@Configuration
@EnableConfigurationProperties(value={CoreProperties.class, GlobalProperties.class})
@ComponentScan(basePackages={"com.diboot.core"})
@MapperScan(basePackages={"com.diboot.core.mapper"})
public class CoreAutoConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(CoreAutoConfig.class);
    @Value(value="${spring.jackson.date-format:yyyy-MM-dd HH:mm:ss}")
    private String defaultDatePattern;
    @Value(value="${spring.jackson.time-zone:GMT+8}")
    private String defaultTimeZone;
    @Value(value="${spring.jackson.default-property-inclusion:NON_NULL}")
    private JsonInclude.Include defaultPropertyInclusion;

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        return builder -> {
            builder.serializerByType(Long.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
            builder.serializerByType(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            builder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(localDateTimeFormatter));
            builder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
            DateTimeFormatter localDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            builder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(localDateFormatter));
            builder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(localDateFormatter));
            DateTimeFormatter localTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            builder.serializerByType(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(localTimeFormatter));
            builder.deserializerByType(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(localTimeFormatter));
            builder.serializationInclusion(this.defaultPropertyInclusion);
            builder.failOnUnknownProperties(false);
            builder.timeZone(TimeZone.getTimeZone(this.defaultTimeZone));
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.defaultDatePattern){

                @Override
                public java.util.Date parse(String dateStr) {
                    return D.fuzzyConvert((String)dateStr);
                }
            };
            builder.dateFormat((DateFormat)dateFormat);
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder() {
        Jackson2ObjectMapperBuilder objectMapperBuilder = new Jackson2ObjectMapperBuilder();
        this.jsonCustomizer().customize(objectMapperBuilder);
        log.info("\u542f\u7528diboot\u9ed8\u8ba4\u7684Jackson\u81ea\u5b9a\u4e49\u914d\u7f6e");
        return objectMapperBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingJackson2HttpMessageConverter jacksonMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this.jackson2ObjectMapperBuilder().build());
    }

    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataEncryptHandler.class})
    public DataEncryptHandler dataEncryptHandler() {
        log.debug("\u521d\u59cb\u5316\u9ed8\u8ba4\u7684DataEncryptHandler");
        return new DefaultDataEncryptHandler();
    }

    @Bean
    @ConditionalOnMissingBean(value={DataMaskHandler.class})
    public DataMaskHandler dataMaskHandler() {
        log.debug("\u521d\u59cb\u5316\u9ed8\u8ba4\u7684DataMaskHandler");
        return new DefaultDataMaskHandler();
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new Date2LocalDateConverter());
        registry.addConverter((Converter)new Date2LocalDateTimeConverter());
        registry.addConverter((Converter)new LocalDate2DateConverter());
        registry.addConverter((Converter)new LocalDateTime2DateConverter());
        registry.addConverter((Converter)new LocalDateTime2StringConverter());
        registry.addConverter((Converter)new SqlDate2LocalDateConverter());
        registry.addConverter((Converter)new SqlDate2LocalDateTimeConverter());
        registry.addConverter((Converter)new String2DateConverter());
        registry.addConverter((Converter)new String2LocalDateConverter());
        registry.addConverter((Converter)new String2LocalDateTimeConverter());
        registry.addConverter((Converter)new String2BooleanConverter());
        registry.addConverter((Converter)new String2ListConverter());
        registry.addConverter((Converter)new String2MapConverter());
        registry.addConverter((Converter)new Timestamp2LocalDateTimeConverter());
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationCustomizer typeHandlerRegistry() {
        return configuration -> configuration.getTypeHandlerRegistry().register(Date.class, JdbcType.DATE, LocalDateTypeHandler.class);
    }
}

