/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.controller;

import com.diboot.core.controller.BaseController;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Status;
import com.diboot.file.entity.FileRecord;
import com.diboot.file.excel.BaseExcelModel;
import com.diboot.file.excel.listener.ReadExcelListener;
import com.diboot.file.service.FileRecordService;
import com.diboot.file.service.FileStorageService;
import com.diboot.file.util.ExcelHelper;
import com.diboot.file.util.FileHelper;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public abstract class BaseExcelFileController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseExcelFileController.class);
    @Autowired
    protected FileRecordService fileRecordService;
    @Autowired
    protected FileStorageService fileStorageService;

    protected abstract ReadExcelListener<?> getExcelDataListener();

    public JsonResult<Map<String, Object>> excelPreview(MultipartFile file, Map<String, Object> params) throws Exception {
        this.checkIsExcel(file);
        FileRecord fileRecord = this.fileStorageService.save(file);
        fileRecord.setDescription(params.compute("description", (k, v) -> S.defaultIfEmpty((CharSequence)S.valueOf((Object)v), (CharSequence)"Excel\u9884\u89c8\u6570\u636e")).toString());
        ReadExcelListener<?> listener = this.getExcelDataListener();
        listener.setImportFileUuid(fileRecord.getId());
        listener.setRequestParams(params);
        listener.setPreview(true);
        this.readExcelFile(file.getInputStream(), listener);
        this.fileRecordService.createEntity((Object)fileRecord);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        dataMap.put("id", fileRecord.getId());
        dataMap.put("tableHeads", listener.getTableHeads());
        dataMap.put("dataList", listener.getPreviewDataList());
        dataMap.put("totalCount", listener.getTotalCount());
        if (listener.getErrorCount() > 0) {
            dataMap.put("errorCount", listener.getErrorCount());
            dataMap.put("errorMsgs", listener.getErrorMsgs());
        }
        return JsonResult.OK(dataMap);
    }

    public JsonResult<Map<String, Object>> excelPreviewSave(Map<String, Object> params) throws Exception {
        String uuid = params.get("id").toString();
        if (V.isEmpty((String)uuid)) {
            throw new BusinessException("exception.business.excel.unknownPreviewSave", new Object[0]);
        }
        FileRecord uploadFile = (FileRecord)((Object)this.fileRecordService.getEntity((Serializable)((Object)uuid)));
        uploadFile.setDescription(params.compute("description", (k, v) -> S.defaultIfEmpty((CharSequence)S.valueOf((Object)v), (CharSequence)"Excel\u9884\u89c8\u540e\u5bfc\u5165\u6570\u636e")).toString());
        return this.importData(uploadFile, this.fileStorageService.getFile(uploadFile.getStoragePath()), params);
    }

    public JsonResult<Map<String, Object>> uploadExcelFile(MultipartFile file, Map<String, Object> params) throws Exception {
        this.checkIsExcel(file);
        FileRecord fileStorage = this.fileStorageService.save(file);
        fileStorage.setDescription(params.compute("description", (k, v) -> S.defaultIfEmpty((CharSequence)S.valueOf((Object)v), (CharSequence)"Excel\u5bfc\u5165\u6570\u636e")).toString());
        this.fileRecordService.createEntity((Object)fileStorage);
        return this.importData(fileStorage, file.getInputStream(), params);
    }

    private JsonResult<Map<String, Object>> importData(FileRecord uploadFile, InputStream inputStream, Map<String, Object> params) throws Exception {
        FileRecord errorFile;
        final ReadExcelListener<?> listener = this.getExcelDataListener();
        listener.setImportFileUuid(uploadFile.getId());
        listener.setRequestParams(params);
        this.readExcelFile(inputStream, listener);
        this.fileRecordService.updateEntity((Object)uploadFile);
        String errorDataFilePath = listener.getErrorDataFilePath();
        if (errorDataFilePath == null) {
            return JsonResult.OK();
        }
        String errorDataFileName = uploadFile.getFileName().replaceFirst("\\.\\w+$", "_\u9519\u8bef\u6570\u636e.xlsx");
        File errDataFile = new File(errorDataFilePath);
        long fileSize = errDataFile.length();
        if (FileHelper.isLocalStorage()) {
            String errorDataFileUidName = S.substringAfterLast((String)errorDataFilePath, (String)"/");
            String errorDataFileUid = S.substringBefore((String)errorDataFileUidName, (String)".");
            errorFile = new FileRecord(errorDataFileUid).setFileType("xlsx").setFileName(errorDataFileName).setFileSize(fileSize).setStoragePath(errorDataFilePath).setAccessUrl(this.fileStorageService.buildAccessUrl(errorDataFileUidName, ""));
        } else {
            errorFile = this.fileStorageService.save(Files.newInputStream(errDataFile.toPath(), new OpenOption[0]), errorDataFileName, fileSize);
            FileHelper.deleteFile(errorDataFilePath);
        }
        errorFile.setDescription(uploadFile.getFileName() + " - \u9519\u8bef\u6570\u636e");
        this.fileRecordService.createEntity((Object)errorFile);
        return JsonResult.OK((Object)new HashMap<String, Object>(){
            {
                this.put("totalCount", listener.getTotalCount());
                this.put("errorUrl", errorFile.getAccessUrl());
                this.put("errorCount", listener.getErrorCount());
                this.put("errorMsgs", listener.getErrorMsgs());
            }
        });
    }

    protected <T extends BaseExcelModel> void readExcelFile(InputStream inputStream, ReadExcelListener<T> listener) throws Exception {
        try {
            ExcelHelper.read(inputStream, listener, listener.getExcelModelClass());
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790excel\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            if (e instanceof BusinessException) {
                throw e;
            }
            if (V.notEmpty((String)e.getMessage())) {
                throw new Exception(e.getMessage());
            }
            throw e;
        }
    }

    protected void checkIsExcel(MultipartFile file) {
        if (V.isEmpty((Object)file)) {
            throw new BusinessException(Status.FAIL_INVALID_PARAM, "exception.business.excel.noFile", new Object[0]);
        }
        String fileName = file.getOriginalFilename();
        if (V.isEmpty((String)fileName) || !FileHelper.isExcel(fileName)) {
            log.debug("\u975eExcel\u7c7b\u578b: {}", (Object)fileName);
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.excel.formatError", new Object[0]);
        }
        if (file.isEmpty()) {
            log.debug("\u7a7a\u6587\u4ef6\uff1a{}", (Object)fileName);
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.excel.emptyContent", new Object[0]);
        }
    }
}

