/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.cache;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.BaseService;
import com.diboot.core.service.DictionaryServiceExtProvider;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.file.excel.annotation.ExcelBindDict;
import com.diboot.file.excel.annotation.ExcelBindField;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBindAnnoHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelBindAnnoHandler.class);
    private static final Map<String, Map<String, Annotation>> MODEL_BINDANNO_CACHE = new ConcurrentHashMap<String, Map<String, Annotation>>();

    public static Map<String, Annotation> getField2BindAnnoMap(Class modelClass) {
        String modelClassName = modelClass.getName();
        Map<String, Annotation> field2AnnoMap = MODEL_BINDANNO_CACHE.get(modelClassName);
        if (field2AnnoMap == null) {
            List fieldList = BeanUtils.extractAllFields((Class)modelClass, (boolean)true);
            for (Field field : fieldList) {
                ExcelBindField bindField;
                ExcelBindDict excelBindDict = field.getAnnotation(ExcelBindDict.class);
                BindDict bindDict = field.getAnnotation(BindDict.class);
                if (excelBindDict != null) {
                    if (field2AnnoMap == null) {
                        field2AnnoMap = new LinkedHashMap<String, Annotation>(8);
                    }
                    field2AnnoMap.put(field.getName(), excelBindDict);
                } else if (bindDict != null) {
                    if (field2AnnoMap == null) {
                        field2AnnoMap = new LinkedHashMap(8);
                    }
                    field2AnnoMap.put(field.getName(), (Annotation)bindDict);
                }
                if ((bindField = field.getAnnotation(ExcelBindField.class)) == null) continue;
                if (field2AnnoMap == null) {
                    field2AnnoMap = new LinkedHashMap(8);
                }
                field2AnnoMap.put(field.getName(), bindField);
            }
            if (field2AnnoMap == null) {
                field2AnnoMap = Collections.emptyMap();
            }
            MODEL_BINDANNO_CACHE.put(modelClassName, field2AnnoMap);
        }
        return field2AnnoMap;
    }

    public static Map<String, List> convertToNameValueMap(Annotation annotation, List<String> nameList) {
        if (annotation instanceof ExcelBindDict || annotation instanceof BindDict) {
            String dictType = annotation instanceof ExcelBindDict ? ((ExcelBindDict)annotation).type() : ((BindDict)annotation).type();
            DictionaryServiceExtProvider bindDictService = (DictionaryServiceExtProvider)ContextHolder.getBean(DictionaryServiceExtProvider.class);
            if (bindDictService == null) {
                throw new InvalidUsageException("exception.invalidUsage.excelBindAnnoHandler.convertToNameValueMap.message", new Object[0]);
            }
            List list = bindDictService.getLabelValueList(dictType);
            return ExcelBindAnnoHandler.convertLabelValueListToMap(list);
        }
        if (annotation instanceof ExcelBindField) {
            ExcelBindField bindField = (ExcelBindField)annotation;
            return ExcelBindAnnoHandler.executeBindField(bindField, nameList);
        }
        return Collections.emptyMap();
    }

    private static Map<String, List> executeBindField(ExcelBindField bindField, List<String> nameList) {
        if (V.isEmpty(nameList)) {
            return Collections.emptyMap();
        }
        nameList = nameList.stream().flatMap(e -> Stream.concat(Stream.of(S.split((String)e)), Stream.of(e))).filter(V::notEmpty).distinct().toList();
        BaseService service = ContextHolder.getBaseServiceByEntity((Class)bindField.entity());
        String nameColumn = S.toSnakeCase((String)bindField.field());
        String idColumn = ContextHolder.getIdColumnName((Class)bindField.entity());
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().select((Object[])new String[]{nameColumn, idColumn})).in((Object)nameColumn, nameList);
        List list = service.getLabelValueList((Wrapper)queryWrapper);
        return ExcelBindAnnoHandler.convertLabelValueListToMap(list);
    }

    private static Map<String, List> convertLabelValueListToMap(List<LabelValue> list) {
        HashMap<String, List> resultMap = new HashMap<String, List>(list.size());
        if (V.notEmpty(list)) {
            for (LabelValue labelValue : list) {
                ArrayList<Object> mapVal = (ArrayList<Object>)resultMap.get(labelValue.getLabel());
                if (mapVal == null) {
                    mapVal = new ArrayList<Object>();
                    resultMap.put(labelValue.getLabel(), mapVal);
                }
                if (mapVal.contains(labelValue.getValue())) continue;
                mapVal.add(labelValue.getValue());
            }
        }
        return resultMap;
    }
}

