/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.metadata.property.ExcelReadHeadProperty;
import com.diboot.file.excel.TableHead;
import com.diboot.file.util.ExcelHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicHeadExcelListener
extends AnalysisEventListener<Map<Integer, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicHeadExcelListener.class);
    Map<Integer, String> headMap = new HashMap<Integer, String>();
    protected boolean preview = false;
    private Map<String, Object> requestParams;
    private final HashMap<Integer, String> fieldNameMap = new HashMap();
    private final TreeMap<Integer, List<String>> headNameMap = new TreeMap();
    private List<Map<Integer, String>> previewDataList;
    private Integer totalCount = 0;
    private List<String> errorMsgs;
    protected Integer errorCount = 0;
    private List<Map<Integer, String>> dataList = new ArrayList<Map<Integer, String>>();

    public void invoke(Map<Integer, String> data, AnalysisContext context) {
        this.dataList.add(data);
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        this.headMap.clear();
        this.fieldNameMap.clear();
        this.headNameMap.clear();
        ExcelReadHeadProperty excelReadHeadProperty = context.currentReadHolder().excelReadHeadProperty();
        for (Map.Entry entry : excelReadHeadProperty.getHeadMap().entrySet()) {
            Integer index = (Integer)entry.getKey();
            Head head = (Head)entry.getValue();
            String fieldName = head.getFieldName();
            List headNameList = head.getHeadNameList();
            String name = (String)headNameList.get(headNameList.size() - 1);
            this.headMap.put(index, name);
            this.fieldNameMap.put(index, index.toString());
            this.headNameMap.put(index, headNameList);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.additionalValidate(this.dataList, this.requestParams);
        this.totalCount = this.dataList.size();
        if (this.preview) {
            this.previewDataList = this.totalCount > 100 ? this.dataList.subList(0, 100) : this.dataList;
        } else {
            this.saveData(this.headMap, this.dataList, this.requestParams);
        }
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.headMap = headMap;
    }

    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    public List<TableHead> getTableHeads() {
        return ExcelHelper.buildTableHeads(this.headNameMap, this.fieldNameMap);
    }

    public List<Map<Integer, String>> getDataList() {
        return this.dataList;
    }

    protected void addErrorMsg(String errorMsg) {
        if (this.errorMsgs == null) {
            this.errorMsgs = new ArrayList<String>();
        }
        this.errorMsgs.add(errorMsg);
    }

    protected void additionalValidate(List<Map<Integer, String>> dataList, Map<String, Object> requestParams) {
    }

    protected abstract void saveData(Map<Integer, String> var1, List<Map<Integer, String>> var2, Map<String, Object> var3);

    @Generated
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    @Generated
    public void setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
    }

    @Generated
    public HashMap<Integer, String> getFieldNameMap() {
        return this.fieldNameMap;
    }

    @Generated
    public TreeMap<Integer, List<String>> getHeadNameMap() {
        return this.headNameMap;
    }

    @Generated
    public List<Map<Integer, String>> getPreviewDataList() {
        return this.previewDataList;
    }

    @Generated
    public void setPreviewDataList(List<Map<Integer, String>> previewDataList) {
        this.previewDataList = previewDataList;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    @Generated
    public void setErrorMsgs(List<String> errorMsgs) {
        this.errorMsgs = errorMsgs;
    }

    @Generated
    public Integer getErrorCount() {
        return this.errorCount;
    }

    @Generated
    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }
}

