/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.util.ListUtils;
import com.diboot.core.config.BaseConfig;
import com.diboot.file.excel.BaseExcelModel;
import com.diboot.file.excel.listener.ReadExcelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public abstract class PageReadExcelListener<T extends BaseExcelModel>
extends ReadExcelListener<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageReadExcelListener.class);
    private static final Integer BATCH_COUNT = BaseConfig.getBatchSize();
    private final List<T> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)BATCH_COUNT);
    protected CompletableFuture<Boolean> completableFuture;

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (this.completableFuture != null) {
            this.completableFuture.join();
        }
        if (CollectionUtils.isNotEmpty(this.cachedDataList)) {
            this.handle(this.cachedDataList);
        }
        super.finish();
    }

    @Override
    protected void cachedData(T data) {
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= BATCH_COUNT) {
            if (this.completableFuture != null) {
                this.completableFuture.join();
            }
            this.completableFuture = this.asyncHandle(new ArrayList<T>(this.cachedDataList));
            this.cachedDataList.clear();
        }
    }

    @Async
    public CompletableFuture<Boolean> asyncHandle(List<T> dataList) {
        super.handle(dataList);
        return CompletableFuture.completedFuture(true);
    }

    @Generated
    public List<T> getCachedDataList() {
        return this.cachedDataList;
    }
}

