/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.listener;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.listener.ModelBuildEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.property.ExcelReadHeadProperty;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.diboot.core.binding.annotation.BindDict;
import com.diboot.core.config.BaseConfig;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.BeanUtils;
import com.diboot.core.util.JSON;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.file.excel.BaseExcelModel;
import com.diboot.file.excel.TableHead;
import com.diboot.file.excel.annotation.DuplicateStrategy;
import com.diboot.file.excel.annotation.EmptyStrategy;
import com.diboot.file.excel.annotation.ExcelBindDict;
import com.diboot.file.excel.annotation.ExcelBindField;
import com.diboot.file.excel.cache.ExcelBindAnnoHandler;
import com.diboot.file.excel.write.CommentWriteHandler;
import com.diboot.file.util.ExcelHelper;
import com.diboot.file.util.FileHelper;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadExcelListener<T extends BaseExcelModel>
implements ReadListener<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReadExcelListener.class);
    @Deprecated
    protected Map<Integer, String> headMap = new HashMap<Integer, String>();
    private final Map<String, String> fieldHeadMap = new HashMap<String, String>();
    private final HashMap<Integer, String> fieldNameMap = new HashMap();
    private final TreeMap<Integer, List<String>> headNameMap = new TreeMap();
    private Map<String, Object> requestParams;
    protected boolean preview = false;
    protected String importFileUuid;
    private List<T> previewDataList;
    private List<String> exceptionMsgs = null;
    private List<String> errorMsgs;
    private Integer totalCount = 0;
    protected Integer errorCount = 0;
    private String errorDataFilePath;
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private CommentWriteHandler commentWriteHandler;

    public Integer getProperCount() {
        return this.totalCount - this.errorCount;
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        this.headMap.clear();
        this.fieldHeadMap.clear();
        this.fieldNameMap.clear();
        this.headNameMap.clear();
        ExcelReadHeadProperty excelReadHeadProperty = context.currentReadHolder().excelReadHeadProperty();
        for (Map.Entry entry : excelReadHeadProperty.getHeadMap().entrySet()) {
            Integer index = (Integer)entry.getKey();
            Head head = (Head)entry.getValue();
            String fieldName = head.getFieldName();
            List headNameList = head.getHeadNameList();
            String name = (String)headNameList.get(headNameList.size() - 1);
            this.headMap.put(index, name);
            this.fieldHeadMap.put(fieldName, name);
            this.fieldNameMap.put(index, fieldName);
            this.headNameMap.put(index, headNameList);
        }
    }

    public void invoke(T data, AnalysisContext context) {
        ((BaseExcelModel)data).setRowIndex(context.readRowHolder().getRowIndex());
        Set constraintViolations = V.validateBean(data, (Class[])new Class[0]);
        if (V.notEmpty((Collection)constraintViolations)) {
            for (ConstraintViolation violation : constraintViolations) {
                ((BaseExcelModel)data).addComment(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
        this.cachedData(data);
    }

    protected void finish() {
        if (this.excelWriter != null) {
            this.excelWriter.finish();
        }
        if (V.notEmpty(this.exceptionMsgs)) {
            throw new BusinessException(Status.FAIL_VALIDATION, S.join(this.exceptionMsgs, (String)"; "), new Object[0]);
        }
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            HashMap<String, String> errorMsgMap;
            HashMap<String, String> errorDataMap;
            block8: {
                ExcelDataConvertException dataConvertException = (ExcelDataConvertException)((Object)exception);
                HashMap cellMap = new HashMap(context.readRowHolder().getCellMap());
                errorDataMap = new HashMap<String, String>();
                errorMsgMap = new HashMap<String, String>();
                Consumer<ExcelDataConvertException> addErrorData = e -> {
                    Integer columnIndex = e.getColumnIndex();
                    String key = this.fieldNameMap.get(columnIndex);
                    errorDataMap.put(key, ((ReadCellData)cellMap.remove(columnIndex)).getStringValue());
                    errorMsgMap.put(key, "\u6570\u636e\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c\u975e\u671f\u671b\u7684\u6570\u636e\u7c7b\u578b[" + e.getExcelContentProperty().getField().getType().getSimpleName() + "]");
                };
                addErrorData.accept(dataConvertException);
                ReadListener readListener = (ReadListener)context.readWorkbookHolder().getReadListenerList().get(0);
                if (readListener instanceof ModelBuildEventListener) {
                    while (true) {
                        try {
                            ((ModelBuildEventListener)readListener).invoke(cellMap, context);
                            break block8;
                        }
                        catch (ExcelDataConvertException convertException) {
                            addErrorData.accept(convertException);
                            continue;
                        }
                        break;
                    }
                }
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)exception);
                StringBuilder errorMsg = new StringBuilder().append("\u7b2c ").append(context.readRowHolder().getRowIndex() + 1).append(" \u884c\uff0c");
                errorMsgMap.forEach((fieldName, msg) -> errorMsg.append(this.fieldHeadMap.get(fieldName)).append("\uff1a").append((String)msg));
                this.addExceptionMsg(errorMsg.toString());
                return;
            }
            BaseExcelModel currentRowAnalysisResult = (BaseExcelModel)context.readRowHolder().getCurrentRowAnalysisResult();
            currentRowAnalysisResult.setRowIndex(context.readRowHolder().getRowIndex());
            errorDataMap.forEach(currentRowAnalysisResult::addInvalidValue);
            errorMsgMap.forEach(currentRowAnalysisResult::addComment);
            Set constraintViolations = V.validateBean((Object)currentRowAnalysisResult, (Class[])new Class[0]);
            if (V.notEmpty((Collection)constraintViolations)) {
                for (ConstraintViolation violation : constraintViolations) {
                    String propertyName = violation.getPropertyPath().toString();
                    if (errorDataMap.containsKey(propertyName)) continue;
                    currentRowAnalysisResult.addComment(propertyName, violation.getMessage());
                }
            }
            this.cachedData(currentRowAnalysisResult);
        } else {
            log.error("\u51fa\u73b0\u672a\u9884\u77e5\u7684\u5f02\u5e38\uff1a", (Throwable)exception);
            this.addExceptionMsg("\u7b2c " + (context.readRowHolder().getRowIndex() + 1) + " \u884c\uff0c\u89e3\u6790\u5f02\u5e38: " + exception.getMessage());
        }
    }

    protected abstract void cachedData(T var1);

    protected void addExceptionMsg(String exceptionMsg) {
        if (this.exceptionMsgs == null) {
            this.exceptionMsgs = new ArrayList<String>();
        }
        this.exceptionMsgs.add(exceptionMsg);
    }

    protected void handle(List<T> dataList) {
        if (this.preview && this.previewDataList == null) {
            int pageSize = BaseConfig.getPageSize();
            this.previewDataList = dataList.size() > pageSize ? dataList.subList(0, pageSize) : dataList;
        }
        this.totalCount = this.totalCount + dataList.size();
        this.validateOrConvertDictAndRefField(dataList, true);
        this.additionalValidate(dataList, this.requestParams);
        if (V.notEmpty(this.exceptionMsgs)) {
            throw new BusinessException(Status.FAIL_VALIDATION, S.join(this.exceptionMsgs, (String)"; "), new Object[0]);
        }
        dataList.stream().collect(Collectors.groupingBy(this::isProper)).forEach((proper, list) -> {
            if (proper.booleanValue()) {
                if (!this.preview) {
                    this.validateOrConvertDictAndRefField((List<T>)list, false);
                    this.saveData((List<T>)list, this.requestParams);
                }
            } else {
                this.errorData((List<T>)list);
            }
        });
    }

    protected boolean isProper(T data) {
        return V.isEmpty(((BaseExcelModel)data).getComment());
    }

    protected void errorData(List<T> dataList) {
        this.errorCount = this.errorCount + dataList.size();
        if (this.errorMsgs == null || this.errorMsgs.size() < BaseConfig.getPageSize()) {
            if (this.errorMsgs == null) {
                this.errorMsgs = new ArrayList<String>();
            }
            StringBuilder builder = new StringBuilder();
            dataList.stream().limit(BaseConfig.getPageSize() - this.errorMsgs.size()).map(data -> {
                builder.setLength(0);
                builder.append("\u7b2c ").append(data.getRowIndex() + 1).append(" \u884c\uff0c");
                data.getComment().forEach((k, v) -> builder.append(this.fieldHeadMap.get(k)).append("\uff1a").append((String)S.getIfEmpty((CharSequence)data.getField2InvalidValueMap().get(k), () -> S.defaultValueOf((Object)BeanUtils.getProperty((Object)data, (String)k)))).append(" ").append(S.join((Iterable)v)).append("\uff1b"));
                return builder.toString();
            }).forEach(this.errorMsgs::add);
        }
        if (this.preview) {
            return;
        }
        if (this.excelWriter == null) {
            this.errorDataFilePath = FileHelper.isLocalStorage() ? FileHelper.getFullPath(S.newUuid() + ".xlsx") : FileHelper.getSystemTempDir() + BaseConfig.getProperty((String)"spring.application.name", (String)"diboot") + "/" + S.newUuid() + ".xlsx";
            FileHelper.makeDirectory(this.errorDataFilePath);
            this.excelWriter = EasyExcel.write((String)this.errorDataFilePath).build();
            ExcelHelper.buildWriteSheet("Sheet1", this.getExcelModelClass(), null, (commentWriteHandler, writeSheet) -> {
                this.commentWriteHandler = commentWriteHandler;
                this.writeSheet = writeSheet;
            }, new WriteHandler[0]);
        }
        this.commentWriteHandler.setDataList(dataList);
        this.excelWriter.write(dataList, this.writeSheet);
    }

    protected void validateOrConvertDictAndRefField(List<T> dataList, boolean preview) {
        Class<T> tClass = this.getExcelModelClass();
        Map<String, Annotation> fieldName2BindAnnoMap = ExcelBindAnnoHandler.getField2BindAnnoMap(tClass);
        if (fieldName2BindAnnoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Annotation> entry : fieldName2BindAnnoMap.entrySet()) {
            List nameList = entry.getValue() instanceof ExcelBindField ? BeanUtils.collectToList(dataList, (String)entry.getKey()) : null;
            Map<String, List> map = ExcelBindAnnoHandler.convertToNameValueMap(entry.getValue(), nameList);
            Field field = BeanUtils.extractField(tClass, (String)entry.getKey());
            boolean valueNotNull = field.getAnnotation(NotNull.class) != null;
            for (BaseExcelModel data : dataList) {
                String label = BeanUtils.getStringProperty((Object)data, (String)entry.getKey());
                if (S.isEmpty((CharSequence)label)) continue;
                LinkedList<String> valList = map.get(label);
                if (entry.getValue() instanceof ExcelBindField) {
                    ExcelBindField excelBindField = (ExcelBindField)entry.getValue();
                    String setFieldName = (String)S.defaultIfEmpty((CharSequence)excelBindField.setIdField(), (CharSequence)entry.getKey());
                    if (V.isEmpty((Collection)valList)) {
                        if (label.contains(",")) {
                            valList = new LinkedList();
                            ArrayList<String> errDictArr = new ArrayList<String>();
                            for (String item : label.split(",")) {
                                List list = map.get(item);
                                if (list == null) {
                                    errDictArr.add(item);
                                    continue;
                                }
                                valList.addAll(list);
                            }
                            if (!errDictArr.isEmpty()) {
                                data.addComment(entry.getKey(), JSON.stringify(errDictArr).replaceAll("[\\[\\]]", "") + "\u5173\u8054\u503c\u4e0d\u5b58\u5728");
                                continue;
                            }
                        }
                        if (V.notEmpty(valList)) {
                            Field setField = BeanUtils.extractField(tClass, (String)setFieldName);
                            if (String.class.equals(setField.getType())) {
                                if (preview) continue;
                                BeanUtils.setProperty((Object)data, (String)setFieldName, (Object)S.join(valList));
                                continue;
                            }
                            if (List.class.equals(setField.getType())) {
                                if (preview) continue;
                                BeanUtils.setProperty((Object)data, (String)setFieldName, valList);
                                continue;
                            }
                            if (setField.getType().isArray()) {
                                if (preview) continue;
                                BeanUtils.setProperty((Object)data, (String)setFieldName, (Object)valList.toArray());
                                continue;
                            }
                            log.warn("\u5b57\u6bb5 {} \u7c7b\u578b\u65e0\u6cd5\u5339\u914d\uff0c\u4ec5\u652f\u6301 String\u3001List\u3001Array \u7c7b\u578b", (Object)setFieldName);
                            continue;
                        }
                        if (excelBindField.empty().equals((Object)EmptyStrategy.SET_0)) {
                            if (preview) continue;
                            BeanUtils.setProperty((Object)data, (String)setFieldName, (Object)0);
                            continue;
                        }
                        if (excelBindField.empty().equals((Object)EmptyStrategy.WARN)) {
                            data.addComment(entry.getKey(), "\u5173\u8054\u503c\u4e0d\u5b58\u5728");
                            continue;
                        }
                        if (!excelBindField.empty().equals((Object)EmptyStrategy.IGNORE) || !valueNotNull) continue;
                        log.warn("\u975e\u7a7a\u5b57\u6bb5 {} \u4e0d\u5e94\u8bbe\u7f6e EmptyStrategy.IGNORE.", (Object)entry.getKey());
                        continue;
                    }
                    if (valList.size() == 1) {
                        if (preview) continue;
                        BeanUtils.setProperty((Object)data, (String)setFieldName, valList.get(0));
                        continue;
                    }
                    if (excelBindField.duplicate().equals((Object)DuplicateStrategy.WARN)) {
                        data.addComment(entry.getKey(), "\u5339\u914d\u5230\u591a\u4e2a\u5173\u8054\u503c");
                        continue;
                    }
                    if (!excelBindField.duplicate().equals((Object)DuplicateStrategy.FIRST) || preview) continue;
                    BeanUtils.setProperty((Object)data, (String)setFieldName, valList.get(0));
                    continue;
                }
                if (!(entry.getValue() instanceof ExcelBindDict) && !(entry.getValue() instanceof BindDict)) continue;
                if (V.isEmpty((Collection)valList)) {
                    if (label.contains(",")) {
                        valList = new LinkedList<String>();
                        ArrayList<String> errDictArr = new ArrayList<String>();
                        for (String item : label.split(",")) {
                            List list = map.get(item);
                            if (list == null) {
                                errDictArr.add(item);
                                continue;
                            }
                            valList.addAll(list);
                        }
                        if (!errDictArr.isEmpty()) {
                            data.addComment(entry.getKey(), JSON.stringify(errDictArr).replaceAll("[\\[\\]]", "") + "\u65e0\u5339\u914d\u5b57\u5178");
                            continue;
                        }
                        if (valList.size() > 0) {
                            valList.add(0, S.join(valList));
                        }
                    }
                    if (valueNotNull && V.isEmpty(valList)) {
                        data.addComment(entry.getKey(), "\u65e0\u5339\u914d\u5b57\u5178");
                        continue;
                    }
                }
                if (preview || !V.notEmpty((Collection)valList)) continue;
                BeanUtils.setProperty((Object)data, (String)entry.getKey(), valList.get(0));
            }
        }
    }

    protected abstract void additionalValidate(List<T> var1, Map<String, Object> var2);

    protected abstract void saveData(List<T> var1, Map<String, Object> var2);

    public List<TableHead> getTableHeads() {
        return ExcelHelper.buildTableHeads(this.headNameMap, this.fieldNameMap);
    }

    public Class<T> getExcelModelClass() {
        return BeanUtils.getGenericityClass((Object)this, (int)0);
    }

    @Deprecated
    @Generated
    public Map<Integer, String> getHeadMap() {
        return this.headMap;
    }

    @Generated
    public Map<String, String> getFieldHeadMap() {
        return this.fieldHeadMap;
    }

    @Generated
    public HashMap<Integer, String> getFieldNameMap() {
        return this.fieldNameMap;
    }

    @Generated
    public void setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
    }

    @Generated
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    @Generated
    public void setImportFileUuid(String importFileUuid) {
        this.importFileUuid = importFileUuid;
    }

    @Generated
    public List<T> getPreviewDataList() {
        return this.previewDataList;
    }

    @Generated
    public List<String> getExceptionMsgs() {
        return this.exceptionMsgs;
    }

    @Generated
    public List<String> getErrorMsgs() {
        return this.errorMsgs;
    }

    @Generated
    public Integer getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public Integer getErrorCount() {
        return this.errorCount;
    }

    @Generated
    public String getErrorDataFilePath() {
        return this.errorDataFilePath;
    }
}

