/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.write;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.file.excel.annotation.ExcelColor;
import java.lang.reflect.AnnotatedElement;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorWriteHandler
implements CellWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColorWriteHandler.class);

    public void afterCellDispose(CellWriteHandlerContext context) {
        ExcelColor.List list;
        WriteCellData cellData = context.getFirstCellData();
        if (cellData == null || cellData.getStringValue() == null) {
            return;
        }
        ExcelColor color = (ExcelColor)AnnotationUtils.getAnnotation((AnnotatedElement)context.getHeadData().getField(), ExcelColor.class);
        if (color != null) {
            this.fillColor(cellData, color);
        }
        if ((list = (ExcelColor.List)AnnotationUtils.getAnnotation((AnnotatedElement)context.getHeadData().getField(), ExcelColor.List.class)) != null) {
            for (ExcelColor item : list.value()) {
                this.fillColor(cellData, item);
            }
        }
    }

    private void fillColor(WriteCellData<?> cellData, ExcelColor color) {
        if (Pattern.matches(color.regex(), cellData.getStringValue())) {
            WriteCellStyle writeCellStyleData = cellData.getOrCreateStyle();
            if (color.backgroundColor() != IndexedColors.AUTOMATIC && writeCellStyleData.getFillForegroundColor() == null) {
                writeCellStyleData.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
                writeCellStyleData.setFillForegroundColor(Short.valueOf(color.backgroundColor().getIndex()));
            }
            if (color.fontColor() != IndexedColors.AUTOMATIC && writeCellStyleData.getWriteFont() == null) {
                WriteFont writeFont = new WriteFont();
                writeFont.setColor(Short.valueOf(color.fontColor().getIndex()));
                writeCellStyleData.setWriteFont(writeFont);
            }
        }
    }
}

