/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.write;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.file.excel.BaseExcelModel;
import com.diboot.file.excel.annotation.ExcelComment;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class CommentWriteHandler
implements CellWriteHandler {
    private List<? extends BaseExcelModel> dataList;

    public CommentWriteHandler() {
    }

    public CommentWriteHandler(List<? extends BaseExcelModel> dataList) {
        this.dataList = dataList;
    }

    public CommentWriteHandler setDataList(List<? extends BaseExcelModel> dataList) {
        this.dataList = dataList;
        return this;
    }

    public void afterCellCreate(CellWriteHandlerContext context) {
        Head head = context.getHeadData();
        List headNames = head.getHeadNameList();
        int lastHeadIndex = headNames.size() - 1;
        Integer rowIndex = context.getRowIndex();
        if (!context.getHead().booleanValue() || rowIndex != lastHeadIndex && !((String)headNames.get(rowIndex)).equals(headNames.get(lastHeadIndex))) {
            return;
        }
        ExcelComment comment = (ExcelComment)AnnotationUtils.getAnnotation((AnnotatedElement)head.getField(), ExcelComment.class);
        if (comment == null || V.isEmpty((String)comment.value())) {
            return;
        }
        Sheet sheet = context.getWriteSheetHolder().getSheet();
        Cell cell = context.getCell();
        cell.setCellComment(this.buildComment(sheet.createDrawingPatriarch(), cell.getColumnIndex(), sheet.getLastRowNum(), comment.value()));
    }

    public void afterCellDispose(CellWriteHandlerContext context) {
        Map<String, String> field2InvalidValueMap;
        int dataIndex = context.getRelativeRowIndex();
        if (context.getHead().booleanValue() || V.isEmpty(this.dataList) || this.dataList.size() <= dataIndex) {
            return;
        }
        BaseExcelModel excelModel = this.dataList.get(dataIndex);
        String fieldName = context.getHeadData().getFieldName();
        Cell cell = context.getCell();
        String comment = S.join((Iterable)excelModel.getComment().get(fieldName), (String)";\n");
        if (V.notEmpty((String)comment)) {
            Sheet sheet = context.getWriteSheetHolder().getSheet();
            cell.setCellComment(this.buildComment(sheet.createDrawingPatriarch(), cell.getColumnIndex(), sheet.getLastRowNum(), comment));
        }
        if ((field2InvalidValueMap = excelModel.getField2InvalidValueMap()).containsKey(fieldName)) {
            cell.setCellValue(field2InvalidValueMap.get(fieldName));
        }
    }

    protected Comment buildComment(Drawing<?> drawingPatriarch, int col, int row, String commentContent) {
        Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, col, row, col, row));
        comment.setString((RichTextString)new XSSFRichTextString(commentContent));
        return comment;
    }
}

