/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.write;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.context.SheetWriteHandlerContext;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class FreezePaneWriteHandler
implements SheetWriteHandler {
    private Integer colSplit;
    private Integer rowSplit;
    private Integer leftmostColumn;
    private Integer topRow;

    public FreezePaneWriteHandler() {
    }

    public FreezePaneWriteHandler(int colSplit, int rowSplit) {
        this.colSplit = colSplit;
        this.rowSplit = rowSplit;
    }

    public FreezePaneWriteHandler(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this(colSplit, rowSplit);
        this.leftmostColumn = leftmostColumn;
        this.topRow = topRow;
    }

    public void afterSheetCreate(SheetWriteHandlerContext context) {
        Sheet sheet = context.getWriteSheetHolder().getSheet();
        if (this.colSplit == null) {
            WriteHolder writeHolder = context.getWriteContext().currentWriteHolder();
            Map headMap = writeHolder.excelWriteHeadProperty().getHeadMap();
            sheet.createFreezePane(0, ((Head)headMap.get(0)).getHeadNameList().size());
        } else if (this.leftmostColumn == null) {
            sheet.createFreezePane(this.colSplit.intValue(), this.rowSplit.intValue());
        } else {
            sheet.createFreezePane(this.colSplit.intValue(), this.rowSplit.intValue(), this.leftmostColumn.intValue(), this.topRow.intValue());
        }
    }
}

