/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.write;

import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.WorkbookWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.V;
import com.diboot.file.excel.annotation.ExcelMerge;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeWriteHandler
implements WorkbookWriteHandler,
CellWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeWriteHandler.class);
    private final Set<Integer> columnIndexSet = new HashSet<Integer>();
    private Integer headerRows;

    public void afterCellDispose(CellWriteHandlerContext context) {
        if (this.headerRows == null && context.getRelativeRowIndex() > 0) {
            this.headerRows = context.getRowIndex() - context.getRelativeRowIndex();
        }
        if (context.getRowIndex() != 0) {
            return;
        }
        ExcelMerge merge = (ExcelMerge)AnnotationUtils.getAnnotation((AnnotatedElement)context.getHeadData().getField(), ExcelMerge.class);
        if (merge != null) {
            this.columnIndexSet.add(context.getColumnIndex());
        }
    }

    public void afterWorkbookDispose(WriteWorkbookHolder writeWorkbookHolder) {
        for (WriteSheetHolder sheet : writeWorkbookHolder.getHasBeenInitializedSheetNameMap().values()) {
            for (WriteHandler handler : sheet.getWriteHandlerList()) {
                if (!(handler instanceof MergeWriteHandler)) continue;
                ((MergeWriteHandler)handler).afterSheetDispose(sheet);
            }
        }
    }

    public void afterSheetDispose(WriteSheetHolder writeSheetHolder) {
        if (this.columnIndexSet.isEmpty() || this.headerRows == null) {
            return;
        }
        Sheet sheet = writeSheetHolder.getSheet();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Row preRow = sheet.getRow(this.headerRows.intValue());
        int totalRowNum = sheet.getLastRowNum() + this.headerRows;
        for (int rowNum = this.headerRows + 1; rowNum < totalRowNum; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            for (Integer index : this.columnIndexSet) {
                if (this.equalsValue(preRow.getCell(index.intValue()), row.getCell(index.intValue()))) {
                    if (map.containsKey(index)) continue;
                    map.put(index, preRow.getRowNum());
                    continue;
                }
                if (!map.containsKey(index)) continue;
                sheet.addMergedRegionUnsafe(new CellRangeAddress(((Integer)map.remove(index)).intValue(), preRow.getRowNum(), index.intValue(), index.intValue()));
            }
            preRow = row;
        }
        int endRowNum = preRow.getRowNum();
        map.forEach((key, value) -> sheet.addMergedRegionUnsafe(new CellRangeAddress(value.intValue(), endRowNum, key.intValue(), key.intValue())));
    }

    private boolean equalsValue(Cell source, Cell target) {
        if (source == null || target == null || source.getCellType() != target.getCellType()) {
            return false;
        }
        return switch (source.getCellType()) {
            case CellType.STRING -> V.equals((Object)source.getStringCellValue(), (Object)target.getStringCellValue());
            case CellType.NUMERIC -> V.equals((Object)source.getNumericCellValue(), (Object)target.getNumericCellValue());
            case CellType.BOOLEAN -> V.equals((Object)source.getBooleanCellValue(), (Object)target.getBooleanCellValue());
            default -> false;
        };
    }
}

