/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.excel.write;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.service.DictionaryServiceExtProvider;
import com.diboot.core.util.AnnotationUtils;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.LabelValue;
import com.diboot.file.excel.annotation.ExcelOption;
import java.lang.reflect.AnnotatedElement;
import lombok.Generated;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionWriteHandler
implements CellWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptionWriteHandler.class);

    public void beforeCellCreate(CellWriteHandlerContext context) {
        int n;
        Sheet sheet = context.getWriteSheetHolder().getSheet();
        if (sheet.getLastRowNum() != 0) {
            return;
        }
        Head head = context.getHeadData();
        ExcelOption option = (ExcelOption)AnnotationUtils.getAnnotation((AnnotatedElement)head.getField(), ExcelOption.class);
        if (option == null) {
            return;
        }
        String[] options = null;
        String dictType = option.dict();
        if (S.isNotEmpty((CharSequence)dictType)) {
            options = this.getDictOptions(dictType);
        }
        if (V.isEmpty(options)) {
            options = option.options();
        }
        if (V.isEmpty((String[])options)) {
            return;
        }
        int col = context.getColumnIndex();
        int rows = option.rows();
        int firstRow = -1;
        if (rows > 0) {
            firstRow = head.getHeadNameList().size();
            n = firstRow - 1 + rows;
        } else {
            n = -1;
        }
        int lastRow = n;
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, col, col);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createExplicitListConstraint(options);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.setErrorStyle(option.errorStyle());
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    protected String[] getDictOptions(String dictType) {
        DictionaryServiceExtProvider bindDictService = (DictionaryServiceExtProvider)ContextHolder.getBean(DictionaryServiceExtProvider.class);
        if (bindDictService == null) {
            throw new InvalidUsageException("exception.invalidUsage.optionWriteHandler.getDictOptions.message", new Object[0]);
        }
        String[] options = (String[])bindDictService.getLabelValueList(dictType).stream().map(LabelValue::getLabel).toArray(String[]::new);
        if (V.isEmpty((String[])options)) {
            log.warn("@ExcelOption \u5173\u8054\u5b57\u5178: {} \u65e0\u503c", (Object)dictType);
        }
        return options;
    }
}

