/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.OSSObject;
import com.diboot.core.util.S;
import com.diboot.file.config.FileProperties;
import com.diboot.file.entity.FileRecord;
import com.diboot.file.service.FileStorageService;
import com.diboot.file.util.FileHelper;
import com.diboot.file.util.HttpHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="fileStorageService")
@ConditionalOnClass(value={OSSClientBuilder.class})
@ConditionalOnProperty(prefix="diboot.file.oss.aliyun", name={"endpoint", "access-key-id", "access-key-secret"})
public class AliyunOssFileStorageServiceImpl
implements FileStorageService {
    @Autowired
    private FileProperties fileProperties;
    private OSS ossClient;

    @PostConstruct
    public void init() {
        FileProperties.OSS.Aliyun aliyun = this.fileProperties.getOss().getAliyun();
        this.ossClient = new OSSClientBuilder().build(aliyun.getEndpoint(), aliyun.getAccessKeyId(), aliyun.getAccessKeySecret());
    }

    @PreDestroy
    public void destroy() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
    }

    @Override
    public FileRecord save(MultipartFile file) throws Exception {
        FileRecord fileRecord = new FileRecord(S.newUuid());
        String ext = FileHelper.getFileExtByName(file.getOriginalFilename());
        String fileFullPath = this.save(file.getInputStream(), fileRecord.getId() + "-" + file.getOriginalFilename());
        return fileRecord.setFileName(file.getOriginalFilename()).setFileType(ext).setFileSize(file.getSize()).setStoragePath(fileFullPath).setAccessUrl(fileFullPath);
    }

    @Override
    public FileRecord save(InputStream inputStream, String fileName, long size) throws Exception {
        FileRecord fileRecord = new FileRecord(S.newUuid());
        String ext = FileHelper.getFileExtByName(fileName);
        String fileFullPath = this.save(inputStream, fileRecord.getId() + "-" + fileName);
        return fileRecord.setFileName(fileName).setFileType(ext).setFileSize(size).setStoragePath(fileFullPath).setAccessUrl(fileFullPath);
    }

    private String save(InputStream inputStream, String fileName) {
        FileProperties.OSS.Aliyun aliyun = this.fileProperties.getOss().getAliyun();
        String bucketName = aliyun.getBucketName();
        if (!this.ossClient.doesBucketExist(bucketName)) {
            this.ossClient.createBucket(bucketName);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
            createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
            this.ossClient.createBucket(createBucketRequest);
        }
        this.ossClient.putObject(bucketName, fileName, inputStream);
        return this.ossClient.generatePresignedUrl(bucketName, fileName, new Date(System.currentTimeMillis() + aliyun.getExpiration() * 60L * 1000L)).toString();
    }

    @Override
    public InputStream getFile(String filePath) throws Exception {
        FileProperties.OSS.Aliyun aliyun = this.fileProperties.getOss().getAliyun();
        String filename = S.substringAfter((String)S.substringBefore((String)filePath, (String)"?"), (String)(aliyun.getEndpoint() + "/"));
        OSSObject ossObject = this.ossClient.getObject(aliyun.getBucketName(), URLDecoder.decode(filename, StandardCharsets.UTF_8));
        return ossObject.getObjectContent();
    }

    @Override
    public void download(FileRecord fileRecord, HttpServletResponse response) throws Exception {
        FileProperties.OSS.Aliyun aliyun = this.fileProperties.getOss().getAliyun();
        String bucketName = aliyun.getBucketName();
        String filename = fileRecord.getId() + "-" + fileRecord.getFileName();
        OSSObject ossObject = this.ossClient.getObject(bucketName, filename);
        HttpHelper.downloadFile(ossObject.getObjectContent(), fileRecord.getFileSize(), fileRecord.getFileName(), response);
    }

    @Override
    public boolean delete(String filePath) {
        FileProperties.OSS.Aliyun aliyun = this.fileProperties.getOss().getAliyun();
        String filename = S.substringAfter((String)S.substringBefore((String)filePath, (String)"?"), (String)(aliyun.getEndpoint() + "/"));
        this.ossClient.deleteObject(aliyun.getBucketName(), URLDecoder.decode(filename, StandardCharsets.UTF_8));
        return true;
    }
}

