/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.service.impl;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.file.entity.FileRecord;
import com.diboot.file.service.FileStorageService;
import com.diboot.file.util.FileHelper;
import com.diboot.file.util.HttpHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class LocalFileStorageServiceImpl
implements FileStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalFileStorageServiceImpl.class);

    @Override
    public FileRecord save(MultipartFile file) throws Exception {
        String fileUid = S.newUuid();
        String ext = FileHelper.getFileExtByName(file.getOriginalFilename());
        String newFileName = V.notEmpty((String)ext) ? fileUid + "." + ext : fileUid;
        String fileFullPath = FileHelper.saveFile(file, newFileName);
        return new FileRecord(fileUid).setFileName(file.getOriginalFilename()).setFileType(ext).setFileSize(file.getSize()).setStoragePath(fileFullPath).setAccessUrl(this.buildAccessUrl(fileUid, ext));
    }

    @Override
    public FileRecord save(InputStream inputStream, String fileName, long size) throws Exception {
        String fileUid = S.newUuid();
        String ext = FileHelper.getFileExtByName(fileName);
        String newFileName = V.notEmpty((String)ext) ? fileUid + "." + ext : fileUid;
        String fileFullPath = FileHelper.saveFile(inputStream, newFileName);
        return new FileRecord(fileUid).setFileName(fileName).setFileType(ext).setFileSize(size).setStoragePath(fileFullPath).setAccessUrl(this.buildAccessUrl(fileUid, ext));
    }

    @Override
    public FileRecord save(String diskFilePath, String fileName) throws Exception {
        File file = new File(diskFilePath);
        if (!file.exists()) {
            log.error("\u6587\u4ef6: {} \u4e0d\u5b58\u5728\uff01", (Object)diskFilePath);
            throw new BusinessException("exception.business.file.nonexist", new Object[0]);
        }
        String fileUid = S.newUuid();
        String ext = FileHelper.getFileExtByName(fileName);
        return new FileRecord(fileUid).setFileName(fileName).setFileType(ext).setFileSize(file.length()).setStoragePath(diskFilePath).setAccessUrl(this.buildAccessUrl(fileUid, ext));
    }

    @Override
    public InputStream getFile(String filePath) throws Exception {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
        }
        return null;
    }

    @Override
    public void download(FileRecord uploadFile, HttpServletResponse response) throws Exception {
        if (V.isEmpty((Object)((Object)uploadFile))) {
            throw new BusinessException(Status.FAIL_OPERATION, "exception.business.fileStorageService.nonexist", new Object[0]);
        }
        HttpHelper.downloadLocalFile(uploadFile.getStoragePath(), uploadFile.getFileName(), response);
    }

    @Override
    public boolean delete(String filePath) {
        File file = new File(filePath);
        return file.delete();
    }
}

