/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.enums.CacheLocationEnum;
import com.alibaba.excel.metadata.ConfigurationHolder;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.diboot.core.util.I18n;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.JsonResult;
import com.diboot.core.vo.Status;
import com.diboot.file.excel.BaseExcelModel;
import com.diboot.file.excel.TableHead;
import com.diboot.file.excel.write.ColorWriteHandler;
import com.diboot.file.excel.write.CommentWriteHandler;
import com.diboot.file.excel.write.MergeWriteHandler;
import com.diboot.file.excel.write.OptionWriteHandler;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelHelper.class);

    public static void read(InputStream inputStream, ReadListener<?> listener) {
        ExcelHelper.read(inputStream, listener, null);
    }

    public static <T> void read(InputStream inputStream, ReadListener<T> listener, Class<T> headClazz) {
        ExcelHelper.read(inputStream, null, listener, headClazz);
    }

    public static <T> void read(InputStream inputStream, ExcelTypeEnum excelType, ReadListener<T> listener, Class<T> headClazz) {
        ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream).excelType(excelType).registerReadListener(listener)).head(headClazz)).sheet().doRead();
    }

    public static void write(OutputStream outputStream, String sheetName, List<List<String>> headList, List<List<String>> dataList, WriteHandler ... writeHandlers) {
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)outputStream);
        write = (ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        for (WriteHandler handler : writeHandlers) {
            write = (ExcelWriterBuilder)write.registerWriteHandler(handler);
        }
        ExcelWriterSheetBuilder sheet = (ExcelWriterSheetBuilder)write.sheet(sheetName).head(headList);
        sheet.doWrite(dataList);
    }

    public static <T> void write(OutputStream outputStream, Class<T> clazz, List<T> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.write(outputStream, clazz, null, dataList, writeHandlers);
    }

    public static <T> void write(OutputStream outputStream, Class<T> clazz, Collection<String> columnNameList, List<T> dataList, WriteHandler ... writeHandlers) {
        AtomicBoolean first = new AtomicBoolean(true);
        ExcelHelper.write(outputStream, clazz, columnNameList, () -> first.getAndSet(false) ? dataList : null, writeHandlers);
    }

    public static <T> void write(OutputStream outputStream, Class<T> clazz, Collection<String> columnNameList, Supplier<List<T>> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.write(outputStream, clazz, columnNameList, null, dataList, writeHandlers);
    }

    public static <T> void write(OutputStream outputStream, Class<T> clazz, Collection<String> columnNameList, Boolean autoClose, Supplier<List<T>> dataList, WriteHandler ... writeHandlers) {
        ExcelWriter excel = EasyExcel.write((OutputStream)outputStream).autoCloseStream(autoClose).build();
        ExcelHelper.writeSheet(excel, "Sheet1", clazz, columnNameList, dataList, writeHandlers);
        excel.finish();
    }

    public static <T> void writeSheet(ExcelWriter excel, String sheetName, Class<T> clazz, List<T> dataList, WriteHandler ... writeHandlers) {
        AtomicBoolean first = new AtomicBoolean(true);
        ExcelHelper.writeSheet(excel, sheetName, clazz, () -> first.getAndSet(false) ? dataList : null, writeHandlers);
    }

    public static <T> void writeSheet(ExcelWriter excel, String sheetName, Class<T> clazz, Supplier<List<T>> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.writeSheet(excel, sheetName, clazz, null, dataList, writeHandlers);
    }

    public static <T> void writeSheet(ExcelWriter excel, String sheetName, Class<T> clazz, Collection<String> columnNameList, Supplier<List<T>> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.buildWriteSheet(sheetName, clazz, columnNameList, (commentWriteHandler, writeSheet) -> {
            List list = (List)dataList.get();
            boolean assignableFrom = BaseExcelModel.class.isAssignableFrom(clazz);
            do {
                if (assignableFrom) {
                    commentWriteHandler.setDataList(list);
                }
                excel.write((Collection)list, writeSheet);
            } while (V.notEmpty((Collection)(list = (List)dataList.get())));
        }, writeHandlers);
    }

    public static <T> void buildWriteSheet(String sheetName, Class<T> clazz, Collection<String> columnNameList, BiConsumer<CommentWriteHandler, WriteSheet> consumer, WriteHandler ... writeHandlers) {
        ExcelWriterSheetBuilder writerSheet = (ExcelWriterSheetBuilder)EasyExcel.writerSheet().sheetName(sheetName).head(clazz);
        CommentWriteHandler commentWriteHandler = new CommentWriteHandler();
        writerSheet.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        writerSheet.registerWriteHandler((WriteHandler)new OptionWriteHandler());
        writerSheet.registerWriteHandler((WriteHandler)new ColorWriteHandler());
        writerSheet.registerWriteHandler((WriteHandler)new MergeWriteHandler());
        writerSheet.registerWriteHandler((WriteHandler)commentWriteHandler);
        for (WriteHandler handler : writeHandlers) {
            writerSheet.registerWriteHandler(handler);
        }
        if (V.notEmpty(columnNameList)) {
            writerSheet.includeColumnFieldNames(columnNameList);
        }
        consumer.accept(commentWriteHandler, writerSheet.build());
    }

    public static <T> void exportExcel(HttpServletResponse response, String fileName, Class<T> clazz, List<T> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.exportExcel(response, fileName, clazz, null, dataList, writeHandlers);
    }

    public static <T> void exportExcel(HttpServletResponse response, String fileName, Class<T> clazz, Collection<String> columnNameList, List<T> dataList, WriteHandler ... writeHandlers) {
        AtomicBoolean first = new AtomicBoolean(true);
        ExcelHelper.exportExcel(response, fileName, clazz, columnNameList, () -> first.getAndSet(false) ? dataList : null, writeHandlers);
    }

    public static <T> void exportExcel(HttpServletResponse response, String fileName, Class<T> clazz, Collection<String> columnNameList, Supplier<List<T>> dataList, WriteHandler ... writeHandlers) {
        ExcelHelper.exportExcel(response, fileName, excel -> ExcelHelper.writeSheet(excel, "Sheet1", clazz, columnNameList, dataList, writeHandlers));
    }

    public static void exportExcel(HttpServletResponse response, String fileName, Consumer<ExcelWriter> writerConsumer) {
        ExcelHelper.setExportExcelResponseHeader(response, fileName);
        try {
            ExcelWriter excel = EasyExcel.write((OutputStream)response.getOutputStream()).autoCloseStream(Boolean.FALSE).build();
            writerConsumer.accept(excel);
            excel.finish();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            try {
                response.getWriter().println(JsonResult.FAIL_OPERATION((String)I18n.message((String)"exception.business.excel.downloadFailed", (Object[])new Object[0])));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void setExportExcelResponseHeader(HttpServletResponse response, String fileName) {
        response.setContentType("application/x-msdownload");
        response.setCharacterEncoding("utf-8");
        response.setHeader("code", String.valueOf(Status.OK.code()));
        try {
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name());
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            response.setHeader("filename", fileName);
            response.setHeader("msg", URLEncoder.encode("\u64cd\u4f5c\u6210\u529f", StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u4e0d\u652f\u6301\u5b57\u7b26\u7f16\u7801", (Throwable)e);
        }
    }

    public static List<TableHead> getTableHeads(Class<?> clazz) {
        WriteSheetHolder ws = new WriteSheetHolder();
        GlobalConfiguration configuration = new GlobalConfiguration();
        configuration.setFiledCacheLocation(CacheLocationEnum.MEMORY);
        ws.setGlobalConfiguration(configuration);
        Map sortedFieldMap = ClassUtils.declaredFields(clazz, (ConfigurationHolder)ws).getSortedFieldMap();
        TreeMap<Integer, List<String>> headNameMap = new TreeMap<Integer, List<String>>();
        HashMap<Integer, String> fieldNameMap = new HashMap<Integer, String>();
        sortedFieldMap.forEach((index, field) -> {
            fieldNameMap.put((Integer)index, field.getFieldName());
            headNameMap.put((Integer)index, Arrays.asList(field.getHeads()));
        });
        return ExcelHelper.buildTableHeads(headNameMap, fieldNameMap);
    }

    public static List<TableHead> buildTableHeads(Map<Integer, List<String>> headNameMap, Map<Integer, String> fieldNameMap) {
        ArrayList<TableHead> tableHead = new ArrayList<TableHead>();
        HashMap<String, TableHead> hashMap = new HashMap<String, TableHead>();
        int col = Integer.MIN_VALUE;
        for (Map.Entry<Integer, List<String>> entry : headNameMap.entrySet()) {
            if (entry.getKey() - 1 != col) {
                hashMap = new HashMap();
            }
            col = entry.getKey();
            List<String> list = entry.getValue();
            boolean bool = true;
            while (list.size() > 1 && bool) {
                int lastIndex = list.size() - 1;
                if (list.get(lastIndex).equals(list.get(lastIndex - 1))) {
                    list.remove(lastIndex);
                    continue;
                }
                bool = false;
            }
            ArrayList<String> path = new ArrayList<String>();
            TableHead node = null;
            int lastIndex = list.size() - 1;
            for (int i = 0; i <= lastIndex; ++i) {
                List<TableHead> children;
                TableHead item;
                final String name = list.get(i);
                path.add(name);
                String key = S.join(path, (String)"\u2192");
                if (hashMap.containsKey(key)) {
                    item = (TableHead)hashMap.get(key);
                } else {
                    if (i == 0) {
                        hashMap = new HashMap();
                    }
                    item = new TableHead(){
                        {
                            this.setTitle(name);
                        }
                    };
                    hashMap.put(key, item);
                    if (node == null) {
                        tableHead.add(item);
                    } else {
                        children = node.getChildren();
                        if (children == null) {
                            children = new ArrayList<TableHead>();
                            node.setChildren(children);
                        }
                        if (node.getKey() != null) {
                            TableHead originalNode = new TableHead();
                            originalNode.setKey(node.getKey());
                            originalNode.setTitle(node.getTitle());
                            node.setKey(null);
                            children.add(originalNode);
                        }
                        children.add(item);
                    }
                }
                node = item;
                if (i != lastIndex) continue;
                children = item.getChildren();
                if (children == null) {
                    item.setKey(fieldNameMap.get(col));
                    continue;
                }
                TableHead thisNode = new TableHead();
                thisNode.setKey(fieldNameMap.get(col));
                thisNode.setTitle(item.getTitle());
                children.add(thisNode);
            }
        }
        return tableHead;
    }
}

