/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.exception.InvalidUsageException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.D;
import com.diboot.core.util.PropertiesUtils;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.file.service.FileStorageService;
import com.diboot.file.service.impl.LocalFileStorageServiceImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);
    public static final List<String> DANGER_FILE_SUFFIX = Arrays.asList("exe", "bat", "bin", "dll", "sh", "php", "pl", "py", "cgi", "asp", "aspx", "jsp", "php5", "php4", "php3", "js", "htm", "html", "go");
    private static final List<String> EXCEL_SUFFIX = Arrays.asList("csv", "xls", "xlsx", "xlsm");
    public static final String FILE_STORAGE_DIRECTORY = "diboot.file.storage-directory";
    private static final String PATH_FILE = "/upload/file";
    public static final String POINT = ".";
    public static final String HTTP = "http";
    public static final String QUESTION_MARK = "?";
    private static final String[] SIZE_UNIT = new String[]{"Bytes", "KB", "MB", "GB", "TB", "PB"};
    private static String fileStorageDirectory = null;
    private static Boolean isLocalStorage;

    public static boolean isValidFileExt(String ext) {
        return !DANGER_FILE_SUFFIX.contains(ext.toLowerCase());
    }

    public static boolean isExcel(String fileName) {
        String ext = FileHelper.getFileExtByName(fileName);
        return EXCEL_SUFFIX.contains(ext.toLowerCase());
    }

    public static boolean isLocalStorage() {
        if (isLocalStorage == null) {
            FileStorageService fileStorageService = (FileStorageService)ContextHolder.getBean(FileStorageService.class);
            isLocalStorage = fileStorageService instanceof LocalFileStorageServiceImpl;
        }
        return Boolean.TRUE.equals(isLocalStorage);
    }

    public static String getSystemTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String saveFile(MultipartFile file, String fileName) {
        String fullPath = FileHelper.getFullPath(fileName);
        try {
            FileHelper.makeDirectory(fullPath);
            FileUtils.writeByteArrayToFile((File)new File(fullPath), (byte[])file.getBytes());
            if (log.isDebugEnabled()) {
                log.debug("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f\uff01\u8def\u5f84\u4e3a: {}", (Object)fullPath);
            }
            return fullPath;
        }
        catch (IOException e1) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: file={}", (Object)fullPath, (Object)e1);
            return null;
        }
    }

    public static String saveFile(InputStream inputStream, String fileName) {
        String fullPath = FileHelper.getFullPath(fileName);
        try {
            FileHelper.makeDirectory(fullPath);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(fullPath));
            if (log.isDebugEnabled()) {
                log.debug("\u4fdd\u5b58\u6587\u4ef6\u6210\u529f\uff01\u8def\u5f84\u4e3a: {}", (Object)fullPath);
            }
            return fullPath;
        }
        catch (IOException e1) {
            log.error("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25: file={}", (Object)fullPath, (Object)e1);
            return null;
        }
    }

    public static String getFileExtByName(String fileName) {
        if (V.isEmpty((String)fileName)) {
            throw new BusinessException(Status.FAIL_INVALID_PARAM, "\u6587\u4ef6\u540d\u4e3a\u7a7a\uff1a{}", new Object[]{fileName});
        }
        if (fileName.startsWith(HTTP) && fileName.contains("/")) {
            fileName = FileHelper.getFileName(fileName);
        }
        if (fileName.lastIndexOf(POINT) > 0) {
            return fileName.substring(fileName.lastIndexOf(POINT) + 1).toLowerCase();
        }
        log.debug("\u68c0\u6d4b\u5230\u6ca1\u6709\u540e\u7f00\u7684\u6587\u4ef6\u540d: {}", (Object)fileName);
        return "";
    }

    public static String getRelativePath(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(PATH_FILE).append("/").append(D.getYearMonth()).append("/").append(fileName);
        return sb.toString();
    }

    public static String getFullPath(String fileName) {
        String relativePath = FileHelper.getRelativePath(fileName);
        return FileHelper.getFileStorageDirectory() + relativePath;
    }

    public static String getFileName(String fileUrl) {
        String temp = StringUtils.substring((String)fileUrl, (int)(fileUrl.lastIndexOf("/") + 1));
        if (StringUtils.contains((CharSequence)fileUrl, (CharSequence)QUESTION_MARK)) {
            temp = StringUtils.substring((String)temp, (int)0, (int)temp.lastIndexOf(QUESTION_MARK));
        }
        return temp;
    }

    public static String getFileStorageDirectory() {
        if (fileStorageDirectory == null && (fileStorageDirectory = PropertiesUtils.get((String)FILE_STORAGE_DIRECTORY)) == null) {
            throw new InvalidUsageException("exception.invalidUsage.fileHelper.getFileStorageDirectory.message", new Object[]{FILE_STORAGE_DIRECTORY});
        }
        return fileStorageDirectory;
    }

    public static boolean makeDirectory(String dirPath) {
        String directory = StringUtils.substringBeforeLast((String)dirPath, (String)"/");
        File dir = new File(directory);
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
                return true;
            }
            catch (IOException e) {
                log.error("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean deleteFile(String fileStoragePath) {
        File file = new File(fileStoragePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static String formatFileSize(Long bytes) {
        if (bytes == null || bytes.equals(0L)) {
            return "-";
        }
        int index = (int)Math.floor(Math.log(bytes.longValue()) / Math.log(1024.0));
        double size = (double)bytes.longValue() / Math.pow(1024.0, index);
        size = Double.valueOf(new DecimalFormat("#.0").format(size));
        if (index > SIZE_UNIT.length - 1) {
            return "?PB";
        }
        return size + " " + SIZE_UNIT[index];
    }
}

