/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.S;
import com.diboot.core.util.V;
import com.diboot.core.vo.Status;
import com.diboot.file.util.FileHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class HttpHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    private static final String DEFAULT_CONTEXT_TYPE = "application/octet-stream";
    private static final Map<String, String> EXT_CONTENT_TYPE_MAP = new HashMap(){
        {
            this.put("xls", "application/x-msdownload");
            this.put("xlsx", "application/x-msdownload");
            this.put("doc", "application/x-msdownload");
            this.put("docx", "application/x-msdownload");
            this.put("dot", "application/x-msdownload");
            this.put("ppt", "application/x-msdownload");
            this.put("pptx", "application/x-msdownload");
            this.put("pdf", "application/pdf");
            this.put("avi", "video/avi");
            this.put("bmp", "application/x-bmp");
            this.put("css", "text/css");
            this.put("dll", "application/x-msdownload");
            this.put("dtd", "text/xml");
            this.put("exe", "application/x-msdownload");
            this.put("gif", "image/gif");
            this.put("htm", "text/html");
            this.put("html", "text/html");
            this.put("ico", "image/x-icon");
            this.put("jpeg", "image/jpeg");
            this.put("jpg", "image/jpeg");
            this.put("js", "application/x-javascript");
            this.put("mp3", "audio/mp3");
            this.put("mp4", "video/mpeg4");
            this.put("png", "image/png");
            this.put("svg", "text/xml");
            this.put("swf", "application/x-shockwave-flash");
            this.put("tif", "image/tiff");
            this.put("tiff", "image/tiff");
            this.put("tld", "text/xml");
            this.put("torrent", "application/x-bittorrent");
            this.put("tsd", "text/xml");
            this.put("txt", "text/plain");
            this.put("wav", "audio/wav");
            this.put("wma", "audio/x-ms-wma");
            this.put("wmf", "application/x-wmf");
            this.put("wsdl", "text/xml");
            this.put("xhtml", "text/html");
            this.put("xml", "text/xml");
            this.put("xsd", "text/xml");
            this.put("xsl", "text/xml");
            this.put("xslt", "text/xml");
            this.put("apk", "application/vnd.android.package-archive");
            this.put("zip", "application/x-zip-compressed");
            this.put("rar", HttpHelper.DEFAULT_CONTEXT_TYPE);
        }
    };

    public static String callGet(String url, Map<String, String> headerMap) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        Request.Builder builder = new Request.Builder().url(url);
        if (V.notEmpty(headerMap)) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        Call call = clientBuilder.build().newCall(builder.build());
        return HttpHelper.executeCall(call, url);
    }

    public static Response callPostResponse(String url, Map<String, String> formBody) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (V.notEmpty(formBody)) {
            for (Map.Entry<String, String> entry : formBody.entrySet()) {
                bodyBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)bodyBuilder.build()).build();
        Call call = clientBuilder.build().newCall(request);
        try {
            Response response = call.execute();
            if (response.code() >= 400) {
                log.warn("\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38 : {}", (Object)url);
                return null;
            }
            return response;
        }
        catch (IOException e) {
            log.warn("\u8bf7\u6c42\u8c03\u7528\u89e3\u6790\u5f02\u5e38 : {}", (Object)url, (Object)e);
            return null;
        }
    }

    public static String callPost(String url, Map<String, String> formBody) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (S.startsWithIgnoreCase((CharSequence)url, (CharSequence)"https://")) {
            HttpHelper.withHttps(clientBuilder);
        }
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (V.notEmpty(formBody)) {
            for (Map.Entry<String, String> entry : formBody.entrySet()) {
                bodyBuilder.add(entry.getKey(), entry.getValue());
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)bodyBuilder.build()).build();
        Call call = clientBuilder.build().newCall(request);
        return HttpHelper.executeCall(call, url);
    }

    public static void withHttps(OkHttpClient.Builder builder) {
        try {
            TrustManager[] trustManagers = HttpHelper.buildTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]);
            builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.warn("\u6784\u5efahttps\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
        }
    }

    private static TrustManager[] buildTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }

    private static String executeCall(Call call, String url) {
        try {
            Response response = call.execute();
            if (response.code() >= 400) {
                log.warn("\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38 : {}", (Object)url);
                return null;
            }
            return response.body().string();
        }
        catch (Exception e) {
            log.warn("\u8bf7\u6c42\u8c03\u7528\u89e3\u6790\u5f02\u5e38 : {}", (Object)url, (Object)e);
            return null;
        }
    }

    public static void downloadLocalFile(String localFilePath, String exportFileName, HttpServletResponse response) throws Exception {
        HttpHelper.downloadLocalFile(new File(localFilePath), exportFileName, response);
    }

    public static void downloadLocalFile(File localFile, String exportFileName, HttpServletResponse response) throws Exception {
        HttpHelper.downloadFile(Files.newInputStream(localFile.toPath(), new OpenOption[0]), localFile.length(), exportFileName, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(InputStream inputStream, long fileLength, String exportFileName, HttpServletResponse response) throws Exception {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            String fileName = new String(exportFileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1");
            response.setContentType(HttpHelper.getContextType(fileName));
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            response.setHeader("Content-Length", String.valueOf(fileLength));
            response.setHeader("filename", URLEncoder.encode(exportFileName, StandardCharsets.UTF_8.name()));
            bis = new BufferedInputStream(inputStream);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25:{}", (Object)exportFileName, (Object)e);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static boolean downloadHttpFile(String fileUrl, final String targetFilePath) {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(fileUrl).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    FileUtils.copyInputStreamToFile((InputStream)response.body().byteStream(), (File)new File(targetFilePath));
                }
            }
        });
        return true;
    }

    public static String getContextType(String fileName) {
        String ext = FileHelper.getFileExtByName(fileName);
        String contentType = EXT_CONTENT_TYPE_MAP.get(ext);
        if (contentType == null) {
            contentType = DEFAULT_CONTEXT_TYPE;
        }
        return contentType + ";charset=utf-8";
    }

    public static List<MultipartFile> getFilesFromRequest(HttpServletRequest request, String fileInputName) {
        boolean isMultipart;
        if (fileInputName == null) {
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.httpHelper.noFilename", new Object[0]);
        }
        boolean bl = isMultipart = request.getContentType() != null && request.getContentType().contains("multipart");
        if (!isMultipart) {
            throw new BusinessException(Status.FAIL_VALIDATION, "exception.business.httpHelper.invalidFiles", new Object[0]);
        }
        List files = ((MultipartHttpServletRequest)request).getFiles(fileInputName);
        return files;
    }

    public static MultipartFile getFileFromRequest(HttpServletRequest request, String fileInputName) {
        List<MultipartFile> files = HttpHelper.getFilesFromRequest(request, fileInputName);
        return V.notEmpty(files) ? files.get(0) : null;
    }
}

