/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import com.diboot.core.util.D;
import com.diboot.core.util.S;
import com.diboot.file.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageHelper.class);
    private static final String DATA_IMAGE_FLAG = "data:image/";
    private static final String BASE_64_FLAG = "base64,";
    private static final String PATH_IMG = "/upload/img";
    public static final String VALID_IMAGE_SUFFIX = "|png|jpg|jpeg|gif|bmp|";

    public static boolean isImage(String ext) {
        return VALID_IMAGE_SUFFIX.contains("|" + ext.toLowerCase() + "|");
    }

    public static String saveImage(MultipartFile file, String imgName) {
        String accessPath = ImageHelper.getImageStoragePath(imgName);
        String fullPath = FileHelper.getFileStorageDirectory() + accessPath;
        try {
            FileHelper.makeDirectory(fullPath);
            FileUtils.writeByteArrayToFile((File)new File(fullPath), (byte[])file.getBytes());
            if (log.isDebugEnabled()) {
                log.debug("\u4fdd\u5b58\u56fe\u7247\u6210\u529f\uff01\u8def\u5f84\u4e3a: {}", (Object)accessPath);
            }
            return accessPath;
        }
        catch (IOException e1) {
            log.error("\u4fdd\u5b58\u539f\u56fe\u7247\u5931\u8d25: image={}", (Object)accessPath, (Object)e1);
            return null;
        }
    }

    public static String saveImage(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String ext = S.substringAfterLast((String)fileName, (String)".");
        String newFileName = S.newUuid() + "." + ext;
        return ImageHelper.saveImage(file, newFileName);
    }

    public static String saveImage(File file, String imgName, boolean reserve) {
        String accessPath = ImageHelper.getImageStoragePath(imgName);
        String fullPath = FileHelper.getFileStorageDirectory() + accessPath;
        try {
            FileHelper.makeDirectory(fullPath);
            FileUtils.copyFile((File)new File(fullPath), (File)file);
            if (log.isDebugEnabled()) {
                log.debug("\u4fdd\u5b58\u56fe\u7247\u6210\u529f\uff01\u8def\u5f84\u4e3a: {}", (Object)accessPath);
            }
            if (!reserve && !StringUtils.equals((CharSequence)file.getAbsolutePath(), (CharSequence)fullPath)) {
                FileUtils.forceDelete((File)file);
            }
            return accessPath;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u539f\u56fe\u7247\u5931\u8d25: image={}", (Object)accessPath, (Object)e);
            return null;
        }
    }

    public static String getImageStoragePath(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(PATH_IMG).append("/").append(D.getYearMonth()).append("/").append(fileName);
        return sb.toString();
    }

    public static boolean convertBase64ToImage(String base64Str, String fullFilePath) {
        if (base64Str == null) {
            return false;
        }
        if (base64Str.contains(BASE_64_FLAG)) {
            base64Str = base64Str.substring(base64Str.indexOf(BASE_64_FLAG) + BASE_64_FLAG.length());
        }
        try {
            byte[] data = Base64.getDecoder().decode(base64Str);
            File file = new File(fullFilePath);
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            return true;
        }
        catch (Exception e) {
            log.warn("base", (Throwable)e);
            return false;
        }
    }
}

