/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import com.diboot.file.util.FileHelper;
import com.diboot.file.util.ImageHelper;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageThumbnailHelper
extends ImageHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImageThumbnailHelper.class);

    public static String generateThumbnail(String imgUrl, int width, int height) {
        String file = imgUrl.substring(imgUrl.indexOf("/img/"));
        String imageFileDirectory = FileHelper.getFileStorageDirectory() + file;
        try {
            String targetFile = imgUrl.replace(".", "_tn.");
            Thumbnails.of((String[])new String[]{imageFileDirectory}).size(width, height).outputQuality(0.7f).toFile(FileHelper.getFileStorageDirectory() + targetFile);
            return targetFile;
        }
        catch (IOException e1) {
            log.error("\u538b\u7f29\u56fe\u7247\u5f02\u5e38: image={} ", (Object)imageFileDirectory, (Object)e1);
            return imgUrl;
        }
    }

    public static String generateThumbnail(String sourcePath, String targetPath, int width, int height) throws Exception {
        boolean result;
        File file = new File(sourcePath);
        if (!file.exists() && !(result = file.mkdir())) {
            log.warn("\u521b\u5efa\u6587\u4ef6\u5939 {} \u5931\u8d25", (Object)sourcePath);
        }
        Thumbnails.of((String[])new String[]{sourcePath}).size(width, height).toFile(targetPath);
        return targetPath;
    }

    public static void addWatermark(String filePath, String watermark) throws Exception {
        Thumbnails.of((String[])new String[]{filePath}).watermark((Position)Positions.BOTTOM_RIGHT, ImageIO.read(new File(watermark)), 0.8f).toFile(filePath);
    }
}

