/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.file.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZipHelper.class);

    private static void zipFile(String srcRootDir, File file, ZipOutputStream zos, String ... matchKeyword) throws Exception {
        if (file == null) {
            log.error("[Zip]file\u5bf9\u8c61\u4e3a\u7a7a,\u538b\u7f29\u5931\u8d25\uff01");
            return;
        }
        if (file.isFile()) {
            int bufferLen = 1024;
            byte[] data = new byte[bufferLen];
            String fileName = file.getName();
            if (matchKeyword == null || matchKeyword.length == 0 || fileName.indexOf(matchKeyword[0]) >= 0) {
                int count;
                String subPath = file.getAbsolutePath();
                if ((subPath = subPath.replace("\\", "/")).indexOf(srcRootDir) != -1) {
                    subPath = subPath.substring(srcRootDir.length() + File.separator.length());
                }
                ZipEntry entry = new ZipEntry(subPath);
                zos.putNextEntry(entry);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                while ((count = bis.read(data, 0, bufferLen)) != -1) {
                    zos.write(data, 0, count);
                }
                log.info("[Zip]\u538b\u7f29\u6210\u529f\uff1a{}", (Object)file.getName());
                bis.close();
                zos.closeEntry();
            }
        } else {
            File[] childFileList = file.listFiles();
            if (childFileList != null) {
                for (int n = 0; n < childFileList.length; ++n) {
                    if (!childFileList[n].isFile()) {
                        String filePath = childFileList[n].getPath();
                        if (matchKeyword != null && matchKeyword.length > 0 && filePath.indexOf(matchKeyword[0]) == -1) continue;
                    }
                    ZipHelper.zipFile(srcRootDir, childFileList[n], zos, matchKeyword);
                }
            }
        }
    }

    public static boolean zip(String srcPath, String zipPath, String zipFileName, String ... excludeKeyword) throws Exception {
        if (StringUtils.isEmpty((CharSequence)srcPath)) {
            log.error("[Zip]\u6e90\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u538b\u7f29\u5931\u8d25\uff01");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)zipPath)) {
            log.error("[Zip]\u538b\u7f29\u6587\u4ef6\u4fdd\u5b58\u7684\u8def\u5f84\u4e3a\u7a7a\uff0c\u538b\u7f29\u5931\u8d25\uff01");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)zipFileName)) {
            log.error("[Zip]\u538b\u7f29\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u538b\u7f29\u5931\u8d25\uff01");
            return false;
        }
        File srcFile = new File(srcPath);
        if (srcFile.exists()) {
            int index;
            boolean success;
            String zipFilePath;
            File zipFile;
            boolean success2;
            if (srcFile.isDirectory() && zipPath.indexOf(srcPath) != -1) {
                log.error("[Zip]\u538b\u7f29\u6587\u4ef6\u4fdd\u5b58\u7684\u8def\u5f84\u662f\u6e90\u6587\u4ef6\u7684\u5b57\u6587\u4ef6\u5939,\u538b\u7f29\u5931\u8d25\uff01");
                return false;
            }
            File zipDir = new File(zipPath);
            if (!(zipDir.exists() && zipDir.isDirectory() || (success2 = zipDir.mkdirs()))) {
                log.warn("\u521b\u5efa\u6587\u4ef6\u5939: {} \u5931\u8d25", (Object)zipPath);
            }
            if ((zipFile = new File(zipFilePath = zipPath + "/" + zipFileName)).exists() && !(success = zipFile.delete())) {
                log.warn("\u5220\u9664\u6587\u4ef6\u5939: {} \u5931\u8d25", (Object)zipFilePath);
            }
            CheckedOutputStream cos = new CheckedOutputStream(new FileOutputStream(zipFile), new CRC32());
            ZipOutputStream zos = new ZipOutputStream(cos);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf("/")) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipHelper.zipFile(srcRootDir, srcFile, zos, excludeKeyword);
            zos.flush();
            zos.close();
            return true;
        }
        log.error("[Zip]\u5f53\u524d\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u538b\u7f29\u5931\u8d25\uff01path={}", (Object)srcPath);
        return false;
    }
}

