/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.Encoding;
import java.util.Objects;

public interface ChatFormatDescriptor {
    public Encoding encoding();

    public int extraTokenCountPerMessage();

    public int extraTokenCountPerRequest();

    public static ChatFormatDescriptor forModel(String modelName) {
        return switch (modelName) {
            case "gpt-3.5-turbo" -> ChatFormatDescriptor.forModel("gpt-3.5-turbo-0301");
            case "gpt-4" -> ChatFormatDescriptor.forModel("gpt-4-0314");
            case "gpt-3.5-turbo-0301" -> new Of(Encoding.forModel(modelName), 4, 3);
            case "gpt-4-0314" -> new Of(Encoding.forModel(modelName), 3, 3);
            default -> throw new IllegalArgumentException(String.format("Model `%s` not found", modelName));
        };
    }

    public record Of(Encoding encoding, int extraTokenCountPerMessage, int extraTokenCountPerRequest) implements ChatFormatDescriptor
    {
        public Of {
            Objects.requireNonNull(encoding, "encoding");
        }
    }
}

