/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.ChatFormatDescriptor;
import com.didalgo.gpt3.GPT3Tokenizer;
import com.theokanning.openai.completion.chat.ChatMessage;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class TokenCount {
    public static int fromLinesJoined(Iterable<String> lines, GPT3Tokenizer tokenizer) {
        int tokenCount = StreamSupport.stream(lines.spliterator(), false).mapToInt(line -> TokenCount.fromString(line, tokenizer) + 1).sum();
        return Math.max(0, tokenCount - 1);
    }

    public static int fromString(String text, GPT3Tokenizer tokenizer) {
        return TokenCount.getCalculator().countTokensFromString(text, tokenizer);
    }

    public static int fromMessages(List<ChatMessage> messages, GPT3Tokenizer tokenizer, ChatFormatDescriptor chatFormat) {
        return TokenCount.getCalculator().countTokensFromMessages(messages, tokenizer, chatFormat);
    }

    public static Calculator getCalculator() {
        return CalculatorHolder.instance;
    }

    public static interface Calculator {
        public int countTokensFromString(String var1, GPT3Tokenizer var2);

        public int countTokensFromMessages(List<ChatMessage> var1, GPT3Tokenizer var2, ChatFormatDescriptor var3);
    }

    private static final class CalculatorHolder {
        private static final Calculator instance = CalculatorHolder.loadCalculator();

        private CalculatorHolder() {
        }

        private static Calculator loadCalculator() {
            return ServiceLoader.load(Calculator.class).findFirst().orElseGet(StandardCalculator::new);
        }
    }

    public static class StandardCalculator
    implements Calculator {
        @Override
        public int countTokensFromString(String text, GPT3Tokenizer tokenizer) {
            return tokenizer.encode(text).size();
        }

        @Override
        public int countTokensFromMessages(List<ChatMessage> messages, GPT3Tokenizer tokenizer, ChatFormatDescriptor chatFormat) {
            int tokenCount = 0;
            for (ChatMessage message : messages) {
                tokenCount += chatFormat.extraTokenCountPerMessage();
                if (message.getRole() != null) {
                    tokenCount += tokenizer.encode(message.getRole()).size();
                }
                if (message.getContent() == null) continue;
                tokenCount += tokenizer.encode(message.getContent()).size();
            }
            return tokenCount += chatFormat.extraTokenCountPerRequest();
        }
    }
}

