/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.Encoding;
import java.util.Objects;

public interface ChatFormatDescriptor {
    public Encoding encoding();

    public int extraTokenCountPerMessage();

    public int extraTokenCountPerRequest();

    public int extraTokenCountForFunctions();

    public int extraTokenCountPerFunctionCall();

    public static ChatFormatDescriptor forModel(String modelName) {
        return switch (modelName) {
            case "gpt-3.5-turbo" -> ChatFormatDescriptor.forModel("gpt-3.5-turbo-0125");
            case "gpt-3.5-turbo-16k", "gpt-4", "gpt-4-32k" -> ChatFormatDescriptor.forModel("gpt-4-0613");
            case "gpt-3.5-turbo-0301" -> new Of(Encoding.forModel(modelName), 4, 3, Integer.MIN_VALUE, 3);
            case "gpt-4-0314", "gpt-4-32k-0314" -> new Of(Encoding.forModel(modelName), 3, 3, Integer.MIN_VALUE, 3);
            case "gpt-3.5-turbo-0613", "gpt-3.5-turbo-16k-0613", "gpt-3.5-turbo-1106", "gpt-3.5-turbo-0125", "gpt-4-0613", "gpt-4-32k-0613", "gpt-4-1106-preview", "gpt-4-turbo-preview" -> new Of(Encoding.forModel(modelName), 3, 3, -1, 3);
            default -> throw new IllegalArgumentException(String.format("Model `%s` not found", modelName));
        };
    }

    public record Of(Encoding encoding, int extraTokenCountPerMessage, int extraTokenCountPerRequest, int extraTokenCountForFunctions, int extraTokenCountPerFunctionCall) implements ChatFormatDescriptor
    {
        private final int extraTokenCountForFunctions;
        private static final int UNSUPPORTED = Integer.MIN_VALUE;

        public Of {
            Objects.requireNonNull(encoding, "encoding");
        }

        @Override
        public int extraTokenCountForFunctions() {
            if (this.extraTokenCountForFunctions == Integer.MIN_VALUE) {
                throw new UnsupportedOperationException("Functions aren't supported by this model");
            }
            return this.extraTokenCountForFunctions;
        }
    }
}

