/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.ChatFormatDescriptor;
import com.didalgo.gpt3.GPT3Tokenizer;
import com.didalgo.gpt3.ModelType;
import com.didalgo.gpt3.TokenCountSupport;
import com.didalgo.gpt3.TokenizableFunction;
import com.didalgo.gpt3.TokenizableFunctionCall;
import com.didalgo.gpt3.TokenizableMessage;
import com.didalgo.gpt3.TokenizableTool;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatMessage;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;

public class TokenCount {
    public static int fromLinesJoined(Iterable<String> lines, GPT3Tokenizer tokenizer) {
        int tokenCount = StreamSupport.stream(lines.spliterator(), false).mapToInt(line -> TokenCount.fromString(line, tokenizer) + 1).sum();
        return Math.max(0, tokenCount - 1);
    }

    public static int fromString(String text, GPT3Tokenizer tokenizer) {
        return TokenCount.getSupport().countTokensFromString(text, tokenizer);
    }

    public static int fromMessages(List<ChatMessage> messages, ModelType model) {
        return TokenCount.fromMessages(messages, List.of(), model);
    }

    public static int fromMessages(List<ChatMessage> messages, List<ChatFunction> functions, ModelType model) {
        return TokenCount.fromMessages(messages, functions, model.getTokenizer(), model.getChatFormatDescriptor());
    }

    public static int fromMessages(List<ChatMessage> messages, GPT3Tokenizer tokenizer, ChatFormatDescriptor chatFormat) {
        return TokenCount.fromMessages(messages, List.of(), tokenizer, chatFormat);
    }

    public static int fromMessages(List<ChatMessage> messages, List<ChatFunction> functions, GPT3Tokenizer tokenizer, ChatFormatDescriptor chatFormat) {
        return TokenCount.fromMessages(messages, TokenizableMessage.from(ChatMessage::getRole, ChatMessage::getContent, ChatMessage::getName, chatMessage -> chatMessage.getFunctionCall() == null ? TokenizableFunctionCall.NONE : TokenizableFunctionCall.of(chatMessage.getFunctionCall().getName(), chatMessage.getFunctionCall().getArguments().toString())), functions, TokenizableFunction.from(ChatFunction::getName, ChatFunction::getDescription, chatFunction -> TokenCount.getSupport().generateJsonSchema(chatFunction.getParametersClass())), chatFormat, tokenizer);
    }

    public static int fromMessages(List<? extends TokenizableMessage> messages, List<? extends TokenizableTool> tools, ChatFormatDescriptor chatFormat, GPT3Tokenizer tokenizer) {
        return TokenCount.fromMessages(messages, Function.identity(), tools, Function.identity(), chatFormat, tokenizer);
    }

    public static <T_MSG, T_TOOL> int fromMessages(List<T_MSG> messages, Function<T_MSG, ? extends TokenizableMessage> messageCoercer, List<T_TOOL> tools, Function<T_TOOL, ? extends TokenizableTool> toolCoercer, ChatFormatDescriptor chatFormat, GPT3Tokenizer tokenizer) {
        return TokenCount.getSupport().countTokensFromMessages(messages, messageCoercer, tools, toolCoercer, tokenizer, chatFormat);
    }

    private static TokenCountSupport getSupport() {
        return TokenCountSupport.getSupport();
    }
}

