/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.ChatFormatDescriptor;
import com.didalgo.gpt3.GPT3Tokenizer;
import com.didalgo.gpt3.TokenizableFunction;
import com.didalgo.gpt3.TokenizableFunctionCall;
import com.didalgo.gpt3.TokenizableMessage;
import com.didalgo.gpt3.TokenizableTool;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class TokenCountSupport {
    private static final FunctionDocumenter standardDocumenter = new StandardFunctionDocumenter();

    public int countTokensFromString(String text, GPT3Tokenizer tokenizer) {
        return tokenizer.encode(text).size();
    }

    public <T_MSG, T_TOOL> int countTokensFromMessages(List<T_MSG> messages, Function<T_MSG, ? extends TokenizableMessage> messageCoercer, List<T_TOOL> tools, Function<T_TOOL, ? extends TokenizableTool> toolCoercer, GPT3Tokenizer tokenizer, ChatFormatDescriptor chatFormat) {
        String toolsPrompt = "";
        if (!tools.isEmpty()) {
            List<? extends TokenizableTool> tokenizable = tools.stream().map(toolCoercer).toList();
            toolsPrompt = this.generateDocumentation(tokenizable);
        }
        int tokenCount = 0;
        for (int index = 0; index < messages.size(); ++index) {
            TokenizableFunctionCall functionCall;
            Object content;
            TokenizableMessage tokenizable = messageCoercer.apply(messages.get(index));
            tokenCount += chatFormat.extraTokenCountPerMessage();
            CharSequence role = tokenizable.role();
            if (role != null && !role.isEmpty()) {
                tokenCount += tokenizer.encode(role).size();
            }
            if ((content = tokenizable.content()) != null && role != null && index == 0 && "system".equals(role.toString())) {
                content = (CharSequence)content + "\n\n" + toolsPrompt;
                toolsPrompt = "";
            }
            if (content != null) {
                tokenCount += tokenizer.encode((CharSequence)content).size();
            }
            if (!(functionCall = tokenizable.functionCall()).isPresent()) continue;
            tokenCount += tokenizer.encode(functionCall.name()).size();
            tokenCount += tokenizer.encode(functionCall.arguments()).size();
            tokenCount += chatFormat.extraTokenCountPerFunctionCall();
        }
        tokenCount += chatFormat.extraTokenCountPerRequest();
        if (!tools.isEmpty()) {
            if (!toolsPrompt.isEmpty()) {
                tokenCount += chatFormat.extraTokenCountPerMessage();
                tokenCount += tokenizer.encode("system").size();
                tokenCount += tokenizer.encode(toolsPrompt).size();
            }
            tokenCount += chatFormat.extraTokenCountForFunctions();
        }
        return tokenCount;
    }

    public JsonObject generateJsonSchema(Class<?> valueType) {
        JsonNode schemaNode = JsonSchemaUtils.generateSchema(valueType);
        return Json.createReader((Reader)new StringReader(schemaNode.toString())).readObject();
    }

    public static TokenCountSupport getSupport() {
        return LazyHolder.INSTANCE;
    }

    public String generateDocumentation(List<? extends TokenizableTool> tools) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Tools\n\n");
        Map<String, List<TokenizableTool>> toolsByCategory = tools.stream().collect(Collectors.groupingBy(TokenizableTool::toolCategory));
        for (Map.Entry<String, List<TokenizableTool>> categoryEntry : toolsByCategory.entrySet()) {
            sb.append("## ").append(categoryEntry.getKey()).append("\n\n");
            Map<String, List<TokenizableTool>> toolsByNamespace = categoryEntry.getValue().stream().collect(Collectors.groupingBy(TokenizableTool::toolNamespace));
            for (Map.Entry<String, List<TokenizableTool>> namespaceEntry : toolsByNamespace.entrySet()) {
                sb.append("namespace ").append(namespaceEntry.getKey()).append(" {\n\n");
                for (TokenizableTool tool : namespaceEntry.getValue()) {
                    sb.append(tool.generateDocumentation()).append("\n\n");
                }
                sb.append("} // namespace ").append(namespaceEntry.getKey()).append("\n\n");
            }
        }
        return sb.toString().stripTrailing();
    }

    public FunctionDocumenter getFunctionDocumenter(TokenizableFunction function) {
        return standardDocumenter;
    }

    private static final class JsonSchemaUtils {
        private static final Comparator<MemberScope<?, ?>> DECLARATION_ORDER = (__, ___) -> 0;
        private static final ObjectMapper mapper = new ObjectMapper();
        private static final SchemaGenerator generator;

        private JsonSchemaUtils() {
        }

        public static JsonNode generateSchema(Class<?> valueType) {
            return generator.generateSchema(valueType, new Type[0]);
        }

        static {
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(mapper, SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON).with((Module)new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED}));
            configBuilder.forTypesInGeneral().withPropertySorter(DECLARATION_ORDER);
            generator = new SchemaGenerator(configBuilder.build());
        }
    }

    private static final class LazyHolder {
        private static final TokenCountSupport INSTANCE = ServiceLoader.load(TokenCountSupport.class).findFirst().orElseGet(TokenCountSupport::new);

        private LazyHolder() {
        }
    }

    public static interface FunctionDocumenter {
        public CharSequence generateDocumentation(TokenizableFunction var1);
    }

    private static class StandardFunctionDocumenter
    implements FunctionDocumenter {
        private StandardFunctionDocumenter() {
        }

        @Override
        public String generateDocumentation(TokenizableFunction function) {
            JsonObject params = function.parameters();
            StringBuilder buf = new StringBuilder();
            if (!function.description().isEmpty()) {
                StandardFunctionDocumenter.putDescription(buf, function.description());
            }
            StandardFunctionDocumenter.putName(buf, function.name());
            StandardFunctionDocumenter.putParameters(buf, (Map<String, JsonValue>)params, "");
            StandardFunctionDocumenter.putEnd(buf);
            return buf.toString();
        }

        private static void putDescription(StringBuilder buf, JsonObject schema) {
            String description = schema.getString("description", "").strip();
            StandardFunctionDocumenter.putDescription(buf, description);
        }

        private static void putDescription(StringBuilder buf, String description) {
            if (!description.isEmpty()) {
                description.lines().forEach(line -> buf.append("// ").append((String)line).append('\n'));
            }
        }

        private static void putName(StringBuilder buf, String name) {
            buf.append("type ").append(name).append(" = (_: ");
        }

        private static void putParameters(StringBuilder buf, Map<String, JsonValue> schema, String indent) {
            JsonObject properties = schema.getOrDefault("properties", (JsonValue)JsonValue.EMPTY_JSON_OBJECT).asJsonObject();
            JsonArray required = schema.getOrDefault("required", (JsonValue)JsonValue.EMPTY_JSON_ARRAY).asJsonArray();
            JsonObject definitions = schema.getOrDefault("definitions", (JsonValue)JsonValue.EMPTY_JSON_OBJECT).asJsonObject();
            StandardFunctionDocumenter.putProperties(buf, properties, required.getValuesAs(JsonString::getString), (Map<String, JsonValue>)definitions, indent);
        }

        private static void putProperties(StringBuilder buf, JsonObject schema, List<String> required, Map<String, JsonValue> definitions, String indent) {
            buf.append("{\n");
            schema.forEach((name, value) -> {
                JsonObject valueDesc = value.asJsonObject();
                if (indent.isEmpty()) {
                    StandardFunctionDocumenter.putDescription(buf, valueDesc);
                }
                buf.append(indent);
                buf.append((String)name);
                if (!StandardFunctionDocumenter.isNested(indent) && !required.contains(name)) {
                    buf.append('?');
                }
                buf.append(": ");
                StandardFunctionDocumenter.putParameterType(buf, valueDesc, indent);
                buf.append(",\n");
            });
            buf.append("}");
        }

        private static void putParameterType(StringBuilder buf, JsonObject valueDesc, String indent) {
            JsonObject arrayDesc;
            JsonValue typeDesc = (JsonValue)valueDesc.get((Object)"type");
            if (typeDesc == null || typeDesc.getValueType() != JsonValue.ValueType.STRING) {
                buf.append("any");
                return;
            }
            if (valueDesc.containsKey((Object)"enum")) {
                buf.append(String.join((CharSequence)" | ", valueDesc.getJsonArray("enum").getValuesAs(JsonValue::toString)));
                return;
            }
            Object object = valueDesc.get((Object)"items");
            if (object instanceof JsonObject && (arrayDesc = (JsonObject)object).containsKey((Object)"type")) {
                StandardFunctionDocumenter.putParameterType(buf, arrayDesc, indent);
                buf.append("[]");
                return;
            }
            String typeName = valueDesc.getString("type", "any");
            switch (typeName) {
                case "integer": 
                case "number": {
                    buf.append("number");
                    break;
                }
                case "boolean": 
                case "string": {
                    buf.append(typeName);
                    break;
                }
                case "object": {
                    StandardFunctionDocumenter.putParameters(buf, (Map<String, JsonValue>)valueDesc, "  ");
                    break;
                }
                default: {
                    buf.append("any");
                }
            }
        }

        private static void putEnd(StringBuilder buf) {
            buf.append(") => any;");
        }

        private static boolean isNested(String indent) {
            return !indent.isEmpty();
        }
    }
}

