/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.TokenCountSupport;
import com.didalgo.gpt3.TokenizableTool;
import java.util.function.Function;
import javax.json.JsonObject;
import javax.json.JsonValue;

public interface TokenizableFunction
extends TokenizableTool {
    public String name();

    public String description();

    public JsonObject parameters();

    @Override
    default public CharSequence generateDocumentation() {
        return TokenCountSupport.getSupport().getFunctionDocumenter(this).generateDocumentation(this);
    }

    @Override
    default public String toolCategory() {
        return "functions";
    }

    @Override
    default public String toolNamespace() {
        return "functions";
    }

    public static <T> Function<T, TokenizableFunction> from(Function<T, String> nameAccessor, Function<T, String> descAccessor, Function<T, JsonObject> paramsAccessor) {
        return function -> TokenizableFunction.of((String)nameAccessor.apply(function), (String)descAccessor.apply(function), (JsonObject)paramsAccessor.apply(function));
    }

    public static TokenizableFunction of(String name, String description, JsonObject parameters) {
        return new Of(name, description, parameters);
    }

    public record Of(String name, String description, JsonObject parameters) implements TokenizableFunction
    {
        public Of {
            name = Of.firstOrElse(name, "");
            description = Of.firstOrElse(description, "");
            parameters = Of.firstOrElse(parameters, JsonValue.EMPTY_JSON_OBJECT);
        }

        private static <V> V firstOrElse(V first, V orElse) {
            return first != null ? first : orElse;
        }
    }
}

