/*
 * Decompiled with CFR 0.152.
 */
package com.didalgo.gpt3;

import com.didalgo.gpt3.TokenizableFunctionCall;
import java.util.function.Function;

public interface TokenizableMessage {
    public CharSequence role();

    public CharSequence content();

    public CharSequence name();

    public TokenizableFunctionCall functionCall();

    public static <T> Function<T, TokenizableMessage> from(Function<T, ? extends CharSequence> roleAccessor, Function<T, ? extends CharSequence> contentAccessor, Function<T, ? extends CharSequence> nameAccessor, Function<T, ? extends TokenizableFunctionCall> functionCallMaker) {
        return message -> TokenizableMessage.of((CharSequence)roleAccessor.apply(message), (CharSequence)contentAccessor.apply(message), (CharSequence)nameAccessor.apply(message), (TokenizableFunctionCall)functionCallMaker.apply(message));
    }

    public static TokenizableMessage of(CharSequence role, CharSequence content) {
        return TokenizableMessage.of(role, content, "", TokenizableFunctionCall.NONE);
    }

    public static TokenizableMessage of(CharSequence role, TokenizableFunctionCall functionCall) {
        return TokenizableMessage.of(role, "", "", functionCall);
    }

    public static TokenizableMessage of(CharSequence role, CharSequence content, CharSequence name) {
        return new Of(role, content, name, TokenizableFunctionCall.NONE);
    }

    public static TokenizableMessage of(CharSequence role, CharSequence content, CharSequence name, TokenizableFunctionCall functionCall) {
        return new Of(role, content, name, functionCall);
    }

    public record Of(CharSequence role, CharSequence content, CharSequence name, TokenizableFunctionCall functionCall) implements TokenizableMessage
    {
        public Of {
            role = Of.firstOrElse(role, "");
            content = Of.firstOrElse(content, "");
            name = Of.firstOrElse(name, "");
            functionCall = Of.firstOrElse(functionCall, TokenizableFunctionCall.NONE);
        }

        private static <V> V firstOrElse(V first, V orElse) {
            return first != null ? first : orElse;
        }
    }
}

