/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.aapt2;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017J\u0016\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020\u0017J\u000e\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020\u0017J\u000e\u00100\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017J\u000e\u00101\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017J\u000e\u00102\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017J%\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H406\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020%J\u000e\u00109\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0017J\u0006\u0010:\u001a\u00020*J\u0006\u0010;\u001a\u00020\u0017J\u0006\u0010<\u001a\u00020-J\u0006\u0010=\u001a\u00020/J\u0006\u0010>\u001a\u00020\u0017J\u0006\u0010?\u001a\u00020\u0017J\u0006\u0010@\u001a\u00020\u0017J\u0006\u0010A\u001a\u00020\u0017J\u0006\u0010B\u001a\u00020\u0017J\u0016\u0010C\u001a\n D*\u0004\u0018\u00010\u00030\u00032\u0006\u0010E\u001a\u00020\u0017J\u0016\u0010F\u001a\n D*\u0004\u0018\u00010\u00030\u00032\u0006\u0010G\u001a\u00020\u0017J\u0006\u0010H\u001a\u00020\u0017R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019\u00a8\u0006I"}, d2={"Lcom/didiglobal/booster/aapt2/BinaryParser;", "Ljava/io/Closeable;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "", "([B)V", "file", "Ljava/io/File;", "order", "Ljava/nio/ByteOrder;", "(Ljava/io/File;Ljava/nio/ByteOrder;)V", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/nio/ByteOrder;)V", "_buffer", "_channel", "Ljava/nio/channels/FileChannel;", "_file", "", "getBuffer$booster_aapt2", "()Ljava/nio/ByteBuffer;", "capacity", "", "getCapacity", "()I", "getFile$booster_aapt2", "()Ljava/lang/String;", "hasRemaining", "", "getHasRemaining", "()Z", "remaining", "getRemaining", "close", "", "getByte", "", "index", "getBytes", "size", "getChar", "", "getInt", "getLong", "", "getShort", "", "getUByte", "getUInt", "getUShort", "parse", "T", "handler", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readByte", "readBytes", "readChar", "readInt", "readLong", "readShort", "readSleb128", "readUByte", "readUInt", "readUShort", "readUleb128", "seek", "kotlin.jvm.PlatformType", "pos", "skip", "n", "tell", "booster-aapt2"})
public final class BinaryParser
implements Closeable {
    @NotNull
    private final ByteBuffer _buffer;
    @Nullable
    private final FileChannel _channel;
    @NotNull
    private final String _file;

    public BinaryParser(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this._buffer = buffer;
        this._channel = null;
        this._file = "<buffer>";
    }

    public BinaryParser(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(buffer)");
        this(byteBuffer);
    }

    public BinaryParser(@NotNull File file, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        this._channel = FileChannel.open(file.toPath(), openOptionArray);
        ByteBuffer byteBuffer = this._channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length()).order(order);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"_channel.map(FileChannel\u2026le.length()).order(order)");
        this._buffer = byteBuffer;
        String string = file.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.canonicalPath");
        this._file = string;
    }

    public /* synthetic */ BinaryParser(File file, ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        this(file, byteOrder);
    }

    public BinaryParser(@NotNull InputStream input, @NotNull ByteOrder order) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)order, (String)"order");
        ByteBuffer byteBuffer = ByteBuffer.wrap(ByteStreamsKt.readBytes((InputStream)input)).order(order);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(input.readBytes()).order(order)");
        this(byteBuffer);
    }

    public /* synthetic */ BinaryParser(InputStream inputStream, ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ByteOrder byteOrder2 = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"LITTLE_ENDIAN");
            byteOrder = byteOrder2;
        }
        this(inputStream, byteOrder);
    }

    @NotNull
    public final ByteBuffer getBuffer$booster_aapt2() {
        return this._buffer;
    }

    @NotNull
    public final String getFile$booster_aapt2() {
        return this._file;
    }

    public final int getCapacity() {
        return this._buffer.capacity();
    }

    public final int getRemaining() {
        return this._buffer.remaining();
    }

    public final boolean getHasRemaining() {
        return this._buffer.hasRemaining();
    }

    public final <T> T parse(@NotNull Function1<? super ByteBuffer, ? extends T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return (T)handler.invoke((Object)this._buffer);
    }

    public final byte readByte() {
        return this._buffer.get();
    }

    public final byte getByte(int index) {
        return this._buffer.get(index);
    }

    public final short readShort() {
        return this._buffer.getShort();
    }

    public final short getShort(int index) {
        return this._buffer.getShort(index);
    }

    public final char readChar() {
        return this._buffer.getChar();
    }

    public final char getChar(int index) {
        return this._buffer.getChar(index);
    }

    public final int readInt() {
        return this._buffer.getInt();
    }

    public final int getInt(int index) {
        return this._buffer.getInt(index);
    }

    public final long readLong() {
        return this._buffer.getLong();
    }

    public final long getLong(int index) {
        return this._buffer.getLong(index);
    }

    @NotNull
    public final byte[] readBytes(int size) {
        byte[] byArray;
        byte[] it = byArray = new byte[size];
        boolean bl = false;
        this._buffer.get(it);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getBytes(int size, int index) {
        int p = this.tell();
        try {
            this.seek(index);
            byte[] byArray = this.readBytes(size);
            return byArray;
        }
        finally {
            this.seek(p);
        }
    }

    public final int readUByte() {
        return this._buffer.get() & 0xFF;
    }

    public final int readUShort() {
        return this._buffer.getShort() & 0xFFFF;
    }

    public final int readUInt() {
        return this._buffer.getInt();
    }

    public final int getUByte(int index) {
        return this._buffer.get(index) & 0xFF;
    }

    public final int getUShort(int index) {
        return this._buffer.getShort(index) & 0xFFFF;
    }

    public final int getUInt(int index) {
        return this._buffer.getInt(index);
    }

    public final int readUleb128() {
        int result = 0;
        int count = 0;
        int cur = 0;
        do {
            cur = this._buffer.get() & 0xFF;
            result |= (cur & 0x7F) << count * 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new RuntimeException("Invalid LEB128 sequence");
        }
        return result;
    }

    public final int readSleb128() {
        int result = 0;
        int cur = 0;
        int count = 0;
        int signBits = -1;
        do {
            cur = this.readByte() & 0xFF;
            result |= (cur & 0x7F) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new RuntimeException("Invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0) {
            result |= signBits;
        }
        return result;
    }

    public final ByteBuffer skip(int n) {
        return this._buffer.position(this._buffer.position() + n);
    }

    public final ByteBuffer seek(int pos) {
        return this._buffer.position(pos);
    }

    public final int tell() {
        return this._buffer.position();
    }

    @Override
    public void close() {
        block0: {
            FileChannel fileChannel = this._channel;
            if (fileChannel == null) break block0;
            fileChannel.close();
        }
    }
}

