/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.gradle;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.api.artifact.SourceArtifactType;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.sdklib.BuildToolInfo;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

class VariantScopeV32 {
    VariantScopeV32() {
    }

    @NotNull
    static BaseExtension getExtension(@NotNull VariantScope scope) {
        return (BaseExtension)scope.getGlobalScope().getExtension();
    }

    @NotNull
    static Collection<File> getMergedManifests(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.MERGED_MANIFESTS);
    }

    @NotNull
    static Collection<File> getMergedRes(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.MERGED_RES);
    }

    @NotNull
    static Collection<File> getMergedAssets(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.MERGED_ASSETS);
    }

    @NotNull
    static Collection<File> getProcessedRes(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.PROCESSED_RES);
    }

    @NotNull
    static Collection<File> getAllClasses(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)AnchorOutputType.ALL_CLASSES);
    }

    @NotNull
    static Collection<File> getSymbolList(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.SYMBOL_LIST);
    }

    @NotNull
    static Collection<File> getSymbolListWithPackageName(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.SYMBOL_LIST_WITH_PACKAGE_NAME);
    }

    @NotNull
    static Collection<File> getAar(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.AAR);
    }

    @NotNull
    static Collection<File> getApk(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.APK);
    }

    @NotNull
    static Collection<File> getJavac(@NotNull VariantScope scope) {
        return VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)InternalArtifactType.JAVAC);
    }

    @NotNull
    static Map<String, Collection<File>> getAllArtifacts(@NotNull VariantScope scope) {
        return Stream.of(AnchorOutputType.values(), BuildArtifactType.values(), SourceArtifactType.values(), InternalArtifactType.values()).flatMap(Arrays::stream).collect(Collectors.toMap(Enum::name, v -> VariantScopeV32.getFinalArtifactFiles(scope, (ArtifactType)v)));
    }

    @NotNull
    static Collection<File> getFinalArtifactFiles(@NotNull VariantScope scope, @NotNull ArtifactType type) {
        return scope.getArtifacts().getFinalArtifactFiles(type).getFiles();
    }

    @NotNull
    static BuildToolInfo getBuildTools(@NotNull VariantScope scope) {
        return scope.getGlobalScope().getAndroidBuilder().getBuildToolInfo();
    }

    @NotNull
    static File getDataBindingDependencyArtifacts(@NotNull VariantScope scope) {
        return ((FileCollection)scope.getArtifacts().getFinalArtifactFiles((ArtifactType)InternalArtifactType.DATA_BINDING_DEPENDENCY_ARTIFACTS).get()).getSingleFile();
    }
}

