/*
 * Decompiled with CFR 0.152.
 */
package com.didiglobal.booster.gradle;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.Variant;
import com.android.build.api.variant.VariantBuilder;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.BaseVariant;
import com.didiglobal.booster.gradle.BoosterPlugin;
import com.didiglobal.booster.gradle.BoosterTransformTask;
import com.didiglobal.booster.gradle.ServiceLoaderKt;
import com.didiglobal.booster.kotlinx.TextKt;
import com.didiglobal.booster.task.spi.VariantProcessor;
import com.didiglobal.booster.transform.Transformer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001a\u0010\t\u001a\u00020\u0005*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001a\u0010\r\u001a\u00020\u0005*\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/didiglobal/booster/gradle/BoosterPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "registerTransform", "setupTasks", "legacySetup", "processors", "", "Lcom/didiglobal/booster/task/spi/VariantProcessor;", "setup", "booster-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBoosterPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoosterPlugin.kt\ncom/didiglobal/booster/gradle/BoosterPlugin\n+ 2 AGPInterface.kt\ncom/didiglobal/booster/gradle/AGPInterfaceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n178#2:95\n1#3:96\n1855#4:97\n1855#4,2:98\n1856#4:100\n*S KotlinDebug\n*F\n+ 1 BoosterPlugin.kt\ncom/didiglobal/booster/gradle/BoosterPlugin\n*L\n57#1:95\n63#1:97\n64#1:98,2\n63#1:100\n*E\n"})
public final class BoosterPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.getExtensions().findByName("android") == null) {
            throw new GradleException(project + " is not an Android project");
        }
        this.registerTransform(project);
        this.setupTasks(project);
    }

    private final void setupTasks(Project project) {
        List<VariantProcessor> processors = ServiceLoaderKt.loadVariantProcessors(project);
        this.setup(project, processors);
        if (project.getState().getExecuted()) {
            this.legacySetup(project, processors);
        } else {
            project.afterEvaluate(arg_0 -> BoosterPlugin.setupTasks$lambda$0((Function1)new Function1<Project, Unit>(this, project, processors){
                final /* synthetic */ BoosterPlugin this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ List<VariantProcessor> $processors;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$processors = $processors;
                    super(1);
                }

                public final void invoke(Project it) {
                    BoosterPlugin.access$legacySetup(this.this$0, this.$project, this.$processors);
                }
            }, arg_0));
        }
    }

    private final void setup(Project $this$setup, List<? extends VariantProcessor> processors) {
        AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)$this$setup.getProject().getExtensions().getByType(AndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
        AndroidComponentsExtension.beforeVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<VariantBuilder, Unit>(processors){
            final /* synthetic */ List<VariantProcessor> $processors;
            {
                this.$processors = $processors;
                super(1);
            }

            public final void invoke(@NotNull VariantBuilder variantBuilder) {
                Intrinsics.checkNotNullParameter((Object)variantBuilder, (String)"variantBuilder");
                Iterable $this$forEach$iv = this.$processors;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VariantProcessor processor = (VariantProcessor)element$iv;
                    boolean bl = false;
                    processor.beforeProcess(variantBuilder);
                }
            }
        }), (int)1, null);
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<Variant, Unit>(processors){
            final /* synthetic */ List<VariantProcessor> $processors;
            {
                this.$processors = $processors;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                Iterable $this$forEach$iv = this.$processors;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VariantProcessor processor = (VariantProcessor)element$iv;
                    boolean bl = false;
                    processor.process(variant);
                }
            }
        }), (int)1, null);
    }

    private final void legacySetup(Project $this$legacySetup, List<? extends VariantProcessor> processors) {
        block3: {
            Project project = $this$legacySetup.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$getAndroid$iv = project;
            boolean $i$f$getAndroid = false;
            Object object = $this$getAndroid$iv.getExtensions().getByName("android");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
            }
            BaseExtension android = (BaseExtension)object;
            Object object2 = android;
            Object p0 = object2 = object2 instanceof AppExtension ? (Collection)((AppExtension)android).getApplicationVariants() : (object2 instanceof LibraryExtension ? (Collection)((LibraryExtension)android).getLibraryVariants() : (Collection)CollectionsKt.emptyList());
            boolean bl = false;
            Object object3 = !p0.isEmpty() ? object2 : null;
            if (object3 == null) break block3;
            Object variants = object3;
            boolean bl2 = false;
            Iterable $this$forEach$iv = (Iterable)variants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BaseVariant variant = (BaseVariant)element$iv;
                boolean bl3 = false;
                Iterable $this$forEach$iv2 = processors;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    VariantProcessor processor = (VariantProcessor)element$iv2;
                    boolean bl4 = false;
                    processor.process(variant);
                }
            }
        }
    }

    private final void registerTransform(Project project) {
        AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<Variant, Unit>(project, androidComponents){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidComponentsExtension<?, ?, ?> $androidComponents;
            {
                this.$project = $project;
                this.$androidComponents = $androidComponents;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                TaskProvider transform2 = this.$project.getTasks().register("transform" + TextKt.capitalized((String)variant.getName()) + "ClassesWithBooster", BoosterTransformTask.class, arg_0 -> registerTransform.1.invoke$lambda$0((Function1)new Function1<BoosterTransformTask, Unit>(this.$project, variant, this.$androidComponents){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Variant $variant;
                    final /* synthetic */ AndroidComponentsExtension<?, ?, ?> $androidComponents;
                    {
                        this.$project = $project;
                        this.$variant = $variant;
                        this.$androidComponents = $androidComponents;
                        super(1);
                    }

                    public final void invoke(BoosterTransformTask it) {
                        ClassLoader classLoader = this.$project.getBuildscript().getClassLoader();
                        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"project.buildscript.classLoader");
                        it.setTransformers((Collection<? extends Transformer>)ServiceLoaderKt.loadTransformers(classLoader));
                        it.setVariant(this.$variant);
                        Object object = this.$variant.getNamespace().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.namespace.get()");
                        it.setApplicationId((String)object);
                        it.setBootClasspath((Provider<List<RegularFile>>)this.$androidComponents.getSdkComponents().getBootClasspath());
                    }
                }, arg_0));
                ScopedArtifacts scopedArtifacts = variant.getArtifacts().forScope(ScopedArtifacts.Scope.ALL);
                Intrinsics.checkNotNullExpressionValue((Object)transform2, (String)"transform");
                scopedArtifacts.use(transform2).toTransform((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, (Function1)registerTransform.1.INSTANCE, (Function1)registerTransform.2.INSTANCE, (Function1)registerTransform.3.INSTANCE);
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }), (int)1, null);
    }

    private static final void setupTasks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$legacySetup(BoosterPlugin $this, Project $receiver, List processors) {
        $this.legacySetup($receiver, processors);
    }
}

